/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SQLNestedException
extends SQLException {
    private static final Method THROWABLE_CAUSE_METHOD;
    private Throwable cause = null;

    private static boolean hasThrowableCauseMethod() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public SQLNestedException(String msg, Throwable cause) {
        super(msg);
        this.cause = cause;
        if (cause != null && DriverManager.getLogWriter() != null) {
            DriverManager.getLogWriter().print("Caused by: ");
            cause.printStackTrace(DriverManager.getLogWriter());
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.cause != null && !SQLNestedException.hasThrowableCauseMethod()) {
            s.print("Caused by: ");
            this.cause.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.cause != null && !SQLNestedException.hasThrowableCauseMethod()) {
            s.print("Caused by: ");
            this.cause.printStackTrace(s);
        }
    }

    static {
        Method getCauseMethod;
        try {
            getCauseMethod = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception e) {
            getCauseMethod = null;
        }
        THROWABLE_CAUSE_METHOD = getCauseMethod;
    }
}

