/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.Util;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PerInterface<M> {
    private final Class<?> mbeanInterface;
    private final MBeanIntrospector<M> introspector;
    private final MBeanInfo mbeanInfo;
    private final Map<String, M> getters = Util.newMap();
    private final Map<String, M> setters = Util.newMap();
    private final Map<String, List<MethodAndSig>> ops = Util.newMap();

    PerInterface(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector, MBeanAnalyzer<M> mBeanAnalyzer, MBeanInfo mBeanInfo) {
        this.mbeanInterface = clazz;
        this.introspector = mBeanIntrospector;
        this.mbeanInfo = mBeanInfo;
        mBeanAnalyzer.visit(new InitMaps());
    }

    Class<?> getMBeanInterface() {
        return this.mbeanInterface;
    }

    MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    boolean isMXBean() {
        return this.introspector.isMXBean();
    }

    Object getAttribute(Object object, String string, Object object2) throws AttributeNotFoundException, MBeanException, ReflectionException {
        M m = this.getters.get(string);
        if (m == null) {
            String string2 = this.setters.containsKey(string) ? "Write-only attribute: " + string : "No such attribute: " + string;
            throw new AttributeNotFoundException(string2);
        }
        return this.introspector.invokeM(m, object, null, object2);
    }

    void setAttribute(Object object, String string, Object object2, Object object3) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        M m = this.setters.get(string);
        if (m == null) {
            String string2 = this.getters.containsKey(string) ? "Read-only attribute: " + string : "No such attribute: " + string;
            throw new AttributeNotFoundException(string2);
        }
        this.introspector.invokeSetter(string, m, object, object2, object3);
    }

    /*
     * WARNING - void declaration
     */
    Object invoke(Object object, String string, Object[] objectArray, String[] stringArray, Object object2) throws MBeanException, ReflectionException {
        List<MethodAndSig> list = this.ops.get(string);
        if (list == null) {
            String string2 = "No such operation: " + string;
            return this.noSuchMethod(string2, object, string, objectArray, stringArray, object2);
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        MethodAndSig methodAndSig = null;
        for (MethodAndSig object3 : list) {
            if (!Arrays.equals(object3.signature, stringArray)) continue;
            methodAndSig = object3;
            break;
        }
        if (methodAndSig == null) {
            void var9_13;
            String string3 = this.sigString(stringArray);
            if (list.size() == 1) {
                String string2 = "Signature mismatch for operation " + string + ": " + (String)string3 + " should be " + this.sigString(list.get((int)0).signature);
            } else {
                String string4 = "Operation " + string + " exists but not with " + "this signature: " + (String)string3;
            }
            return this.noSuchMethod((String)var9_13, object, string, objectArray, stringArray, object2);
        }
        return this.introspector.invokeM(methodAndSig.method, object, objectArray, object2);
    }

    private Object noSuchMethod(String string, Object object, String string2, Object[] objectArray, String[] stringArray, Object object2) throws MBeanException, ReflectionException {
        String string3;
        M m;
        String string4;
        NoSuchMethodException noSuchMethodException = new NoSuchMethodException(string2 + this.sigString(stringArray));
        ReflectionException reflectionException = new ReflectionException(noSuchMethodException, string);
        if (this.introspector.isMXBean()) {
            throw reflectionException;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.invoke.getters");
        try {
            string4 = AccessController.doPrivileged(getPropertyAction);
        }
        catch (Exception exception) {
            string4 = null;
        }
        if (string4 == null) {
            throw reflectionException;
        }
        int n = 0;
        Map<String, M> map = null;
        if (stringArray == null || stringArray.length == 0) {
            if (string2.startsWith("get")) {
                n = 3;
            } else if (string2.startsWith("is")) {
                n = 2;
            }
            if (n != 0) {
                map = this.getters;
            }
        } else if (stringArray != null && stringArray.length == 1 && string2.startsWith("set")) {
            n = 3;
            map = this.setters;
        }
        if (n != 0 && (m = map.get(string3 = string2.substring(n))) != null && this.introspector.getName(m).equals(string2)) {
            Object[] objectArray2 = this.introspector.getSignature(m);
            if (stringArray == null && objectArray2.length == 0 || Arrays.equals(stringArray, objectArray2)) {
                return this.introspector.invokeM(m, object, objectArray, object2);
            }
        }
        throw reflectionException;
    }

    private String sigString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (stringArray != null) {
            for (String string : stringArray) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.append(")").toString();
    }

    private class MethodAndSig {
        M method;
        String[] signature;

        private MethodAndSig() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitMaps
    implements MBeanAnalyzer.MBeanVisitor<M> {
        private InitMaps() {
        }

        @Override
        public void visitAttribute(String string, M m, M m2) {
            Object m3;
            if (m != null) {
                PerInterface.this.introspector.checkMethod(m);
                m3 = PerInterface.this.getters.put(string, m);
                assert (m3 == null);
            }
            if (m2 != null) {
                PerInterface.this.introspector.checkMethod(m2);
                m3 = PerInterface.this.setters.put(string, m2);
                assert (m3 == null);
            }
        }

        @Override
        public void visitOperation(String string, M m) {
            PerInterface.this.introspector.checkMethod(m);
            String[] stringArray = PerInterface.this.introspector.getSignature(m);
            MethodAndSig methodAndSig = new MethodAndSig();
            methodAndSig.method = m;
            methodAndSig.signature = stringArray;
            List<MethodAndSig> list = (List<MethodAndSig>)PerInterface.this.ops.get(string);
            if (list == null) {
                list = Collections.singletonList(methodAndSig);
            } else {
                if (list.size() == 1) {
                    list = Util.newList(list);
                }
                list.add(methodAndSig);
            }
            PerInterface.this.ops.put(string, list);
        }
    }
}

