/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.util.ReadOnlyPropertyException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertySet {
    Set<Map.Entry<String, Object>> mapViewCore;

    protected PropertySet() {
    }

    protected abstract PropertyMap getPropertyMap();

    protected static PropertyMap parse(final Class clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<PropertyMap>(){

            @Override
            public PropertyMap run() {
                PropertyMap propertyMap = new PropertyMap();
                for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                    Property property;
                    for (Field field : clazz2.getDeclaredFields()) {
                        property = field.getAnnotation(Property.class);
                        if (property == null) continue;
                        for (String string : property.value()) {
                            propertyMap.put(string, new FieldAccessor(field, string));
                        }
                    }
                    for (AccessibleObject accessibleObject : clazz2.getDeclaredMethods()) {
                        Method method;
                        property = ((Method)accessibleObject).getAnnotation(Property.class);
                        if (property == null) continue;
                        String string = ((Method)accessibleObject).getName();
                        assert (string.startsWith("get"));
                        String string2 = 's' + string.substring(1);
                        try {
                            method = clazz.getMethod(string2, ((Method)accessibleObject).getReturnType());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            method = null;
                        }
                        for (String string3 : property.value()) {
                            propertyMap.put(string3, new MethodAccessor((Method)accessibleObject, method, string3));
                        }
                    }
                }
                return propertyMap;
            }
        });
    }

    public final boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        Accessor accessor = (Accessor)this.getPropertyMap().get(object);
        if (accessor != null) {
            return accessor.get(this);
        }
        throw new IllegalArgumentException("Undefined property " + object);
    }

    public Object put(String string, Object object) {
        Accessor accessor = (Accessor)this.getPropertyMap().get(string);
        if (accessor != null) {
            Object object2 = accessor.get(this);
            accessor.set(this, object);
            return object2;
        }
        throw new IllegalArgumentException("Undefined property " + string);
    }

    public boolean supports(Object object) {
        return this.getPropertyMap().containsKey(object);
    }

    public Object remove(Object object) {
        Accessor accessor = (Accessor)this.getPropertyMap().get(object);
        if (accessor != null) {
            Object object2 = accessor.get(this);
            accessor.set(this, null);
            return object2;
        }
        throw new IllegalArgumentException("Undefined property " + object);
    }

    public final Map<String, Object> createMapView() {
        final HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>();
        this.createEntrySet(hashSet);
        return new AbstractMap<String, Object>(){

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return hashSet;
            }
        };
    }

    void createEntrySet(Set<Map.Entry<String, Object>> set) {
        for (final Map.Entry entry : this.getPropertyMap().entrySet()) {
            set.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public Object getValue() {
                    return ((Accessor)entry.getValue()).get(PropertySet.this);
                }

                @Override
                public Object setValue(Object object) {
                    Accessor accessor = (Accessor)entry.getValue();
                    Object object2 = accessor.get(PropertySet.this);
                    accessor.set(PropertySet.this, object);
                    return object2;
                }
            });
        }
    }

    static final class MethodAccessor
    implements Accessor {
        @NotNull
        private final Method getter;
        @Nullable
        private final Method setter;
        private final String name;

        protected MethodAccessor(Method method, Method method2, String string) {
            this.getter = method;
            this.setter = method2;
            this.name = string;
            method.setAccessible(true);
            if (method2 != null) {
                method2.setAccessible(true);
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean hasValue(PropertySet propertySet) {
            return this.get(propertySet) != null;
        }

        public Object get(PropertySet propertySet) {
            try {
                return this.getter.invoke(propertySet, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.handle(invocationTargetException);
                return 0;
            }
        }

        public void set(PropertySet propertySet, Object object) {
            if (this.setter == null) {
                throw new ReadOnlyPropertyException(this.getName());
            }
            try {
                this.setter.invoke(propertySet, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.handle(invocationTargetException);
            }
        }

        private Exception handle(InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new Error(invocationTargetException);
        }
    }

    static final class FieldAccessor
    implements Accessor {
        private final Field f;
        private final String name;

        protected FieldAccessor(Field field, String string) {
            this.f = field;
            field.setAccessible(true);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasValue(PropertySet propertySet) {
            return this.get(propertySet) != null;
        }

        public Object get(PropertySet propertySet) {
            try {
                return this.f.get(propertySet);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }

        public void set(PropertySet propertySet, Object object) {
            try {
                this.f.set(propertySet, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
    }

    protected static interface Accessor {
        public String getName();

        public boolean hasValue(PropertySet var1);

        public Object get(PropertySet var1);

        public void set(PropertySet var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class PropertyMap
    extends HashMap<String, Accessor> {
        protected PropertyMap() {
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Property {
        public String[] value();
    }
}

