/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.bind.DatatypeConverterImpl;
import com.sun.xml.internal.bind.v2.runtime.output.Encoded;
import com.sun.xml.internal.org.jvnet.staxex.Base64Data;
import com.sun.xml.internal.org.jvnet.staxex.NamespaceContextEx;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamReaderEx;
import com.sun.xml.internal.org.jvnet.staxex.XMLStreamWriterEx;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.MimeCodec;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.message.MimeAttachmentSet;
import com.sun.xml.internal.ws.streaming.MtomStreamWriter;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderFilter;
import com.sun.xml.internal.ws.util.xml.XMLStreamWriterFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;

public class MtomCodec
extends MimeCodec {
    public static final String XOP_XML_MIME_TYPE = "application/xop+xml";
    private final StreamSOAPCodec codec;
    private String boundary;
    private String rootId;
    private final String soapXopContentType;
    private String messageContentType;
    private final MTOMFeature mtomFeature;
    private static final String XOP_PREF = "<Include xmlns=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:";
    private static final String XOP_SUFF = "\"/>";
    private static final String XOP_LOCALNAME = "Include";
    private static final String XOP_NAMESPACEURI = "http://www.w3.org/2004/08/xop/include";

    MtomCodec(SOAPVersion sOAPVersion, StreamSOAPCodec streamSOAPCodec, WSBinding wSBinding, WebServiceFeature webServiceFeature) {
        super(sOAPVersion, wSBinding);
        this.codec = streamSOAPCodec;
        this.createConteTypeHeader();
        this.soapXopContentType = "application/xop+xml;charset=utf-8;type=\"" + sOAPVersion.contentType + "\"";
        this.mtomFeature = webServiceFeature == null ? new MTOMFeature() : (MTOMFeature)webServiceFeature;
    }

    private void createConteTypeHeader() {
        String string = UUID.randomUUID().toString();
        this.boundary = "uuid:" + string;
        this.rootId = "<rootpart*" + string + "@example.jaxws.sun.com>";
        String string2 = "boundary=\"" + this.boundary + "\"";
        this.messageContentType = "multipart/related;start=\"" + this.rootId + "\"" + ";type=\"" + XOP_XML_MIME_TYPE + "\";" + string2 + ";start-info=\"" + this.version.contentType + "\"";
    }

    public ContentType getStaticContentType(Packet packet) {
        return this.getContentType(packet);
    }

    private ContentType getContentType(Packet packet) {
        switch (this.version) {
            case SOAP_11: {
                return new ContentTypeImpl(this.messageContentType, packet.soapAction == null ? "" : packet.soapAction, null);
            }
            case SOAP_12: {
                if (packet.soapAction != null) {
                    this.messageContentType = this.messageContentType + ";action=\"" + packet.soapAction + "\"";
                }
                return new ContentTypeImpl(this.messageContentType, null, null);
            }
        }
        return null;
    }

    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        ContentType contentType = this.getContentType(packet);
        if (packet.getMessage() != null) {
            try {
                MtomCodec.writeln("--" + this.boundary, outputStream);
                MtomCodec.writeln("Content-Id: " + this.rootId, outputStream);
                MtomCodec.writeln("Content-Type: " + this.soapXopContentType, outputStream);
                MtomCodec.writeln("Content-Transfer-Encoding: binary", outputStream);
                MtomCodec.writeln(outputStream);
                ArrayList<ByteArrayBuffer> arrayList = new ArrayList<ByteArrayBuffer>();
                MtomStreamWriterImpl mtomStreamWriterImpl = new MtomStreamWriterImpl(XMLStreamWriterFactory.create(outputStream), outputStream, arrayList);
                packet.getMessage().writeTo(mtomStreamWriterImpl);
                XMLStreamWriterFactory.recycle(mtomStreamWriterImpl);
                MtomCodec.writeln(outputStream);
                for (ByteArrayBuffer byteArrayBuffer : arrayList) {
                    byteArrayBuffer.write(outputStream);
                }
                this.writeAttachments(packet.getMessage().getAttachments(), outputStream);
                MtomCodec.writeAsAscii("--" + this.boundary, outputStream);
                MtomCodec.writeAsAscii("--", outputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }
        this.createConteTypeHeader();
        return contentType;
    }

    private void writeMimeHeaders(String string, String string2, OutputStream outputStream) throws IOException {
        String string3 = string2;
        if (string3 != null && string3.length() > 0 && string3.charAt(0) != '<') {
            string3 = '<' + string3 + '>';
        }
        MtomCodec.writeln("Content-Id: " + string3, outputStream);
        MtomCodec.writeln("Content-Type: " + string, outputStream);
        MtomCodec.writeln("Content-Transfer-Encoding: binary", outputStream);
        MtomCodec.writeln(outputStream);
    }

    private void writeAttachments(AttachmentSet attachmentSet, OutputStream outputStream) throws IOException {
        for (Attachment attachment : attachmentSet) {
            MtomCodec.writeln("--" + this.boundary, outputStream);
            this.writeMimeHeaders(attachment.getContentType(), attachment.getContentId(), outputStream);
            attachment.writeTo(outputStream);
            MtomCodec.writeln(outputStream);
        }
    }

    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException();
    }

    public MtomCodec copy() {
        return new MtomCodec(this.version, (StreamSOAPCodec)this.codec.copy(), this.binding, this.mtomFeature);
    }

    private String encodeCid() {
        String string = "example.jaxws.sun.com";
        String string2 = UUID.randomUUID() + "@";
        return string2 + string;
    }

    protected void decode(MimeMultipartParser mimeMultipartParser, Packet packet) throws IOException {
        MtomXMLStreamReaderEx mtomXMLStreamReaderEx = new MtomXMLStreamReaderEx(mimeMultipartParser, XMLStreamReaderFactory.create(null, mimeMultipartParser.getRootPart().asInputStream(), true));
        packet.setMessage(this.codec.decode(mtomXMLStreamReaderEx, new MimeAttachmentSet(mimeMultipartParser)));
    }

    private static class MtomXMLStreamReaderEx
    extends XMLStreamReaderFilter
    implements XMLStreamReaderEx {
        private final MimeMultipartParser mimeMP;
        private boolean xopReferencePresent = false;
        private Base64Data base64AttData;
        private char[] base64EncodedText;

        public MtomXMLStreamReaderEx(MimeMultipartParser mimeMultipartParser, XMLStreamReader xMLStreamReader) {
            super(xMLStreamReader);
            this.mimeMP = mimeMultipartParser;
        }

        public CharSequence getPCDATA() throws XMLStreamException {
            if (this.xopReferencePresent) {
                return this.base64AttData;
            }
            return this.reader.getText();
        }

        public NamespaceContextEx getNamespaceContext() {
            NamespaceContext namespaceContext = this.reader.getNamespaceContext();
            return new MtomNamespaceContextEx(namespaceContext);
        }

        public String getElementTextTrim() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        public int getTextLength() {
            if (this.xopReferencePresent) {
                return this.base64AttData.length();
            }
            return this.reader.getTextLength();
        }

        public int getTextStart() {
            if (this.xopReferencePresent) {
                return 0;
            }
            return this.reader.getTextStart();
        }

        public int getEventType() {
            if (this.xopReferencePresent) {
                return 4;
            }
            return super.getEventType();
        }

        public int next() throws XMLStreamException {
            int n = this.reader.next();
            if (n == 1 && this.reader.getLocalName().equals(MtomCodec.XOP_LOCALNAME) && this.reader.getNamespaceURI().equals(MtomCodec.XOP_NAMESPACEURI)) {
                String string = this.reader.getAttributeValue(null, "href");
                try {
                    Attachment attachment = this.getAttachment(string);
                    if (attachment != null) {
                        this.base64AttData = new Base64Data();
                        this.base64AttData.set(attachment.asDataHandler());
                    }
                    this.xopReferencePresent = true;
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
                XMLStreamReaderUtil.nextElementContent(this.reader);
                return 4;
            }
            if (this.xopReferencePresent) {
                this.xopReferencePresent = false;
                this.base64EncodedText = null;
            }
            return n;
        }

        private String decodeCid(String string) {
            try {
                string = URLDecoder.decode(string, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return string;
        }

        private Attachment getAttachment(String string) throws IOException {
            if (string.startsWith("cid:")) {
                string = string.substring(4, string.length());
            }
            if (string.indexOf(37) != -1) {
                string = this.decodeCid(string);
                return this.mimeMP.getAttachmentPart(string);
            }
            return this.mimeMP.getAttachmentPart(string);
        }

        public char[] getTextCharacters() {
            if (this.xopReferencePresent) {
                char[] cArray = new char[this.base64AttData.length()];
                this.base64AttData.writeTo(cArray, 0);
                return cArray;
            }
            return this.reader.getTextCharacters();
        }

        public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
            if (this.xopReferencePresent) {
                if (cArray == null) {
                    throw new NullPointerException("target char array can't be null");
                }
                if (n2 < 0 || n3 < 0 || n < 0 || n2 >= cArray.length || n2 + n3 > cArray.length) {
                    throw new IndexOutOfBoundsException();
                }
                int n4 = this.base64AttData.length();
                if (n > n4) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.base64EncodedText == null) {
                    this.base64EncodedText = new char[this.base64AttData.length()];
                    this.base64AttData.writeTo(this.base64EncodedText, 0);
                }
                int n5 = Math.min(n4 - n, n3);
                System.arraycopy(this.base64EncodedText, n, cArray, n2, n5);
                return n5;
            }
            return this.reader.getTextCharacters(n, cArray, n2, n3);
        }

        public String getText() {
            if (this.xopReferencePresent) {
                return this.base64AttData.toString();
            }
            return this.reader.getText();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class MtomNamespaceContextEx
        implements NamespaceContextEx {
            private NamespaceContext nsContext;

            public MtomNamespaceContextEx(NamespaceContext namespaceContext) {
                this.nsContext = namespaceContext;
            }

            @Override
            public Iterator<NamespaceContextEx.Binding> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getNamespaceURI(String string) {
                return this.nsContext.getNamespaceURI(string);
            }

            @Override
            public String getPrefix(String string) {
                return this.nsContext.getPrefix(string);
            }

            @Override
            public Iterator getPrefixes(String string) {
                return this.nsContext.getPrefixes(string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MtomStreamWriterImpl
    extends XMLStreamWriterFilter
    implements XMLStreamWriterEx,
    MtomStreamWriter {
        private final OutputStream out;
        private final Encoded encoded;
        private final List<ByteArrayBuffer> mtomAttachments;

        public MtomStreamWriterImpl(XMLStreamWriter xMLStreamWriter, OutputStream outputStream, List<ByteArrayBuffer> list) {
            super(xMLStreamWriter);
            this.encoded = new Encoded();
            this.out = outputStream;
            this.mtomAttachments = list;
        }

        @Override
        public void writeBinary(byte[] byArray, int n, int n2, String string) throws XMLStreamException {
            if (MtomCodec.this.mtomFeature.getThreshold() > n2) {
                this.writeCharacters(DatatypeConverterImpl._printBase64Binary(byArray, n, n2));
                return;
            }
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(new DataHandler(new ByteArrayDataSource(byArray, n, n2, string)));
            this.writeBinary(byteArrayBuffer);
        }

        @Override
        public void writeBinary(DataHandler dataHandler) throws XMLStreamException {
            this.writeBinary(new ByteArrayBuffer(dataHandler));
        }

        @Override
        public OutputStream writeBinary(String string) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writePCDATA(CharSequence charSequence) throws XMLStreamException {
            if (charSequence == null) {
                return;
            }
            if (charSequence instanceof Base64Data) {
                Base64Data base64Data = (Base64Data)charSequence;
                this.writeBinary(base64Data.getDataHandler());
                return;
            }
            this.writeCharacters(((Object)charSequence).toString());
        }

        private void writeBinary(ByteArrayBuffer byteArrayBuffer) {
            try {
                this.mtomAttachments.add(byteArrayBuffer);
                this.writer.writeCharacters("");
                this.writer.flush();
                this.encoded.set(MtomCodec.XOP_PREF + byteArrayBuffer.contentId + MtomCodec.XOP_SUFF);
                this.out.write(this.encoded.buf, 0, this.encoded.len);
            }
            catch (IOException iOException) {
                throw new WebServiceException(iOException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }

        @Override
        public Object getProperty(String string) throws IllegalArgumentException {
            Object v;
            if (string.equals("sjsxp-outputstream") && this.writer instanceof Map && (v = ((Map)((Object)this.writer)).get("sjsxp-outputstream")) != null) {
                return v;
            }
            return super.getProperty(string);
        }

        @Override
        public AttachmentMarshaller getAttachmentMarshaller() {
            return new AttachmentMarshaller(){

                public String addMtomAttachment(DataHandler dataHandler, String string, String string2) {
                    ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(dataHandler);
                    MtomStreamWriterImpl.this.mtomAttachments.add(byteArrayBuffer);
                    return "cid:" + byteArrayBuffer.contentId;
                }

                public String addMtomAttachment(byte[] byArray, int n, int n2, String string, String string2, String string3) {
                    if (MtomCodec.this.mtomFeature.getThreshold() > n2) {
                        return null;
                    }
                    ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(new DataHandler(new ByteArrayDataSource(byArray, n, n2, string)));
                    MtomStreamWriterImpl.this.mtomAttachments.add(byteArrayBuffer);
                    return "cid:" + byteArrayBuffer.contentId;
                }

                public String addSwaRefAttachment(DataHandler dataHandler) {
                    ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(dataHandler);
                    MtomStreamWriterImpl.this.mtomAttachments.add(byteArrayBuffer);
                    return "cid:" + byteArrayBuffer.contentId;
                }

                public boolean isXOPPackage() {
                    return true;
                }
            };
        }

        @Override
        public NamespaceContextEx getNamespaceContext() {
            NamespaceContext namespaceContext = this.writer.getNamespaceContext();
            return new MtomNamespaceContextEx(namespaceContext);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MtomNamespaceContextEx
        implements NamespaceContextEx {
            private NamespaceContext nsContext;

            public MtomNamespaceContextEx(NamespaceContext namespaceContext) {
                this.nsContext = namespaceContext;
            }

            @Override
            public Iterator<NamespaceContextEx.Binding> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getNamespaceURI(String string) {
                return this.nsContext.getNamespaceURI(string);
            }

            @Override
            public String getPrefix(String string) {
                return this.nsContext.getPrefix(string);
            }

            @Override
            public Iterator getPrefixes(String string) {
                return this.nsContext.getPrefixes(string);
            }
        }
    }

    private class ByteArrayBuffer {
        final String contentId;
        private DataHandler dh;

        ByteArrayBuffer(DataHandler dataHandler) {
            this.dh = dataHandler;
            this.contentId = MtomCodec.this.encodeCid();
        }

        void write(OutputStream outputStream) throws IOException {
            MimeCodec.writeln("--" + MtomCodec.this.boundary, outputStream);
            MtomCodec.this.writeMimeHeaders(this.dh.getContentType(), this.contentId, outputStream);
            this.dh.writeTo(outputStream);
            MimeCodec.writeln(outputStream);
        }
    }
}

