/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.saaj;

import com.sun.istack.internal.FragmentContentHandler;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.istack.internal.XMLStreamException2;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.unmarshaller.DOMScanner;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.message.saaj.SAAJHeader;
import com.sun.xml.internal.ws.streaming.DOMStreamReader;
import com.sun.xml.internal.ws.util.DOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAAJMessage
extends Message {
    private boolean parsedMessage;
    private boolean accessedMessage;
    private final SOAPMessage sm;
    private HeaderList headers;
    private List<Element> bodyParts;
    private Element payload;
    private String payloadLocalName;
    private String payloadNamespace;
    private SOAPVersion soapVersion;
    private static final AttributesImpl EMPTY_ATTS = new AttributesImpl();
    private static final LocatorImpl NULL_LOCATOR = new LocatorImpl();

    public SAAJMessage(SOAPMessage sOAPMessage) {
        this.sm = sOAPMessage;
    }

    private SAAJMessage(HeaderList headerList, AttachmentSet attachmentSet, SOAPMessage sOAPMessage) {
        this.sm = sOAPMessage;
        this.parse();
        if (headerList == null) {
            headerList = new HeaderList();
        }
        this.headers = headerList;
        this.attachmentSet = attachmentSet;
    }

    private void parse() {
        if (!this.parsedMessage) {
            try {
                SOAPHeader sOAPHeader;
                this.access();
                if (this.headers == null) {
                    this.headers = new HeaderList();
                }
                if ((sOAPHeader = this.sm.getSOAPHeader()) != null) {
                    Iterator iterator = sOAPHeader.examineAllHeaderElements();
                    while (iterator.hasNext()) {
                        this.headers.add(new SAAJHeader((SOAPHeaderElement)iterator.next()));
                    }
                }
                this.attachmentSet = new SAAJAttachmentSet(this.sm);
                this.parsedMessage = true;
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }
    }

    private void access() {
        if (!this.accessedMessage) {
            try {
                SOAPBody sOAPBody = this.sm.getSOAPBody();
                this.soapVersion = SOAPVersion.fromNsUri(sOAPBody.getNamespaceURI());
                this.bodyParts = DOMUtil.getChildElements(sOAPBody);
                Element element = this.payload = this.bodyParts.size() > 0 ? this.bodyParts.get(0) : null;
                if (this.payload != null) {
                    this.payloadLocalName = this.payload.getLocalName();
                    this.payloadNamespace = this.payload.getNamespaceURI();
                }
                this.accessedMessage = true;
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }
    }

    @Override
    public boolean hasHeaders() {
        this.parse();
        return this.headers.size() > 0;
    }

    @Override
    @NotNull
    public HeaderList getHeaders() {
        this.parse();
        return this.headers;
    }

    @Override
    @NotNull
    public AttachmentSet getAttachments() {
        this.parse();
        return this.attachmentSet;
    }

    @Override
    protected boolean hasAttachments() {
        this.parse();
        return this.attachmentSet != null;
    }

    @Override
    @Nullable
    public String getPayloadLocalPart() {
        this.access();
        return this.payloadLocalName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        this.access();
        return this.payloadNamespace;
    }

    @Override
    public boolean hasPayload() {
        this.access();
        return this.payloadNamespace != null;
    }

    @Override
    public Source readEnvelopeAsSource() {
        try {
            if (!this.parsedMessage) {
                SOAPEnvelope sOAPEnvelope = this.sm.getSOAPPart().getEnvelope();
                return new DOMSource(sOAPEnvelope);
            }
            SOAPMessage sOAPMessage = this.soapVersion.saajMessageFactory.createMessage();
            SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
            for (Element object : this.bodyParts) {
                Node node = sOAPBody.getOwnerDocument().importNode(object, true);
                sOAPBody.appendChild(node);
            }
            for (Header header : this.headers) {
                header.writeTo(sOAPMessage);
            }
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            return new DOMSource(sOAPEnvelope);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    @Override
    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        Object object;
        if (!this.parsedMessage) {
            return this.sm;
        }
        SOAPMessage sOAPMessage = this.soapVersion.saajMessageFactory.createMessage();
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        for (Element object2 : this.bodyParts) {
            object = sOAPBody.getOwnerDocument().importNode(object2, true);
            sOAPBody.appendChild((Node)object);
        }
        for (Header header : this.headers) {
            header.writeTo(sOAPMessage);
        }
        for (Attachment attachment : this.getAttachments()) {
            object = sOAPMessage.createAttachmentPart();
            ((AttachmentPart)object).setDataHandler(attachment.asDataHandler());
            ((AttachmentPart)object).setContentId('<' + attachment.getContentId() + '>');
            sOAPMessage.addAttachmentPart((AttachmentPart)object);
        }
        sOAPMessage.saveChanges();
        return sOAPMessage;
    }

    @Override
    public Source readPayloadAsSource() {
        this.access();
        return this.payload != null ? new DOMSource(this.payload) : null;
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        this.access();
        if (this.payload != null) {
            if (this.hasAttachments()) {
                unmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerImpl(this.getAttachments()));
            }
            return (T)unmarshaller.unmarshal(this.payload);
        }
        return null;
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        this.access();
        if (this.payload != null) {
            return bridge.unmarshal(this.payload, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
        }
        return null;
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        this.access();
        if (this.payload != null) {
            DOMStreamReader dOMStreamReader = new DOMStreamReader();
            dOMStreamReader.setCurrentNode(this.payload);
            dOMStreamReader.nextTag();
            assert (dOMStreamReader.getEventType() == 1);
            return dOMStreamReader;
        }
        return null;
    }

    @Override
    public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this.access();
        try {
            for (Element element : this.bodyParts) {
                DOMUtil.serializeNode(element, xMLStreamWriter);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        try {
            xMLStreamWriter.writeStartDocument();
            if (!this.parsedMessage) {
                DOMUtil.serializeNode(this.sm.getSOAPPart().getEnvelope(), xMLStreamWriter);
            } else {
                SOAPEnvelope sOAPEnvelope = this.sm.getSOAPPart().getEnvelope();
                DOMUtil.writeTagWithAttributes(sOAPEnvelope, xMLStreamWriter);
                if (this.hasHeaders()) {
                    xMLStreamWriter.writeStartElement(sOAPEnvelope.getPrefix(), "Header", sOAPEnvelope.getNamespaceURI());
                    int n = this.headers.size();
                    for (int i = 0; i < n; ++i) {
                        this.headers.get(i).writeTo(xMLStreamWriter);
                    }
                    xMLStreamWriter.writeEndElement();
                }
                DOMUtil.serializeNode(this.sm.getSOAPBody(), xMLStreamWriter);
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
        }
        catch (SOAPException sOAPException) {
            throw new XMLStreamException2(sOAPException);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        String string = this.soapVersion.nsUri;
        if (!this.parsedMessage) {
            DOMScanner dOMScanner = new DOMScanner();
            dOMScanner.setContentHandler(contentHandler);
            dOMScanner.scan(this.sm.getSOAPPart());
        } else {
            contentHandler.setDocumentLocator(NULL_LOCATOR);
            contentHandler.startDocument();
            contentHandler.startPrefixMapping("S", string);
            contentHandler.startElement(string, "Envelope", "S:Envelope", EMPTY_ATTS);
            if (this.hasHeaders()) {
                contentHandler.startElement(string, "Header", "S:Header", EMPTY_ATTS);
                HeaderList headerList = this.getHeaders();
                int n = headerList.size();
                for (int i = 0; i < n; ++i) {
                    headerList.get(i).writeTo(contentHandler, errorHandler);
                }
                contentHandler.endElement(string, "Header", "S:Header");
            }
            contentHandler.startElement(string, "Body", "S:Body", EMPTY_ATTS);
            this.writePayloadTo(contentHandler, errorHandler, true);
            contentHandler.endElement(string, "Body", "S:Body");
            contentHandler.endElement(string, "Envelope", "S:Envelope");
        }
    }

    private void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
        if (bl) {
            contentHandler = new FragmentContentHandler(contentHandler);
        }
        DOMScanner dOMScanner = new DOMScanner();
        dOMScanner.setContentHandler(contentHandler);
        dOMScanner.scan(this.payload);
    }

    @Override
    public Message copy() {
        try {
            if (!this.parsedMessage) {
                return new SAAJMessage(this.readAsSOAPMessage());
            }
            SOAPMessage sOAPMessage = this.soapVersion.saajMessageFactory.createMessage();
            SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
            for (Element element : this.bodyParts) {
                Node node = sOAPBody.getOwnerDocument().importNode(element, true);
                sOAPBody.appendChild(node);
            }
            return new SAAJMessage(this.getHeaders(), this.getAttachments(), sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SAAJAttachmentSet
    implements AttachmentSet {
        private Map<String, Attachment> attMap;
        private Iterator attIter;

        public SAAJAttachmentSet(SOAPMessage sOAPMessage) {
            this.attIter = sOAPMessage.getAttachments();
        }

        @Override
        public Attachment get(String string) {
            if (this.attMap == null) {
                if (!this.attIter.hasNext()) {
                    return null;
                }
                this.attMap = this.createAttachmentMap();
            }
            if (string.charAt(0) != '<') {
                return this.attMap.get('<' + string + '>');
            }
            return this.attMap.get(string);
        }

        @Override
        public boolean isEmpty() {
            if (this.attMap != null) {
                return this.attMap.isEmpty();
            }
            return !this.attIter.hasNext();
        }

        @Override
        public Iterator<Attachment> iterator() {
            if (this.attMap == null) {
                this.attMap = this.createAttachmentMap();
            }
            return this.attMap.values().iterator();
        }

        private Map<String, Attachment> createAttachmentMap() {
            HashMap<String, Attachment> hashMap = new HashMap<String, Attachment>();
            while (this.attIter.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)this.attIter.next();
                hashMap.put(attachmentPart.getContentId(), new SAAJAttachment(attachmentPart));
            }
            return hashMap;
        }

        @Override
        public void add(Attachment attachment) {
            this.attMap.put('<' + attachment.getContentId() + '>', attachment);
        }
    }

    private class SAAJAttachment
    implements Attachment {
        final AttachmentPart ap;

        public SAAJAttachment(AttachmentPart attachmentPart) {
            this.ap = attachmentPart;
        }

        public String getContentId() {
            return this.ap.getContentId();
        }

        public String getContentType() {
            return this.ap.getContentType();
        }

        public byte[] asByteArray() {
            try {
                return this.ap.getRawContentBytes();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public DataHandler asDataHandler() {
            try {
                return this.ap.getDataHandler();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public Source asSource() {
            try {
                return new StreamSource(this.ap.getRawContent());
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public InputStream asInputStream() {
            try {
                return this.ap.getRawContent();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.asByteArray());
        }

        public void writeTo(SOAPMessage sOAPMessage) {
            sOAPMessage.addAttachmentPart(this.ap);
        }

        AttachmentPart asAttachmentPart() {
            return this.ap;
        }
    }
}

