/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.server.InstanceResolver;
import com.sun.xml.internal.ws.api.server.ResourceInjector;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.util.localization.Localizable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractInstanceResolver<T>
extends InstanceResolver<T> {
    AbstractInstanceResolver() {
    }

    protected static ResourceInjector getResourceInjector(WSEndpoint wSEndpoint) {
        ResourceInjector resourceInjector = wSEndpoint.getContainer().getSPI(ResourceInjector.class);
        if (resourceInjector == null) {
            resourceInjector = ResourceInjector.STANDALONE;
        }
        return resourceInjector;
    }

    protected static void invokeMethod(final @Nullable Method method, final Object object, final Object ... objectArray) {
        if (method == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(object, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ServerRtException("server.rt.err", new Object[]{illegalAccessException});
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new ServerRtException("server.rt.err", new Object[]{invocationTargetException});
                }
                return null;
            }
        });
    }

    @Nullable
    protected final Method findAnnotatedMethod(Class clazz, Class<? extends Annotation> clazz2) {
        boolean bl = false;
        Method method = null;
        for (Method method2 : clazz.getDeclaredMethods()) {
            if (method2.getAnnotation(clazz2) == null) continue;
            if (bl) {
                throw new ServerRtException(ServerMessages.ANNOTATION_ONLY_ONCE(clazz2), new Object[0]);
            }
            if (method2.getParameterTypes().length != 0) {
                throw new ServerRtException(ServerMessages.NOT_ZERO_PARAMETERS(method2), new Object[0]);
            }
            method = method2;
            bl = true;
        }
        return method;
    }

    protected static <T, R> InjectionPlan<T, R> buildInjectionPlan(Class<? extends T> clazz, Class<R> clazz2, boolean bl) {
        Resource resource;
        Class<T> clazz3;
        ArrayList arrayList = new ArrayList();
        for (clazz3 = clazz; clazz3 != Object.class; clazz3 = clazz3.getSuperclass()) {
            for (AccessibleObject accessibleObject : clazz3.getDeclaredFields()) {
                resource = ((Field)accessibleObject).getAnnotation(Resource.class);
                if (resource == null || !AbstractInstanceResolver.isInjectionPoint(resource, ((Field)accessibleObject).getType(), ServerMessages.localizableWRONG_FIELD_TYPE(((Field)accessibleObject).getName()), clazz2)) continue;
                if (bl && !Modifier.isStatic(((Field)accessibleObject).getModifiers())) {
                    throw new WebServiceException(ServerMessages.STATIC_RESOURCE_INJECTION_ONLY(clazz2, accessibleObject));
                }
                arrayList.add(new FieldInjectionPlan((Field)accessibleObject));
            }
        }
        for (clazz3 = clazz; clazz3 != Object.class; clazz3 = clazz3.getSuperclass()) {
            for (AccessibleObject accessibleObject : clazz3.getDeclaredMethods()) {
                resource = ((Method)accessibleObject).getAnnotation(Resource.class);
                if (resource == null) continue;
                Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
                if (classArray.length != 1) {
                    throw new ServerRtException(ServerMessages.WRONG_NO_PARAMETERS(accessibleObject), new Object[0]);
                }
                if (!AbstractInstanceResolver.isInjectionPoint(resource, classArray[0], ServerMessages.localizableWRONG_PARAMETER_TYPE(((Method)accessibleObject).getName()), clazz2)) continue;
                if (bl && !Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    throw new WebServiceException(ServerMessages.STATIC_RESOURCE_INJECTION_ONLY(clazz2, accessibleObject));
                }
                arrayList.add(new MethodInjectionPlan((Method)accessibleObject));
            }
        }
        return new Compositor(arrayList);
    }

    private static boolean isInjectionPoint(Resource resource, Class clazz, Localizable localizable, Class clazz2) {
        Class clazz3 = resource.type();
        if (clazz3.equals(Object.class)) {
            return clazz.equals(clazz2);
        }
        if (clazz3.equals(clazz2)) {
            if (clazz.isAssignableFrom(clazz2)) {
                return true;
            }
            throw new ServerRtException(localizable);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Compositor<T, R>
    implements InjectionPlan<T, R> {
        private final InjectionPlan<T, R>[] children;

        public Compositor(Collection<InjectionPlan<T, R>> collection) {
            this.children = collection.toArray(new InjectionPlan[collection.size()]);
        }

        @Override
        public void inject(T t, R r) {
            for (InjectionPlan<T, R> injectionPlan : this.children) {
                injectionPlan.inject(t, r);
            }
        }

        @Override
        public int count() {
            int n = 0;
            for (InjectionPlan<T, R> injectionPlan : this.children) {
                n += injectionPlan.count();
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodInjectionPlan<T, R>
    implements InjectionPlan<T, R> {
        private final Method method;

        public MethodInjectionPlan(Method method) {
            this.method = method;
        }

        @Override
        public void inject(T t, R r) {
            AbstractInstanceResolver.invokeMethod(this.method, t, r);
        }

        @Override
        public int count() {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FieldInjectionPlan<T, R>
    implements InjectionPlan<T, R> {
        private final Field field;

        public FieldInjectionPlan(Field field) {
            this.field = field;
        }

        @Override
        public void inject(final T t, final R r) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        if (!FieldInjectionPlan.this.field.isAccessible()) {
                            FieldInjectionPlan.this.field.setAccessible(true);
                        }
                        FieldInjectionPlan.this.field.set(t, r);
                        return null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new ServerRtException("server.rt.err", new Object[]{illegalAccessException});
                    }
                }
            });
        }

        @Override
        public int count() {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InjectionPlan<T, R> {
        public void inject(T var1, R var2);

        public int count();
    }
}

