/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.provider;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.provider.MessageProviderArgumentBuilder;
import com.sun.xml.internal.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.internal.ws.server.provider.ProviderEndpointModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SOAPProviderArgumentBuilder<T>
extends ProviderArgumentsBuilder<T> {
    protected final SOAPVersion soapVersion;

    private SOAPProviderArgumentBuilder(SOAPVersion sOAPVersion) {
        this.soapVersion = sOAPVersion;
    }

    static ProviderArgumentsBuilder create(ProviderEndpointModel providerEndpointModel, SOAPVersion sOAPVersion) {
        if (providerEndpointModel.mode == Service.Mode.PAYLOAD) {
            return new PayloadSource(sOAPVersion);
        }
        if (providerEndpointModel.datatype == Source.class) {
            return new MessageSource(sOAPVersion);
        }
        if (providerEndpointModel.datatype == SOAPMessage.class) {
            return new SOAPMessageParameter(sOAPVersion);
        }
        if (providerEndpointModel.datatype == Message.class) {
            return new MessageProviderArgumentBuilder(sOAPVersion);
        }
        throw new WebServiceException(ServerMessages.PROVIDER_INVALID_PARAMETER_TYPE(providerEndpointModel.implClass, providerEndpointModel.datatype));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SOAPMessageParameter
    extends SOAPProviderArgumentBuilder<SOAPMessage> {
        SOAPMessageParameter(SOAPVersion sOAPVersion) {
            super(sOAPVersion);
        }

        @Override
        protected SOAPMessage getParameter(Packet packet) {
            try {
                return packet.getMessage().readAsSOAPMessage(packet, true);
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        @Override
        protected Message getResponseMessage(SOAPMessage sOAPMessage) {
            return Messages.create(sOAPMessage);
        }

        @Override
        protected Message getResponseMessage(Exception exception) {
            return SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, exception);
        }

        @Override
        protected Packet getResponse(Packet packet, @Nullable SOAPMessage sOAPMessage, WSDLPort wSDLPort, WSBinding wSBinding) {
            Packet packet2 = super.getResponse(packet, sOAPMessage, wSDLPort, wSBinding);
            if (sOAPMessage != null && packet2.supports("com.sun.xml.internal.ws.api.message.packet.outbound.transport.headers")) {
                MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
                HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
                Iterator iterator = mimeHeaders.getAllHeaders();
                while (iterator.hasNext()) {
                    MimeHeader mimeHeader = (MimeHeader)iterator.next();
                    if (mimeHeader.getName().equalsIgnoreCase("SOAPAction")) continue;
                    ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(mimeHeader.getName());
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        hashMap.put(mimeHeader.getName(), arrayList);
                    }
                    arrayList.add(mimeHeader.getValue());
                }
                packet2.put("com.sun.xml.internal.ws.api.message.packet.outbound.transport.headers", hashMap);
            }
            return packet2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MessageSource
    extends SOAPProviderArgumentBuilder<Source> {
        MessageSource(SOAPVersion sOAPVersion) {
            super(sOAPVersion);
        }

        @Override
        protected Source getParameter(Packet packet) {
            return packet.getMessage().readEnvelopeAsSource();
        }

        @Override
        protected Message getResponseMessage(Source source) {
            return Messages.create(source, this.soapVersion);
        }

        @Override
        protected Message getResponseMessage(Exception exception) {
            return SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PayloadSource
    extends SOAPProviderArgumentBuilder<Source> {
        PayloadSource(SOAPVersion sOAPVersion) {
            super(sOAPVersion);
        }

        @Override
        protected Source getParameter(Packet packet) {
            return packet.getMessage().readPayloadAsSource();
        }

        @Override
        protected Message getResponseMessage(Source source) {
            return Messages.createUsingPayload(source, this.soapVersion);
        }

        @Override
        protected Message getResponseMessage(Exception exception) {
            return SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, exception);
        }
    }
}

