/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.ch.ChannelInputStream;
import sun.nio.cs.StreamDecoder;
import sun.nio.cs.StreamEncoder;

public final class Channels {
    private Channels() {
    }

    private static void writeFullyImpl(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.remaining() > 0) {
            int n = writableByteChannel.write(byteBuffer);
            if (n > 0) continue;
            throw new RuntimeException("no bytes written");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFully(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        if (writableByteChannel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)writableByteChannel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                if (!selectableChannel.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                Channels.writeFullyImpl(writableByteChannel, byteBuffer);
            }
        } else {
            Channels.writeFullyImpl(writableByteChannel, byteBuffer);
        }
    }

    public static InputStream newInputStream(ReadableByteChannel readableByteChannel) {
        return new ChannelInputStream(readableByteChannel);
    }

    public static OutputStream newOutputStream(final WritableByteChannel writableByteChannel) {
        return new OutputStream(){
            private ByteBuffer bb = null;
            private byte[] bs = null;
            private byte[] b1 = null;

            public synchronized void write(int n) throws IOException {
                if (this.b1 == null) {
                    this.b1 = new byte[1];
                }
                this.b1[0] = (byte)n;
                this.write(this.b1);
            }

            public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
                if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (n2 == 0) {
                    return;
                }
                ByteBuffer byteBuffer = this.bs == byArray ? this.bb : ByteBuffer.wrap(byArray);
                byteBuffer.limit(Math.min(n + n2, byteBuffer.capacity()));
                byteBuffer.position(n);
                this.bb = byteBuffer;
                this.bs = byArray;
                Channels.writeFully(writableByteChannel, byteBuffer);
            }

            public void close() throws IOException {
                writableByteChannel.close();
            }
        };
    }

    public static ReadableByteChannel newChannel(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (inputStream instanceof FileInputStream && FileInputStream.class.equals(inputStream.getClass())) {
            return ((FileInputStream)inputStream).getChannel();
        }
        return new ReadableByteChannelImpl(inputStream);
    }

    public static WritableByteChannel newChannel(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (outputStream instanceof FileOutputStream && FileOutputStream.class.equals(outputStream.getClass())) {
            return ((FileOutputStream)outputStream).getChannel();
        }
        return new WritableByteChannelImpl(outputStream);
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        charsetDecoder.reset();
        return StreamDecoder.forDecoder(readableByteChannel, charsetDecoder, n);
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, String string) {
        return Channels.newReader(readableByteChannel, Charset.forName(string).newDecoder(), -1);
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
        charsetEncoder.reset();
        return StreamEncoder.forEncoder(writableByteChannel, charsetEncoder, n);
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, String string) {
        return Channels.newWriter(writableByteChannel, Charset.forName(string).newEncoder(), -1);
    }

    private static class WritableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements WritableByteChannel {
        OutputStream out;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private boolean open = true;
        private Object writeLock = new Object();

        WritableByteChannelImpl(OutputStream outputStream) {
            this.out = outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.remaining();
            Object object = this.writeLock;
            synchronized (object) {
                int n2;
                int n3;
                for (n2 = 0; n2 < n; n2 += n3) {
                    Object var7_6;
                    n3 = Math.min(n - n2, 8192);
                    if (this.buf.length < n3) {
                        this.buf = new byte[n3];
                    }
                    byteBuffer.get(this.buf, 0, n3);
                    try {
                        this.begin();
                        this.out.write(this.buf, 0, n3);
                        var7_6 = null;
                        this.end(n3 > 0);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        this.end(n3 > 0);
                        throw throwable;
                    }
                }
                return n2;
            }
        }

        protected void implCloseChannel() throws IOException {
            this.out.close();
            this.open = false;
        }
    }

    private static class ReadableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements ReadableByteChannel {
        InputStream in;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private boolean open = true;
        private Object readLock = new Object();

        ReadableByteChannelImpl(InputStream inputStream) {
            this.in = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.remaining();
            int n2 = 0;
            Object object = this.readLock;
            synchronized (object) {
                int n3;
                for (n3 = 0; n3 < n; n3 += n2) {
                    Object var8_7;
                    int n4 = Math.min(n - n3, 8192);
                    if (this.buf.length < n4) {
                        this.buf = new byte[n4];
                    }
                    if (n3 > 0 && this.in.available() <= 0) break;
                    try {
                        this.begin();
                        n2 = this.in.read(this.buf, 0, n4);
                        var8_7 = null;
                        this.end(n2 > 0);
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        this.end(n2 > 0);
                        throw throwable;
                    }
                    if (n2 < 0) break;
                    byteBuffer.put(this.buf, 0, n2);
                }
                if (n2 < 0 && n3 == 0) {
                    return -1;
                }
                return n3;
            }
        }

        protected void implCloseChannel() throws IOException {
            this.in.close();
            this.open = false;
        }
    }
}

