/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Base64;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.prefs.XmlSupport;

public abstract class AbstractPreferences
extends Preferences {
    private final String name;
    private final String absolutePath;
    final AbstractPreferences parent;
    private final AbstractPreferences root;
    protected boolean newNode = false;
    private Map kidCache = new HashMap();
    private boolean removed = false;
    private PreferenceChangeListener[] prefListeners = new PreferenceChangeListener[0];
    private NodeChangeListener[] nodeListeners = new NodeChangeListener[0];
    protected final Object lock = new Object();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final AbstractPreferences[] EMPTY_ABSTRACT_PREFS_ARRAY = new AbstractPreferences[0];
    private static final List eventQueue = new LinkedList();
    private static Thread eventDispatchThread = null;

    protected AbstractPreferences(AbstractPreferences abstractPreferences, String string) {
        if (abstractPreferences == null) {
            if (!string.equals("")) {
                throw new IllegalArgumentException("Root name '" + string + "' must be \"\"");
            }
            this.absolutePath = "/";
            this.root = this;
        } else {
            if (string.indexOf(47) != -1) {
                throw new IllegalArgumentException("Name '" + string + "' contains '/'");
            }
            if (string.equals("")) {
                throw new IllegalArgumentException("Illegal name: empty string");
            }
            this.root = abstractPreferences.root;
            this.absolutePath = abstractPreferences == this.root ? "/" + string : abstractPreferences.absolutePath() + "/" + string;
        }
        this.name = string;
        this.parent = abstractPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (string.length() > 80) {
            throw new IllegalArgumentException("Key too long: " + string);
        }
        if (string2.length() > 8192) {
            throw new IllegalArgumentException("Value too long: " + string2);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            this.putSpi(string, string2);
            this.enqueuePreferenceChangeEvent(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null key");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            String string3 = null;
            try {
                string3 = this.getSpi(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string3 == null ? string2 : string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            this.removeSpi(string);
            this.enqueuePreferenceChangeEvent(string, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            String[] stringArray = this.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                this.remove(stringArray[i]);
            }
        }
    }

    public void putInt(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public int getInt(String string, int n) {
        int n2 = n;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public void putLong(String string, long l) {
        this.put(string, Long.toString(l));
    }

    public long getLong(String string, long l) {
        long l2 = l;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                l2 = Long.parseLong(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l2;
    }

    public void putBoolean(String string, boolean bl) {
        this.put(string, String.valueOf(bl));
    }

    public boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = this.get(string, null);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true")) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("false")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public void putFloat(String string, float f) {
        this.put(string, Float.toString(f));
    }

    public float getFloat(String string, float f) {
        float f2 = f;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                f2 = Float.parseFloat(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f2;
    }

    public void putDouble(String string, double d) {
        this.put(string, Double.toString(d));
    }

    public double getDouble(String string, double d) {
        double d2 = d;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                d2 = Double.parseDouble(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d2;
    }

    public void putByteArray(String string, byte[] byArray) {
        this.put(string, Base64.byteArrayToBase64(byArray));
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        byte[] byArray2 = byArray;
        String string2 = this.get(string, null);
        try {
            if (string2 != null) {
                byArray2 = Base64.base64ToByteArray(string2);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            return this.keysSpi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] childrenNames() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            TreeSet treeSet = new TreeSet(this.kidCache.keySet());
            String[] stringArray = this.childrenNamesSpi();
            for (int i = 0; i < stringArray.length; ++i) {
                treeSet.add(stringArray[i]);
            }
            return treeSet.toArray(EMPTY_STRING_ARRAY);
        }
    }

    protected final AbstractPreferences[] cachedChildren() {
        return this.kidCache.values().toArray(EMPTY_ABSTRACT_PREFS_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences parent() {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            return this.parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences node(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            if (string.equals("")) {
                return this;
            }
            if (string.equals("/")) {
                return this.root;
            }
            if (string.charAt(0) != '/') {
                return this.node(new StringTokenizer(string, "/", true));
            }
        }
        return this.root.node(new StringTokenizer(string.substring(1), "/", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences node(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        if (string.equals("/")) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        Object object = this.lock;
        synchronized (object) {
            AbstractPreferences abstractPreferences = (AbstractPreferences)this.kidCache.get(string);
            if (abstractPreferences == null) {
                if (string.length() > 80) {
                    throw new IllegalArgumentException("Node name " + string + " too long");
                }
                abstractPreferences = this.childSpi(string);
                if (abstractPreferences.newNode) {
                    this.enqueueNodeAddedEvent(abstractPreferences);
                }
                this.kidCache.put(string, abstractPreferences);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return abstractPreferences;
            }
            stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("Path ends with slash");
            }
            return abstractPreferences.node(stringTokenizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeExists(String string) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (string.equals("")) {
                return !this.removed;
            }
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            if (string.equals("/")) {
                return true;
            }
            if (string.charAt(0) != '/') {
                return this.nodeExists(new StringTokenizer(string, "/", true));
            }
        }
        return this.root.nodeExists(new StringTokenizer(string.substring(1), "/", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nodeExists(StringTokenizer stringTokenizer) throws BackingStoreException {
        String string = stringTokenizer.nextToken();
        if (string.equals("/")) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        Object object = this.lock;
        synchronized (object) {
            AbstractPreferences abstractPreferences = (AbstractPreferences)this.kidCache.get(string);
            if (abstractPreferences == null) {
                abstractPreferences = this.getChild(string);
            }
            if (abstractPreferences == null) {
                return false;
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return true;
            }
            stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("Path ends with slash");
            }
            return abstractPreferences.nodeExists(stringTokenizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode() throws BackingStoreException {
        if (this == this.root) {
            throw new UnsupportedOperationException("Can't remove the root!");
        }
        Object object = this.parent.lock;
        synchronized (object) {
            this.removeNode2();
            this.parent.kidCache.remove(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode2() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node already removed.");
            }
            String[] stringArray = this.childrenNamesSpi();
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.kidCache.containsKey(stringArray[i])) continue;
                this.kidCache.put(stringArray[i], this.childSpi(stringArray[i]));
            }
            Iterator iterator = this.kidCache.values().iterator();
            while (iterator.hasNext()) {
                try {
                    ((AbstractPreferences)iterator.next()).removeNode2();
                    iterator.remove();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            this.removeNodeSpi();
            this.removed = true;
            this.parent.enqueueNodeRemovedEvent(this);
        }
    }

    public String name() {
        return this.name;
    }

    public String absolutePath() {
        return this.absolutePath;
    }

    public boolean isUserNode() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(AbstractPreferences.this.root == Preferences.userRoot());
            }
        });
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        if (preferenceChangeListener == null) {
            throw new NullPointerException("Change listener is null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            PreferenceChangeListener[] preferenceChangeListenerArray = this.prefListeners;
            this.prefListeners = new PreferenceChangeListener[preferenceChangeListenerArray.length + 1];
            System.arraycopy(preferenceChangeListenerArray, 0, this.prefListeners, 0, preferenceChangeListenerArray.length);
            this.prefListeners[preferenceChangeListenerArray.length] = preferenceChangeListener;
        }
        AbstractPreferences.startEventDispatchThreadIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            if (this.prefListeners == null || this.prefListeners.length == 0) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            PreferenceChangeListener[] preferenceChangeListenerArray = new PreferenceChangeListener[this.prefListeners.length - 1];
            int n = 0;
            while (n < preferenceChangeListenerArray.length && this.prefListeners[n] != preferenceChangeListener) {
                preferenceChangeListenerArray[n] = this.prefListeners[n++];
            }
            if (n == preferenceChangeListenerArray.length && this.prefListeners[n] != preferenceChangeListener) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            while (n < preferenceChangeListenerArray.length) {
                preferenceChangeListenerArray[n++] = this.prefListeners[n];
            }
            this.prefListeners = preferenceChangeListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
        if (nodeChangeListener == null) {
            throw new NullPointerException("Change listener is null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            if (this.nodeListeners == null) {
                this.nodeListeners = new NodeChangeListener[1];
                this.nodeListeners[0] = nodeChangeListener;
            } else {
                NodeChangeListener[] nodeChangeListenerArray = this.nodeListeners;
                this.nodeListeners = new NodeChangeListener[nodeChangeListenerArray.length + 1];
                System.arraycopy(nodeChangeListenerArray, 0, this.nodeListeners, 0, nodeChangeListenerArray.length);
                this.nodeListeners[nodeChangeListenerArray.length] = nodeChangeListener;
            }
        }
        AbstractPreferences.startEventDispatchThreadIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeChangeListener(NodeChangeListener nodeChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            int n;
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            if (this.nodeListeners == null || this.nodeListeners.length == 0) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            for (n = 0; n < this.nodeListeners.length && this.nodeListeners[n] != nodeChangeListener; ++n) {
            }
            if (n == this.nodeListeners.length) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            NodeChangeListener[] nodeChangeListenerArray = new NodeChangeListener[this.nodeListeners.length - 1];
            if (n != 0) {
                System.arraycopy(this.nodeListeners, 0, nodeChangeListenerArray, 0, n);
            }
            if (n != nodeChangeListenerArray.length) {
                System.arraycopy(this.nodeListeners, n + 1, nodeChangeListenerArray, n, nodeChangeListenerArray.length - n);
            }
            this.nodeListeners = nodeChangeListenerArray;
        }
    }

    protected abstract void putSpi(String var1, String var2);

    protected abstract String getSpi(String var1);

    protected abstract void removeSpi(String var1);

    protected abstract void removeNodeSpi() throws BackingStoreException;

    protected abstract String[] keysSpi() throws BackingStoreException;

    protected abstract String[] childrenNamesSpi() throws BackingStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractPreferences getChild(String string) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            String[] stringArray = this.childrenNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return this.childSpi(stringArray[i]);
            }
        }
        return null;
    }

    protected abstract AbstractPreferences childSpi(String var1);

    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    public void sync() throws BackingStoreException {
        this.sync2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync2() throws BackingStoreException {
        AbstractPreferences[] abstractPreferencesArray;
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed");
            }
            this.syncSpi();
            abstractPreferencesArray = this.cachedChildren();
        }
        for (int i = 0; i < abstractPreferencesArray.length; ++i) {
            abstractPreferencesArray[i].sync2();
        }
    }

    protected abstract void syncSpi() throws BackingStoreException;

    public void flush() throws BackingStoreException {
        this.flush2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush2() throws BackingStoreException {
        AbstractPreferences[] abstractPreferencesArray;
        Object object = this.lock;
        synchronized (object) {
            this.flushSpi();
            if (this.removed) {
                return;
            }
            abstractPreferencesArray = this.cachedChildren();
        }
        for (int i = 0; i < abstractPreferencesArray.length; ++i) {
            abstractPreferencesArray[i].flush2();
        }
    }

    protected abstract void flushSpi() throws BackingStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            return this.removed;
        }
    }

    private static synchronized void startEventDispatchThreadIfNecessary() {
        if (eventDispatchThread == null) {
            eventDispatchThread = new EventDispatchThread();
            eventDispatchThread.setDaemon(true);
            eventDispatchThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreferenceChangeListener[] prefListeners() {
        Object object = this.lock;
        synchronized (object) {
            return this.prefListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeChangeListener[] nodeListeners() {
        Object object = this.lock;
        synchronized (object) {
            return this.nodeListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueuePreferenceChangeEvent(String string, String string2) {
        if (this.prefListeners.length != 0) {
            List list = eventQueue;
            synchronized (list) {
                eventQueue.add(new PreferenceChangeEvent(this, string, string2));
                eventQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueNodeAddedEvent(Preferences preferences) {
        if (this.nodeListeners.length != 0) {
            List list = eventQueue;
            synchronized (list) {
                eventQueue.add(new NodeAddedEvent(this, preferences));
                eventQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueNodeRemovedEvent(Preferences preferences) {
        if (this.nodeListeners.length != 0) {
            List list = eventQueue;
            synchronized (list) {
                eventQueue.add(new NodeRemovedEvent(this, preferences));
                eventQueue.notify();
            }
        }
    }

    public void exportNode(OutputStream outputStream) throws IOException, BackingStoreException {
        XmlSupport.export(outputStream, this, false);
    }

    public void exportSubtree(OutputStream outputStream) throws IOException, BackingStoreException {
        XmlSupport.export(outputStream, this, true);
    }

    static /* synthetic */ List access$100() {
        return eventQueue;
    }

    private static class EventDispatchThread
    extends Thread {
        private EventDispatchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void run() {
            block5: while (true) lbl-1000:
            // 4 sources

            {
                block11: {
                    block10: {
                        var1_1 = null;
                        var2_2 = AbstractPreferences.access$100();
                        synchronized (var2_2) {
                            try {
                                while (AbstractPreferences.access$100().isEmpty()) {
                                    AbstractPreferences.access$100().wait();
                                }
                                var1_1 = (EventObject)AbstractPreferences.access$100().remove(0);
                            }
                            catch (InterruptedException var3_4) {
                                return;
                            }
                        }
                        var2_2 = (AbstractPreferences)var1_1.getSource();
                        if (!(var1_1 instanceof PreferenceChangeEvent)) break block10;
                        var3_3 /* !! */  = (PreferenceChangeEvent)var1_1;
                        var4_5 = var2_2.prefListeners();
                        var5_7 = 0;
                        while (true) {
                            if (var5_7 >= var4_5.length) ** GOTO lbl-1000
                            var4_5[var5_7].preferenceChange(var3_3 /* !! */ );
                            ++var5_7;
                        }
                    }
                    var3_3 /* !! */  = (NodeChangeEvent)var1_1;
                    var4_5 = var2_2.nodeListeners();
                    if (!(var3_3 /* !! */  instanceof NodeAddedEvent)) break block11;
                    var5_7 = 0;
                    while (true) {
                        if (var5_7 >= var4_5.length) ** GOTO lbl-1000
                        var4_5[var5_7].childAdded((NodeChangeEvent)var3_3 /* !! */ );
                        ++var5_7;
                    }
                }
                var5_7 = 0;
                while (true) {
                    if (var5_7 >= var4_5.length) continue block5;
                    var4_5[var5_7].childRemoved((NodeChangeEvent)var3_3 /* !! */ );
                    ++var5_7;
                }
                break;
            }
        }
    }

    private class NodeRemovedEvent
    extends NodeChangeEvent {
        private static final long serialVersionUID = 8735497392918824837L;

        NodeRemovedEvent(Preferences preferences, Preferences preferences2) {
            super(preferences, preferences2);
        }
    }

    private class NodeAddedEvent
    extends NodeChangeEvent {
        private static final long serialVersionUID = -6743557530157328528L;

        NodeAddedEvent(Preferences preferences, Preferences preferences2) {
            super(preferences, preferences2);
        }
    }
}

