/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.windows.WComponentPeer;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.SunGraphics2D;
import sun.java2d.Surface;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.opengl.WGLSurfaceData;
import sun.java2d.pipe.hw.AccelDeviceEventListener;
import sun.java2d.pipe.hw.AccelDeviceEventNotifier;
import sun.java2d.pipe.hw.AccelSurface;
import sun.java2d.pipe.hw.AccelTypedVolatileImage;
import sun.java2d.pipe.hw.ContextCapabilities;
import sun.java2d.windows.GDIWindowSurfaceData;

public class WGLGraphicsConfig
extends Win32GraphicsConfig
implements OGLGraphicsConfig {
    protected static boolean wglAvailable;
    private static ImageCapabilities imageCaps;
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private ContextCapabilities oglCaps;
    private OGLContext context;
    private Object disposerReferent = new Object();

    public static native int getDefaultPixFmt(int var0);

    private static native boolean initWGL();

    private static native long getWGLConfigInfo(int var0, int var1);

    private static native int getOGLCapabilities(long var0);

    protected WGLGraphicsConfig(Win32GraphicsDevice win32GraphicsDevice, int n, long l, ContextCapabilities contextCapabilities) {
        super(win32GraphicsDevice, n);
        this.pConfigInfo = l;
        this.oglCaps = contextCapabilities;
        this.context = new OGLContext(OGLRenderQueue.getInstance(), this);
        Disposer.addRecord(this.disposerReferent, new WGLGCDisposerRecord(this.pConfigInfo, win32GraphicsDevice.getScreen()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WGLGraphicsConfig getConfig(Win32GraphicsDevice win32GraphicsDevice, int n) {
        if (!wglAvailable) {
            return null;
        }
        long l = 0L;
        final String[] stringArray = new String[1];
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.invalidateCurrentContext();
            WGLGetConfigInfo wGLGetConfigInfo = new WGLGetConfigInfo(win32GraphicsDevice.getScreen(), n);
            oGLRenderQueue.flushAndInvokeNow(wGLGetConfigInfo);
            l = wGLGetConfigInfo.getConfigInfo();
            if (l != 0L) {
                OGLContext.setScratchSurface(l);
                oGLRenderQueue.flushAndInvokeNow(new Runnable(){

                    public void run() {
                        stringArray[0] = OGLContext.getOGLIdString();
                    }
                });
            }
        }
        finally {
            oGLRenderQueue.unlock();
        }
        if (l == 0L) {
            return null;
        }
        int n2 = WGLGraphicsConfig.getOGLCapabilities(l);
        OGLContext.OGLContextCaps oGLContextCaps = new OGLContext.OGLContextCaps(n2, stringArray[0]);
        return new WGLGraphicsConfig(win32GraphicsDevice, n, l, oGLContextCaps);
    }

    public static boolean isWGLAvailable() {
        return wglAvailable;
    }

    public final boolean isCapPresent(int n) {
        return (this.oglCaps.getCaps() & n) != 0;
    }

    public final long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    public final OGLContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void displayChanged() {
        super.displayChanged();
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.invalidateCurrentContext();
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public String toString() {
        return "WGLGraphicsConfig[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    public SurfaceData createSurfaceData(WComponentPeer wComponentPeer, int n) {
        SurfaceData surfaceData = WGLSurfaceData.createData(wComponentPeer);
        if (surfaceData == null) {
            surfaceData = GDIWindowSurfaceData.createData(wComponentPeer);
        }
        return surfaceData;
    }

    public void assertOperationSupported(Component component, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (bufferCapabilities.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
    }

    public VolatileImage createBackBuffer(WComponentPeer wComponentPeer) {
        Component component = (Component)wComponentPeer.getTarget();
        return new SunVolatileImage(component, component.getWidth(), component.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(WComponentPeer wComponentPeer, Component component, VolatileImage volatileImage, int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        Object object;
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            object = SurfaceManager.getManager(volatileImage);
            SurfaceData surfaceData = ((SurfaceManager)object).getDestSurfaceData();
            if (surfaceData instanceof WGLSurfaceData.WGLVSyncOffScreenSurfaceData) {
                WGLSurfaceData.WGLVSyncOffScreenSurfaceData wGLVSyncOffScreenSurfaceData = (WGLSurfaceData.WGLVSyncOffScreenSurfaceData)surfaceData;
                SurfaceData surfaceData2 = wGLVSyncOffScreenSurfaceData.getFlipSurface();
                SunGraphics2D sunGraphics2D = new SunGraphics2D(surfaceData2, Color.black, Color.white, null);
                try {
                    ((Graphics)sunGraphics2D).drawImage(volatileImage, 0, 0, null);
                }
                finally {
                    ((Graphics)sunGraphics2D).dispose();
                }
            }
            Graphics graphics = wComponentPeer.getGraphics();
            try {
                graphics.drawImage(volatileImage, n, n2, n3, n4, n, n2, n3, n4, null);
            }
            finally {
                graphics.dispose();
            }
            return;
        }
        if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        OGLSurfaceData.swapBuffers(wComponentPeer.getData());
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            object = volatileImage.getGraphics();
            try {
                ((Graphics)object).setColor(component.getBackground());
                ((Graphics)object).fillRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            }
            finally {
                ((Graphics)object).dispose();
            }
        }
    }

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            boolean bl = this.isCapPresent(65536);
            this.bufferCaps = new WGLBufferCaps(bl);
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, int n3, int n4) {
        AccelTypedVolatileImage accelTypedVolatileImage;
        Surface surface;
        if (n4 == 4 || n4 == 1 || n4 == 0 || n3 == 2) {
            return null;
        }
        if (n4 == 5) {
            if (!this.isCapPresent(12)) {
                return null;
            }
        } else if (n4 == 2) {
            boolean bl;
            boolean bl2 = bl = n3 == 1;
            if (!bl && !this.isCapPresent(2)) {
                return null;
            }
        }
        if (!((surface = (accelTypedVolatileImage = new AccelTypedVolatileImage((GraphicsConfiguration)this, n, n2, n3, n4)).getDestSurface()) instanceof AccelSurface) || ((AccelSurface)surface).getType() != n4) {
            accelTypedVolatileImage.flush();
            accelTypedVolatileImage = null;
        }
        return accelTypedVolatileImage;
    }

    public ContextCapabilities getContextCapabilities() {
        return this.oglCaps;
    }

    public void addDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        AccelDeviceEventNotifier.addListener(accelDeviceEventListener, this.screen.getScreen());
    }

    public void removeDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        AccelDeviceEventNotifier.removeListener(accelDeviceEventListener);
    }

    static {
        imageCaps = new WGLImageCaps();
        wglAvailable = WGLGraphicsConfig.initWGL();
    }

    private static class WGLImageCaps
    extends ImageCapabilities {
        private WGLImageCaps() {
            super(true);
        }

        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class WGLBufferCaps
    extends BufferCapabilities {
        public WGLBufferCaps(boolean bl) {
            super(imageCaps, imageCaps, bl ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }

    private static class WGLGCDisposerRecord
    implements DisposerRecord {
        private long pCfgInfo;
        private int screen;

        public WGLGCDisposerRecord(long l, int n) {
            this.pCfgInfo = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
            oGLRenderQueue.lock();
            try {
                oGLRenderQueue.flushAndInvokeNow(new Runnable(){

                    public void run() {
                        AccelDeviceEventNotifier.eventOccured(WGLGCDisposerRecord.this.screen, 0);
                        AccelDeviceEventNotifier.eventOccured(WGLGCDisposerRecord.this.screen, 1);
                    }
                });
            }
            finally {
                oGLRenderQueue.unlock();
            }
            if (this.pCfgInfo != 0L) {
                OGLRenderQueue.disposeGraphicsConfig(this.pCfgInfo);
                this.pCfgInfo = 0L;
            }
        }
    }

    private static class WGLGetConfigInfo
    implements Runnable {
        private int screen;
        private int pixfmt;
        private long cfginfo;

        private WGLGetConfigInfo(int n, int n2) {
            this.screen = n;
            this.pixfmt = n2;
        }

        public void run() {
            this.cfginfo = WGLGraphicsConfig.getWGLConfigInfo(this.screen, this.pixfmt);
        }

        public long getConfigInfo() {
            return this.cfginfo;
        }
    }
}

