/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.TCPClient;
import sun.security.krb5.internal.UDPClient;

public abstract class KrbKdcReq {
    private static final int DEFAULT_KDC_RETRY_LIMIT = 3;
    public static final int DEFAULT_KDC_TIMEOUT;
    private static final boolean DEBUG;
    private static int udpPrefLimit;
    private static final String BAD_POLICY_KEY = "krb5.kdc.bad.policy";
    private static int tryLessMaxRetries;
    private static int tryLessTimeout;
    private static final BpType badPolicy;
    protected byte[] obuf;
    protected byte[] ibuf;

    public String send(String string) throws IOException, KrbException {
        boolean bl = udpPrefLimit > 0 && this.obuf != null && this.obuf.length > udpPrefLimit;
        return this.send(string, bl);
    }

    public String send(String string, boolean bl) throws IOException, KrbException {
        if (this.obuf == null) {
            return null;
        }
        Exception exception = null;
        Config config = Config.getInstance();
        if (string == null && (string = config.getDefaultRealm()) == null) {
            throw new KrbException(60, "Cannot find default realm");
        }
        String string2 = config.getKDCList(string);
        if (string2 == null) {
            throw new KrbException("Cannot get kdc for realm " + string);
        }
        String string3 = null;
        String[] stringArray = KdcAccessibility.list(string2);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4;
            string3 = string4 = stringArray[i];
            try {
                this.send(string, string3, bl);
                KdcAccessibility.removeBad(string3);
                break;
            }
            catch (Exception exception2) {
                if (DEBUG) {
                    System.out.println(">>> KrbKdcReq send: error trying " + string3);
                    exception2.printStackTrace(System.out);
                }
                KdcAccessibility.addBad(string3);
                exception = exception2;
                continue;
            }
        }
        if (this.ibuf == null && exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (KrbException)exception;
        }
        return string3;
    }

    public void send(String string, String string2, boolean bl) throws IOException, KrbException {
        int n;
        if (this.obuf == null) {
            return;
        }
        int n2 = 88;
        int n3 = 3;
        int n4 = this.getKdcTimeout(string);
        if (badPolicy == BpType.TRY_LESS && KdcAccessibility.isBad(string2)) {
            if (n3 > tryLessMaxRetries) {
                n3 = tryLessMaxRetries;
            }
            if (n4 > tryLessTimeout) {
                n4 = tryLessTimeout;
            }
        }
        String string3 = null;
        String string4 = null;
        if (string2.charAt(0) == '[') {
            n = string2.indexOf(93, 1);
            if (n == -1) {
                throw new IOException("Illegal KDC: " + string2);
            }
            string3 = string2.substring(1, n);
            if (n != string2.length() - 1) {
                if (string2.charAt(n + 1) != ':') {
                    throw new IOException("Illegal KDC: " + string2);
                }
                string4 = string2.substring(n + 2);
            }
        } else {
            n = string2.indexOf(58);
            if (n == -1) {
                string3 = string2;
            } else {
                int n5 = string2.indexOf(58, n + 1);
                if (n5 > 0) {
                    string3 = string2;
                } else {
                    string3 = string2.substring(0, n);
                    string4 = string2.substring(n + 1);
                }
            }
        }
        if (string4 != null && (n = KrbKdcReq.parsePositiveIntString(string4)) > 0) {
            n2 = n;
        }
        if (DEBUG) {
            System.out.println(">>> KrbKdcReq send: kdc=" + string3 + (bl ? " TCP:" : " UDP:") + n2 + ", timeout=" + n4 + ", number of retries =" + n3 + ", #bytes=" + this.obuf.length);
        }
        KdcCommunication kdcCommunication = new KdcCommunication(string3, n2, bl, n4, n3, this.obuf);
        try {
            this.ibuf = (byte[])AccessController.doPrivileged(kdcCommunication);
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq send: #bytes read=" + (this.ibuf != null ? this.ibuf.length : 0));
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (KrbException)exception;
        }
        if (DEBUG) {
            System.out.println(">>> KrbKdcReq send: #bytes read=" + (this.ibuf != null ? this.ibuf.length : 0));
        }
    }

    private int getKdcTimeout(String string) {
        int n = DEFAULT_KDC_TIMEOUT;
        if (string == null) {
            return n;
        }
        int n2 = -1;
        try {
            String string2 = Config.getInstance().getDefault("kdc_timeout", string);
            n2 = KrbKdcReq.parsePositiveIntString(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 0) {
            n = n2;
        }
        return n;
    }

    private static int parsePositiveIntString(String string) {
        if (string == null) {
            return -1;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    static {
        int n;
        block8: {
            String[] stringArray;
            DEBUG = Krb5.DEBUG;
            udpPrefLimit = -1;
            tryLessMaxRetries = 1;
            tryLessTimeout = 5000;
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty(KrbKdcReq.BAD_POLICY_KEY);
                }
            });
            if (string != null) {
                String[] stringArray2 = (string = string.toLowerCase(Locale.ENGLISH)).split(":");
                if ("tryless".equals(stringArray2[0])) {
                    if (stringArray2.length > 1) {
                        stringArray = stringArray2[1].split(",");
                        tryLessMaxRetries = Integer.parseInt(stringArray[0]);
                        if (stringArray.length > 1) {
                            tryLessTimeout = Integer.parseInt(stringArray[1]);
                        }
                    }
                    badPolicy = BpType.TRY_LESS;
                } else {
                    badPolicy = "trylast".equals(stringArray2[0]) ? BpType.TRY_LAST : BpType.NONE;
                }
            } else {
                badPolicy = BpType.NONE;
            }
            n = -1;
            try {
                stringArray = Config.getInstance();
                String string2 = stringArray.getDefault("kdc_timeout", "libdefaults");
                n = KrbKdcReq.parsePositiveIntString(string2);
                string2 = stringArray.getDefault("udp_preference_limit", "libdefaults");
                udpPrefLimit = KrbKdcReq.parsePositiveIntString(string2);
            }
            catch (Exception exception) {
                if (!DEBUG) break block8;
                System.out.println("Exception in getting kdc_timeout value, using default value " + exception.getMessage());
            }
        }
        DEFAULT_KDC_TIMEOUT = n > 0 ? n : 30000;
    }

    static class KdcAccessibility {
        private static Set<String> bads = new HashSet<String>();

        KdcAccessibility() {
        }

        private static synchronized void addBad(String string) {
            if (DEBUG) {
                System.out.println(">>> KdcAccessibility: add " + string);
            }
            bads.add(string);
        }

        private static synchronized void removeBad(String string) {
            if (DEBUG) {
                System.out.println(">>> KdcAccessibility: remove " + string);
            }
            bads.remove(string);
        }

        private static synchronized boolean isBad(String string) {
            return bads.contains(string);
        }

        public static synchronized void reset() {
            if (DEBUG) {
                System.out.println(">>> KdcAccessibility: reset");
            }
            bads.clear();
        }

        private static synchronized String[] list(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (badPolicy == BpType.TRY_LAST) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (bads.contains(string2)) {
                        arrayList2.add(string2);
                        continue;
                    }
                    arrayList.add(string2);
                }
                arrayList.addAll(arrayList2);
            } else {
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }

    private static class KdcCommunication
    implements PrivilegedExceptionAction {
        private String kdc;
        private int port;
        private boolean useTCP;
        private int timeout;
        private int retries;
        private byte[] obuf;

        public KdcCommunication(String string, int n, boolean bl, int n2, int n3, byte[] byArray) {
            this.kdc = string;
            this.port = n;
            this.useTCP = bl;
            this.timeout = n2;
            this.retries = n3;
            this.obuf = byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws IOException, KrbException {
            byte[] byArray = null;
            if (this.useTCP) {
                TCPClient tCPClient = new TCPClient(this.kdc, this.port);
                try {
                    tCPClient.send(this.obuf);
                    byArray = tCPClient.receive();
                }
                finally {
                    tCPClient.close();
                }
            }
            for (int i = 1; i <= this.retries; ++i) {
                UDPClient uDPClient = new UDPClient(this.kdc, this.port, this.timeout);
                if (DEBUG) {
                    System.out.println(">>> KDCCommunication: kdc=" + this.kdc + (this.useTCP ? " TCP:" : " UDP:") + this.port + ", timeout=" + this.timeout + ",Attempt =" + i + ", #bytes=" + this.obuf.length);
                }
                uDPClient.send(this.obuf);
                try {
                    byArray = uDPClient.receive();
                    uDPClient.close();
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    try {
                        if (DEBUG) {
                            System.out.println("SocketTimeOutException with attempt: " + i);
                        }
                        if (i != this.retries) continue;
                        byArray = null;
                        throw socketTimeoutException;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        uDPClient.close();
                    }
                }
            }
            return byArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BpType {
        NONE,
        TRY_LAST,
        TRY_LESS;

    }
}

