/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.jnlp.AppletAudioClip;
import com.sun.jnlp.AppletContainerCallback;
import com.sun.jnlp.ImageCache;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public final class AppletContainer
extends JPanel {
    final AppletContainerCallback callback;
    final Applet applet;
    final String appletName;
    final URL documentBase;
    final URL codeBase;
    final Properties parameters;
    final boolean[] isActive = new boolean[]{false};
    int appletWidth;
    int appletHeight;
    final JLabel statusLabel = new JLabel("");
    static PrivilegedAction loadImageActionDummy = new LoadImageAction(null);

    public AppletContainer(AppletContainerCallback appletContainerCallback, Applet applet, String string, URL uRL, URL uRL2, int n, int n2, Properties properties) {
        this.callback = appletContainerCallback;
        this.applet = applet;
        this.appletName = string;
        this.documentBase = uRL;
        this.codeBase = uRL2;
        this.parameters = properties;
        this.isActive[0] = false;
        this.appletWidth = n;
        this.appletHeight = n2;
        AppletContainerContext appletContainerContext = new AppletContainerContext();
        AppletContainerStub appletContainerStub = new AppletContainerStub(appletContainerContext);
        applet.setStub(appletContainerStub);
        this.statusLabel.setBorder(new EtchedBorder());
        this.statusLabel.setText("Loading...");
        this.setLayout(new BorderLayout());
        this.add("Center", applet);
        this.add("South", this.statusLabel);
        Dimension dimension = new Dimension(this.appletWidth, this.appletHeight + (int)this.statusLabel.getPreferredSize().getHeight());
        this.setPreferredSize(dimension);
    }

    public Applet getApplet() {
        return this.applet;
    }

    public void setStatus(String string) {
        this.statusLabel.setText(string);
    }

    public void resizeApplet(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return;
        }
        int n3 = n - this.appletWidth;
        int n4 = n2 - this.appletHeight;
        Dimension dimension = this.getSize();
        Dimension dimension2 = new Dimension((int)dimension.getWidth() + n3, (int)dimension.getHeight() + n4);
        this.setSize(dimension2);
        this.callback.relativeResize(new Dimension(n3, n4));
        this.appletWidth = n;
        this.appletHeight = n2;
    }

    public Dimension getPreferredFrameSize(Frame frame) {
        Insets insets = frame.getInsets();
        int n = this.appletWidth + (insets.left + insets.right);
        int n2 = this.appletHeight + this.statusLabel.getHeight() + (insets.top + insets.bottom);
        return new Dimension(n, n2);
    }

    public void startApplet() {
        ImageCache.initialize();
        new AppletAudioClip();
        new Thread(){

            public void run() {
                try {
                    AppletContainer.this.setStatus("Initializing Applet");
                    AppletContainer.this.applet.init();
                    try {
                        AppletContainer.this.isActive[0] = true;
                        AppletContainer.this.applet.start();
                        AppletContainer.this.setStatus("Applet running...");
                    }
                    catch (Throwable throwable) {
                        AppletContainer.this.setStatus("Failed to start Applet: " + throwable.toString());
                        throwable.printStackTrace(System.out);
                        AppletContainer.this.isActive[0] = false;
                    }
                }
                catch (Throwable throwable) {
                    AppletContainer.this.setStatus("Failed to initialize: " + throwable.toString());
                    throwable.printStackTrace(System.out);
                }
            }
        }.start();
    }

    public void stopApplet() {
        this.applet.stop();
        this.applet.destroy();
        try {
            Main.systemExit(0);
        }
        catch (ExitException exitException) {
            Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)exitException);
        }
    }

    static void showApplet(AppletContainerCallback appletContainerCallback, final Applet applet, String string, URL uRL, URL uRL2, int n, int n2, Properties properties) {
        JFrame jFrame = new JFrame("Applet Window");
        final AppletContainer appletContainer = new AppletContainer(appletContainerCallback, applet, string, uRL, uRL2, n, n2, properties);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add("Center", appletContainer);
        jFrame.pack();
        jFrame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    appletContainer.setStatus("Initializing Applet");
                    applet.init();
                    applet.start();
                    appletContainer.setStatus("Applet Running");
                }
                catch (Throwable throwable) {
                    appletContainer.setStatus("Failed to start Applet");
                }
            }
        });
    }

    final class AppletContainerStub
    implements AppletStub {
        AppletContext context;

        AppletContainerStub(AppletContext appletContext) {
            this.context = appletContext;
        }

        public void appletResize(int n, int n2) {
            AppletContainer.this.resizeApplet(n, n2);
        }

        public AppletContext getAppletContext() {
            return this.context;
        }

        public URL getCodeBase() {
            return AppletContainer.this.codeBase;
        }

        public URL getDocumentBase() {
            return AppletContainer.this.documentBase;
        }

        public String getParameter(String string) {
            return AppletContainer.this.parameters.getProperty(string);
        }

        public boolean isActive() {
            return AppletContainer.this.isActive[0];
        }
    }

    class AppletContainerContext
    implements AppletContext {
        AppletContainerContext() {
        }

        public Applet getApplet(String string) {
            return string.equals(AppletContainer.this.appletName) ? AppletContainer.this.applet : null;
        }

        public Enumeration getApplets() {
            Vector<Applet> vector = new Vector<Applet>();
            vector.add(AppletContainer.this.applet);
            return vector.elements();
        }

        public AudioClip getAudioClip(URL uRL) {
            return AppletAudioClip.get(uRL);
        }

        public Image getImage(URL uRL) {
            LoadImageAction loadImageAction = new LoadImageAction(uRL);
            return (Image)AccessController.doPrivileged(loadImageAction);
        }

        public void showDocument(final URL uRL) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread thread = new Thread(){

                        public void run() {
                            ((AppletContainerContext)(this).AppletContainerContext.this).AppletContainer.this.callback.showDocument(uRL);
                        }
                    };
                    thread.start();
                    return null;
                }
            });
        }

        public void showDocument(URL uRL, String string) {
            this.showDocument(uRL);
        }

        public void showStatus(String string) {
            AppletContainer.this.statusLabel.setText(string);
        }

        public void setStream(String string, InputStream inputStream) {
        }

        public InputStream getStream(String string) {
            return null;
        }

        public Iterator getStreamKeys() {
            return null;
        }
    }

    static class LoadImageAction
    implements PrivilegedAction {
        URL _url;

        public LoadImageAction(URL uRL) {
            this._url = uRL;
        }

        public Object run() {
            return ImageCache.getImage(this._url);
        }
    }
}

