/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jxl.biff.IntegerHelper;
import jxl.biff.drawing.BlipType;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;

class BlipStoreEntry
extends EscherAtom {
    private BlipType type;
    private File imageFile;
    private byte[] data;
    private int imageFileLength;
    private int referenceCount;

    public BlipStoreEntry(EscherRecordData erd) {
        super(erd);
        this.type = BlipType.getType(this.getInstance());
        byte[] bytes = this.getBytes();
        this.referenceCount = IntegerHelper.getInt(bytes[24], bytes[25], bytes[26], bytes[27]);
    }

    public BlipStoreEntry(Drawing d) throws IOException {
        super(EscherRecordType.BSE);
        this.imageFile = d.getImageFile();
        this.type = BlipType.PNG;
        this.setVersion(2);
        this.setInstance(this.type.getValue());
        this.imageFileLength = (int)this.imageFile.length();
        this.data = new byte[this.imageFileLength + 61];
        FileInputStream fis = new FileInputStream(this.imageFile);
        fis.read(this.data, 61, this.imageFileLength);
        fis.close();
        this.referenceCount = d.getReferenceCount();
    }

    public BlipType getBlipType() {
        return this.type;
    }

    public byte[] getData() {
        if (this.imageFile != null) {
            this.data[0] = (byte)this.type.getValue();
            this.data[1] = (byte)this.type.getValue();
            IntegerHelper.getFourBytes(this.imageFileLength + 8 + 17, this.data, 20);
            IntegerHelper.getFourBytes(this.referenceCount, this.data, 24);
            IntegerHelper.getFourBytes(0, this.data, 28);
            this.data[32] = 0;
            this.data[33] = 0;
            this.data[34] = 126;
            this.data[35] = 1;
            this.data[36] = 0;
            this.data[37] = 110;
            IntegerHelper.getTwoBytes(61470, this.data, 38);
            IntegerHelper.getFourBytes(this.imageFileLength + 17, this.data, 40);
        } else {
            this.data = this.getBytes();
        }
        return this.setHeaderData(this.data);
    }

    void dereference() {
        --this.referenceCount;
        Assert.verify(this.referenceCount >= 0);
    }

    int getReferenceCount() {
        return this.referenceCount;
    }
}

