/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class IBM_EBCDIC_DBCS {
    IBM_EBCDIC_DBCS() {
    }

    static abstract class Encoder
    extends CharsetEncoder {
        protected static final int MAX_SINGLEBYTE = 255;
        protected int currentState;
        static final int SBCS = 0;
        static final int DBCS = 1;
        static final byte SO = 14;
        static final byte SI = 15;
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        Encoder(Charset charset) {
            this(charset, 4.0f, 5.0f, new byte[]{111});
        }

        Encoder(Charset charset, float f, float f2, byte[] byArray) {
            super(charset, f, f2, byArray);
        }

        protected void implReset() {
            this.currentState = 0;
        }

        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            if (this.currentState == 1) {
                if (byteBuffer.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)15);
            }
            this.implReset();
            return CoderResult.UNDERFLOW;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n;
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            try {
                for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                    char c = cArray[n];
                    int n5 = this.encodeChar(c);
                    if (n5 == 65533) {
                        if (Surrogate.is(c)) {
                            if (this.sgp.parse(c, cArray, n, n2) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (n5 > 255) {
                        if (this.currentState == 0) {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            this.currentState = 1;
                            byArray[n3++] = 14;
                        }
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(n5 >> 8);
                        byArray[n3++] = (byte)n5;
                        continue;
                    }
                    if (this.currentState == 1) {
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        this.currentState = 0;
                        byArray[n3++] = 15;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)n5;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    int n2 = this.encodeChar(c);
                    if (n2 == 65533) {
                        if (Surrogate.is(c)) {
                            if (this.sgp.parse(c, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (n2 > 255) {
                        if (this.currentState == 0) {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            this.currentState = 1;
                            byteBuffer.put((byte)14);
                        }
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(n2 >> 8));
                        byteBuffer.put((byte)n2);
                    } else {
                        if (this.currentState == 1) {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            this.currentState = 0;
                            byteBuffer.put((byte)15);
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)n2);
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        public boolean canEncode(char c) {
            return this.encodeChar(c) != 65533;
        }

        abstract int encodeChar(char var1);
    }

    static abstract class Decoder
    extends CharsetDecoder {
        private static final int SBCS = 0;
        private static final int DBCS = 1;
        private static final int SO = 14;
        private static final int SI = 15;
        private int currentState;

        Decoder(Charset charset) {
            super(charset, 0.5f, 1.0f);
        }

        protected void implReset() {
            this.currentState = 0;
        }

        private static boolean isDoubleByte(int n, int n2) {
            return n == 64 && n2 == 64 || 65 <= n && n <= 254 && 65 <= n2 && n2 <= 254;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n;
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            try {
                int n5;
                for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; n += n5) {
                    int n6 = byArray[n] & 0xFF;
                    n5 = 1;
                    if (n6 == 14) {
                        if (this.currentState != 0) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 1;
                        continue;
                    }
                    if (n6 == 15) {
                        if (this.currentState != 1) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 0;
                        continue;
                    }
                    int n7 = 65533;
                    if (this.currentState == 0) {
                        n7 = this.decodeSingle(n6);
                    } else {
                        if (n2 - n < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n8 = byArray[n + 1] & 0xFF;
                        if (!Decoder.isDoubleByte(n6, n8)) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        ++n5;
                        n7 = this.decodeDouble(n6, n8);
                    }
                    if (n7 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n5);
                        return coderResult;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = n7;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    int n2 = byteBuffer.get() & 0xFF;
                    int n3 = 1;
                    if (n2 == 14) {
                        if (this.currentState != 0) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 1;
                    } else if (n2 == 15) {
                        if (this.currentState != 1) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 0;
                    } else {
                        char c = '\ufffd';
                        if (this.currentState == 0) {
                            c = this.decodeSingle(n2);
                        } else {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            int n4 = byteBuffer.get() & 0xFF;
                            if (!Decoder.isDoubleByte(n2, n4)) {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            ++n3;
                            c = this.decodeDouble(n2, n4);
                        }
                        if (c == '\ufffd') {
                            CoderResult coderResult = CoderResult.unmappableForLength(n3);
                            return coderResult;
                        }
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c);
                    }
                    n += n3;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        abstract char decodeSingle(int var1);

        abstract char decodeDouble(int var1, int var2);
    }
}

