/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class ISO2022
extends Charset {
    private static final byte ISO_ESC = 27;
    private static final byte ISO_SI = 15;
    private static final byte ISO_SO = 14;
    private static final byte ISO_SS2_7 = 78;
    private static final byte ISO_SS3_7 = 79;
    private static final byte MSB = -128;
    private static final char REPLACE_CHAR = '\ufffd';
    private static final byte minDesignatorLength = 3;

    public ISO2022(String string, String[] stringArray) {
        super(string, stringArray);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected static class Encoder
    extends CharsetEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        private final byte SS2 = (byte)-114;
        private final byte P2 = (byte)-94;
        private final byte P3 = (byte)-93;
        private final byte MSB = (byte)-128;
        protected final byte maximumDesignatorLength = (byte)4;
        protected String SODesig;
        protected String SS2Desig = null;
        protected String SS3Desig = null;
        protected CharsetEncoder ISOEncoder;
        private boolean shiftout = false;
        private boolean SODesDefined = false;
        private boolean SS2DesDefined = false;
        private boolean SS3DesDefined = false;
        private boolean newshiftout = false;
        private boolean newSODesDefined = false;
        private boolean newSS2DesDefined = false;
        private boolean newSS3DesDefined = false;

        protected Encoder(Charset charset) {
            super(charset, 4.0f, 8.0f);
        }

        public boolean canEncode(char c) {
            return this.ISOEncoder.canEncode(c);
        }

        protected void implReset() {
            this.shiftout = false;
            this.SODesDefined = false;
            this.SS2DesDefined = false;
            this.SS3DesDefined = false;
        }

        private int unicodeToNative(char c, byte[] byArray) {
            int n;
            int n2 = 0;
            char[] cArray = new char[]{c};
            byte[] byArray2 = new byte[4];
            try {
                CharBuffer charBuffer = CharBuffer.wrap(cArray);
                ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                this.ISOEncoder.encode(charBuffer, byteBuffer, true);
                byteBuffer.flip();
                n = byteBuffer.remaining();
                byteBuffer.get(byArray2, 0, n);
            }
            catch (Exception exception) {
                return -1;
            }
            if (n == 2) {
                if (!this.SODesDefined) {
                    this.newSODesDefined = true;
                    byArray[0] = 27;
                    byte[] byArray3 = this.SODesig.getBytes();
                    System.arraycopy(byArray3, 0, byArray, 1, byArray3.length);
                    n2 = byArray3.length + 1;
                }
                if (!this.shiftout) {
                    this.newshiftout = true;
                    byArray[n2++] = 14;
                }
                byArray[n2++] = (byte)(byArray2[0] & 0x7F);
                byArray[n2++] = (byte)(byArray2[1] & 0x7F);
            } else {
                byte[] byArray4;
                if (byArray2[0] == -114 && byArray2[1] == -94) {
                    if (!this.SS2DesDefined) {
                        this.newSS2DesDefined = true;
                        byArray[0] = 27;
                        byArray4 = this.SS2Desig.getBytes();
                        System.arraycopy(byArray4, 0, byArray, 1, byArray4.length);
                        n2 = byArray4.length + 1;
                    }
                    byArray[n2++] = 27;
                    byArray[n2++] = 78;
                    byArray[n2++] = (byte)(byArray2[2] & 0x7F);
                    byArray[n2++] = (byte)(byArray2[3] & 0x7F);
                }
                if (byArray2[0] == -114 && byArray2[1] == 163) {
                    if (!this.SS3DesDefined) {
                        this.newSS3DesDefined = true;
                        byArray[0] = 27;
                        byArray4 = this.SS3Desig.getBytes();
                        System.arraycopy(byArray4, 0, byArray, 1, byArray4.length);
                        n2 = byArray4.length + 1;
                    }
                    byArray[n2++] = 27;
                    byArray[n2++] = 79;
                    byArray[n2++] = (byte)(byArray2[2] & 0x7F);
                    byArray[n2++] = (byte)(byArray2[3] & 0x7F);
                }
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            byte[] byArray2 = new byte[8];
            this.newshiftout = this.shiftout;
            this.newSODesDefined = this.SODesDefined;
            this.newSS2DesDefined = this.SS2DesDefined;
            this.newSS3DesDefined = this.SS3DesDefined;
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    char c = cArray[n];
                    if (Surrogate.is(c)) {
                        if (this.sgp.parse(c, cArray, n, n2) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (c < '\u0080') {
                        if (this.shiftout) {
                            this.newshiftout = false;
                            n5 = 2;
                            byArray2[0] = 15;
                            byArray2[1] = (byte)(c & 0x7F);
                        } else {
                            n5 = 1;
                            byArray2[0] = (byte)(c & 0x7F);
                        }
                        if (cArray[n] == '\n') {
                            this.newSODesDefined = false;
                            this.newSS2DesDefined = false;
                            this.newSS3DesDefined = false;
                        }
                    } else {
                        n5 = this.unicodeToNative(c, byArray2);
                        if (n5 == 0) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (n4 - n3 < n5) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (int i = 0; i < n5; ++i) {
                        byArray[n3++] = byArray2[i];
                    }
                    this.shiftout = this.newshiftout;
                    this.SODesDefined = this.newSODesDefined;
                    this.SS2DesDefined = this.newSS2DesDefined;
                    this.SS3DesDefined = this.newSS3DesDefined;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = 0;
            byte[] byArray = new byte[8];
            boolean bl = false;
            this.newshiftout = this.shiftout;
            this.newSODesDefined = this.SODesDefined;
            this.newSS2DesDefined = this.SS2DesDefined;
            this.newSS3DesDefined = this.SS3DesDefined;
            int n2 = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    if (Surrogate.is(c)) {
                        if (this.sgp.parse(c, charBuffer) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (c < '\u0080') {
                        if (this.shiftout) {
                            this.newshiftout = false;
                            n = 2;
                            byArray[0] = 15;
                            byArray[1] = (byte)(c & 0x7F);
                        } else {
                            n = 1;
                            byArray[0] = (byte)(c & 0x7F);
                        }
                        if (c == '\n') {
                            this.newSODesDefined = false;
                            this.newSS2DesDefined = false;
                            this.newSS3DesDefined = false;
                        }
                    } else {
                        n = this.unicodeToNative(c, byArray);
                        if (n == 0) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (byteBuffer.remaining() < n) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (int i = 0; i < n; ++i) {
                        byteBuffer.put(byArray[i]);
                    }
                    ++n2;
                    this.shiftout = this.newshiftout;
                    this.SODesDefined = this.newSODesDefined;
                    this.SS2DesDefined = this.newSS2DesDefined;
                    this.SS3DesDefined = this.newSS3DesDefined;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }

    protected static class Decoder
    extends CharsetDecoder {
        protected byte[][] SODesig;
        protected byte[][] SS2Desig = null;
        protected byte[][] SS3Desig = null;
        protected CharsetDecoder[] SODecoder;
        protected CharsetDecoder[] SS2Decoder = null;
        protected CharsetDecoder[] SS3Decoder = null;
        private static final byte SOFlag = 0;
        private static final byte SS2Flag = 1;
        private static final byte SS3Flag = 2;
        private int curSODes;
        private int curSS2Des;
        private int curSS3Des;
        private boolean shiftout;
        private CharsetDecoder[] tmpDecoder;

        protected Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected void implReset() {
            this.curSODes = 0;
            this.curSS2Des = 0;
            this.curSS3Des = 0;
            this.shiftout = false;
        }

        private char decode(byte by, byte by2, byte by3) {
            by = (byte)(by | 0xFFFFFF80);
            by2 = (byte)(by2 | 0xFFFFFF80);
            byte[] byArray = new byte[]{by, by2};
            char[] cArray = new char[1];
            int n = 0;
            int n2 = 0;
            switch (by3) {
                case 0: {
                    n2 = this.curSODes;
                    this.tmpDecoder = this.SODecoder;
                    break;
                }
                case 1: {
                    n2 = this.curSS2Des;
                    this.tmpDecoder = this.SS2Decoder;
                    break;
                }
                case 2: {
                    n2 = this.curSS3Des;
                    this.tmpDecoder = this.SS3Decoder;
                }
            }
            if (this.tmpDecoder != null) {
                for (n = 0; n < this.tmpDecoder.length; ++n) {
                    if (n2 != n) continue;
                    try {
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, 2);
                        CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, 1);
                        this.tmpDecoder[n].decode(byteBuffer, charBuffer, true);
                        charBuffer.flip();
                        return charBuffer.get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return '\ufffd';
        }

        private int findDesig(byte[] byArray, int n, int n2, byte[][] byArray2) {
            if (byArray2 == null) {
                return -1;
            }
            for (int i = 0; i < byArray2.length; ++i) {
                int n3;
                if (byArray2[i] == null || n2 - n < byArray2[i].length) continue;
                for (n3 = 0; n3 < byArray2[i].length && byArray[n + n3] == byArray2[i][n3]; ++n3) {
                }
                if (n3 != byArray2[i].length) continue;
                return i;
            }
            return -1;
        }

        private int findDesigBuf(ByteBuffer byteBuffer, byte[][] byArray) {
            if (byArray == null) {
                return -1;
            }
            for (int i = 0; i < byArray.length; ++i) {
                int n;
                if (byArray[i] == null || byteBuffer.remaining() < byArray[i].length) continue;
                byteBuffer.mark();
                for (n = 0; n < byArray[i].length && byteBuffer.get() == byArray[i][n]; ++n) {
                }
                if (n == byArray[i].length) {
                    return i;
                }
                byteBuffer.reset();
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            int n6 = 0;
            byte by = 0;
            try {
                int n7;
                block22: for (n = n <= n2 ? n : n2; n < n2; n += n7) {
                    n5 = byArray[n] & 0xFF;
                    n7 = 1;
                    switch (n5) {
                        case 14: {
                            this.shiftout = true;
                            n7 = 1;
                            continue block22;
                        }
                        case 15: {
                            this.shiftout = false;
                            n7 = 1;
                            continue block22;
                        }
                        case 27: {
                            if (n2 - n - 1 < 3) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            int n8 = this.findDesig(byArray, n + 1, n2, this.SODesig);
                            if (n8 != -1) {
                                this.curSODes = n8;
                                n7 = this.SODesig[n8].length + 1;
                                continue block22;
                            }
                            n8 = this.findDesig(byArray, n + 1, n2, this.SS2Desig);
                            if (n8 != -1) {
                                this.curSS2Des = n8;
                                n7 = this.SS2Desig[n8].length + 1;
                                continue block22;
                            }
                            n8 = this.findDesig(byArray, n + 1, n2, this.SS3Desig);
                            if (n8 != -1) {
                                this.curSS3Des = n8;
                                n7 = this.SS3Desig[n8].length + 1;
                                continue block22;
                            }
                            if (n2 - n < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n5 = byArray[n + 1];
                            switch (n5) {
                                case 78: {
                                    if (n2 - n < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n6 = byArray[n + 2];
                                    by = byArray[n + 3];
                                    if (n4 - n3 < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    cArray[n3] = this.decode((byte)n6, by, (byte)1);
                                    ++n3;
                                    n7 = 4;
                                    continue block22;
                                }
                                case 79: {
                                    if (n2 - n < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n6 = byArray[n + 2];
                                    by = byArray[n + 3];
                                    if (n4 - n3 < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    cArray[n3] = this.decode((byte)n6, by, (byte)2);
                                    ++n3;
                                    n7 = 4;
                                    continue block22;
                                }
                            }
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        default: {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (!this.shiftout) {
                                cArray[n3++] = (char)byArray[n];
                                continue block22;
                            }
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (n2 - n < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n6 = byArray[n + 1] & 0xFF;
                            cArray[n3++] = this.decode((byte)n5, (byte)n6, (byte)0);
                            n7 = 2;
                        }
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            byte by = 0;
            int n2 = 0;
            byte by2 = 0;
            try {
                while (byteBuffer.hasRemaining()) {
                    by = byteBuffer.get();
                    int n3 = 1;
                    block12 : switch (by) {
                        case 14: {
                            this.shiftout = true;
                            break;
                        }
                        case 15: {
                            this.shiftout = false;
                            break;
                        }
                        case 27: {
                            if (byteBuffer.remaining() < 3) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            int n4 = this.findDesigBuf(byteBuffer, this.SODesig);
                            if (n4 != -1) {
                                this.curSODes = n4;
                                n3 = this.SODesig[n4].length + 1;
                                break;
                            }
                            n4 = this.findDesigBuf(byteBuffer, this.SS2Desig);
                            if (n4 != -1) {
                                this.curSS2Des = n4;
                                n3 = this.SS2Desig[n4].length + 1;
                                break;
                            }
                            n4 = this.findDesigBuf(byteBuffer, this.SS3Desig);
                            if (n4 != -1) {
                                this.curSS3Des = n4;
                                n3 = this.SS3Desig[n4].length + 1;
                                break;
                            }
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            by = byteBuffer.get();
                            switch (by) {
                                case 78: {
                                    if (byteBuffer.remaining() < 2) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n2 = byteBuffer.get();
                                    by2 = byteBuffer.get();
                                    if (charBuffer.remaining() < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    charBuffer.put(this.decode((byte)n2, by2, (byte)1));
                                    n3 = 4;
                                    break block12;
                                }
                                case 79: {
                                    if (byteBuffer.remaining() < 2) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n2 = byteBuffer.get();
                                    by2 = byteBuffer.get();
                                    if (charBuffer.remaining() < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    charBuffer.put(this.decode((byte)n2, by2, (byte)2));
                                    n3 = 4;
                                    break block12;
                                }
                            }
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        default: {
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (!this.shiftout) {
                                charBuffer.put((char)by);
                                break;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n2 = byteBuffer.get() & 0xFF;
                            charBuffer.put(this.decode(by, (byte)n2, (byte)0));
                            n3 = 2;
                        }
                    }
                    n += n3;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                CoderResult coderResult = CoderResult.OVERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }
}

