/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.writer;

import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.bind.v2.schemagen.Util;
import com.sun.xml.internal.txw2.TXW;
import com.sun.xml.internal.txw2.TypedXmlWriter;
import com.sun.xml.internal.txw2.output.ResultFactory;
import com.sun.xml.internal.txw2.output.XmlSerializer;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.model.MEP;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.model.soap.SOAPBinding;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGenExtnContext;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBindingImpl;
import com.sun.xml.internal.ws.util.RuntimeVersion;
import com.sun.xml.internal.ws.wsdl.writer.W3CAddressingWSDLGeneratorExtension;
import com.sun.xml.internal.ws.wsdl.writer.WSDLGeneratorExtensionFacade;
import com.sun.xml.internal.ws.wsdl.writer.WSDLResolver;
import com.sun.xml.internal.ws.wsdl.writer.document.Binding;
import com.sun.xml.internal.ws.wsdl.writer.document.BindingOperationType;
import com.sun.xml.internal.ws.wsdl.writer.document.Definitions;
import com.sun.xml.internal.ws.wsdl.writer.document.Fault;
import com.sun.xml.internal.ws.wsdl.writer.document.FaultType;
import com.sun.xml.internal.ws.wsdl.writer.document.Import;
import com.sun.xml.internal.ws.wsdl.writer.document.Message;
import com.sun.xml.internal.ws.wsdl.writer.document.Operation;
import com.sun.xml.internal.ws.wsdl.writer.document.ParamType;
import com.sun.xml.internal.ws.wsdl.writer.document.Part;
import com.sun.xml.internal.ws.wsdl.writer.document.Port;
import com.sun.xml.internal.ws.wsdl.writer.document.PortType;
import com.sun.xml.internal.ws.wsdl.writer.document.Service;
import com.sun.xml.internal.ws.wsdl.writer.document.StartWithExtensionsType;
import com.sun.xml.internal.ws.wsdl.writer.document.Types;
import com.sun.xml.internal.ws.wsdl.writer.document.soap.Body;
import com.sun.xml.internal.ws.wsdl.writer.document.soap.BodyType;
import com.sun.xml.internal.ws.wsdl.writer.document.soap12.Header;
import com.sun.xml.internal.ws.wsdl.writer.document.soap12.SOAPAddress;
import com.sun.xml.internal.ws.wsdl.writer.document.soap12.SOAPFault;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGenerator {
    private JAXWSOutputSchemaResolver resolver;
    private WSDLResolver wsdlResolver = null;
    private AbstractSEIModelImpl model;
    private Definitions serviceDefinitions;
    private Definitions portDefinitions;
    private Types types;
    private static final String DOT_WSDL = ".wsdl";
    private static final String RESPONSE = "Response";
    private static final String PARAMETERS = "parameters";
    private static final String RESULT = "parameters";
    private static final String UNWRAPPABLE_RESULT = "result";
    private static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    private static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String XSD_PREFIX = "xsd";
    private static final String SOAP11_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String SOAP12_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private static final String SOAP_PREFIX = "soap";
    private static final String SOAP12_PREFIX = "soap12";
    private static final String TNS_PREFIX = "tns";
    private static final String SOAP_HTTP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    private static final String SOAP12_HTTP_TRANSPORT = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    private static final String DOCUMENT = "document";
    private static final String RPC = "rpc";
    private static final String LITERAL = "literal";
    private static final String REPLACE_WITH_ACTUAL_URL = "REPLACE_WITH_ACTUAL_URL";
    private Set<QName> processedExceptions = new HashSet<QName>();
    private WSBinding binding;
    private String wsdlLocation;
    private String portWSDLID;
    private String schemaPrefix;
    private WSDLGeneratorExtension extension;
    List<WSDLGeneratorExtension> extensionHandlers;
    private String endpointAddress = "REPLACE_WITH_ACTUAL_URL";
    private Container container;
    private final Class implType;

    public WSDLGenerator(AbstractSEIModelImpl abstractSEIModelImpl, WSDLResolver wSDLResolver, WSBinding wSBinding, Container container, Class clazz, WSDLGeneratorExtension ... wSDLGeneratorExtensionArray) {
        this.model = abstractSEIModelImpl;
        this.resolver = new JAXWSOutputSchemaResolver();
        this.wsdlResolver = wSDLResolver;
        this.binding = wSBinding;
        this.container = container;
        this.implType = clazz;
        this.extensionHandlers = new ArrayList<WSDLGeneratorExtension>();
        this.register(new W3CAddressingWSDLGeneratorExtension());
        for (WSDLGeneratorExtension wSDLGeneratorExtension : wSDLGeneratorExtensionArray) {
            this.register(wSDLGeneratorExtension);
        }
        this.extension = new WSDLGeneratorExtensionFacade(this.extensionHandlers.toArray(new WSDLGeneratorExtension[0]));
    }

    public void setEndpointAddress(String string) {
        this.endpointAddress = string;
    }

    public void doGeneration() {
        CommentFilter commentFilter = null;
        String string = JAXBRIContext.mangleNameToClassName(this.model.getServiceQName().getLocalPart());
        Result result = this.wsdlResolver.getWSDL(string + DOT_WSDL);
        this.wsdlLocation = result.getSystemId();
        CommentFilter commentFilter2 = new CommentFilter(ResultFactory.createSerializer(result));
        if (this.model.getServiceQName().getNamespaceURI().equals(this.model.getTargetNamespace())) {
            commentFilter = commentFilter2;
            this.schemaPrefix = string + "_";
        } else {
            String string2 = JAXBRIContext.mangleNameToClassName(this.model.getPortTypeName().getLocalPart());
            if (string2.equals(string)) {
                string2 = string2 + "PortType";
            }
            Holder<String> holder = new Holder<String>();
            holder.value = string2 + DOT_WSDL;
            result = this.wsdlResolver.getAbstractWSDL(holder);
            if (result != null) {
                this.portWSDLID = result.getSystemId();
                commentFilter = this.portWSDLID.equals(this.wsdlLocation) ? commentFilter2 : new CommentFilter(ResultFactory.createSerializer(result));
            } else {
                this.portWSDLID = (String)holder.value;
            }
            this.schemaPrefix = new File(this.portWSDLID).getName();
            int n = this.schemaPrefix.lastIndexOf(46);
            if (n > 0) {
                this.schemaPrefix = this.schemaPrefix.substring(0, n);
            }
            this.schemaPrefix = JAXBRIContext.mangleNameToClassName(this.schemaPrefix) + "_";
        }
        this.generateDocument(commentFilter2, commentFilter);
    }

    private void generateDocument(XmlSerializer xmlSerializer, XmlSerializer xmlSerializer2) {
        this.serviceDefinitions = TXW.create(Definitions.class, xmlSerializer);
        this.serviceDefinitions._namespace(WSDL_NAMESPACE, "");
        this.serviceDefinitions._namespace(XSD_NAMESPACE, XSD_PREFIX);
        this.serviceDefinitions.targetNamespace(this.model.getServiceQName().getNamespaceURI());
        this.serviceDefinitions._namespace(this.model.getServiceQName().getNamespaceURI(), TNS_PREFIX);
        if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
            this.serviceDefinitions._namespace(SOAP12_NAMESPACE, SOAP12_PREFIX);
        } else {
            this.serviceDefinitions._namespace(SOAP11_NAMESPACE, SOAP_PREFIX);
        }
        this.serviceDefinitions.name(this.model.getServiceQName().getLocalPart());
        WSDLGenExtnContext wSDLGenExtnContext = new WSDLGenExtnContext(this.serviceDefinitions, this.model, this.binding, this.container, this.implType);
        this.extension.start(wSDLGenExtnContext);
        if (xmlSerializer != xmlSerializer2 && xmlSerializer2 != null) {
            this.portDefinitions = TXW.create(Definitions.class, xmlSerializer2);
            this.portDefinitions._namespace(WSDL_NAMESPACE, "");
            this.portDefinitions._namespace(XSD_NAMESPACE, XSD_PREFIX);
            if (this.model.getTargetNamespace() != null) {
                this.portDefinitions.targetNamespace(this.model.getTargetNamespace());
                this.portDefinitions._namespace(this.model.getTargetNamespace(), TNS_PREFIX);
            }
            String string = WSDLGenerator.relativize(this.portWSDLID, this.wsdlLocation);
            Import import_ = this.serviceDefinitions._import().namespace(this.model.getTargetNamespace());
            import_.location(string);
        } else if (xmlSerializer2 != null) {
            this.portDefinitions = this.serviceDefinitions;
        } else {
            String string = WSDLGenerator.relativize(this.portWSDLID, this.wsdlLocation);
            Import import_ = this.serviceDefinitions._import().namespace(this.model.getTargetNamespace());
            import_.location(string);
        }
        this.extension.addDefinitionsExtension(this.serviceDefinitions);
        if (this.portDefinitions != null) {
            this.generateTypes();
            this.generateMessages();
            this.generatePortType();
        }
        this.generateBinding();
        this.generateService();
        this.extension.end(wSDLGenExtnContext);
        this.serviceDefinitions.commit();
        if (this.portDefinitions != null && this.portDefinitions != this.serviceDefinitions) {
            this.portDefinitions.commit();
        }
    }

    protected void generateTypes() {
        this.types = this.portDefinitions.types();
        if (this.model.getJAXBContext() != null) {
            try {
                this.model.getJAXBContext().generateSchema(this.resolver);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new WebServiceException(iOException.getMessage());
            }
        }
    }

    protected void generateMessages() {
        for (JavaMethodImpl javaMethodImpl : this.model.getJavaMethods()) {
            this.generateSOAPMessages(javaMethodImpl, javaMethodImpl.getBinding());
        }
    }

    protected void generateSOAPMessages(JavaMethodImpl javaMethodImpl, SOAPBinding sOAPBinding) {
        Part part;
        boolean bl = sOAPBinding.isDocLit();
        Message message = this.portDefinitions.message().name(javaMethodImpl.getRequestMessageName());
        this.extension.addInputMessageExtension(message, javaMethodImpl);
        JAXBRIContext jAXBRIContext = this.model.getJAXBContext();
        boolean bl2 = true;
        for (ParameterImpl object : javaMethodImpl.getRequestParameters()) {
            if (bl) {
                if (this.isHeaderParameter(object)) {
                    bl2 = false;
                }
                if (object.isWrapperStyle()) {
                    part = message.part().name("parameters");
                    part.element(object.getName());
                    continue;
                }
                part = message.part().name(object.getPartName());
                part.element(object.getName());
                continue;
            }
            if (object.isWrapperStyle()) {
                for (ParameterImpl parameterImpl : ((WrapperParameter)object).getWrapperChildren()) {
                    part = message.part().name(parameterImpl.getPartName());
                    part.type(jAXBRIContext.getTypeName(parameterImpl.getBridge().getTypeReference()));
                }
                continue;
            }
            part = message.part().name(object.getPartName());
            part.element(object.getName());
        }
        if (javaMethodImpl.getMEP() != MEP.ONE_WAY) {
            message = this.portDefinitions.message().name(javaMethodImpl.getResponseMessageName());
            this.extension.addOutputMessageExtension(message, javaMethodImpl);
            if (bl2) {
                for (ParameterImpl parameterImpl : javaMethodImpl.getResponseParameters()) {
                    if (!this.isHeaderParameter(parameterImpl)) continue;
                    bl2 = false;
                }
            }
            for (ParameterImpl parameterImpl : javaMethodImpl.getResponseParameters()) {
                if (bl) {
                    if (parameterImpl.isWrapperStyle()) {
                        part = bl2 ? message.part().name("parameters") : message.part().name(UNWRAPPABLE_RESULT);
                        part.element(parameterImpl.getName());
                        continue;
                    }
                    part = message.part().name(parameterImpl.getPartName());
                    part.element(parameterImpl.getName());
                    continue;
                }
                if (parameterImpl.isWrapperStyle()) {
                    for (ParameterImpl parameterImpl2 : ((WrapperParameter)parameterImpl).getWrapperChildren()) {
                        part = message.part().name(parameterImpl2.getPartName());
                        part.type(jAXBRIContext.getTypeName(parameterImpl2.getBridge().getTypeReference()));
                    }
                    continue;
                }
                part = message.part().name(parameterImpl.getPartName());
                part.element(parameterImpl.getName());
            }
        }
        for (CheckedExceptionImpl checkedExceptionImpl : javaMethodImpl.getCheckedExceptions()) {
            Iterator<ParameterImpl> iterator = checkedExceptionImpl.getDetailType().tagName;
            String string = checkedExceptionImpl.getMessageName();
            QName qName = new QName(this.model.getTargetNamespace(), string);
            if (this.processedExceptions.contains(qName)) continue;
            message = this.portDefinitions.message().name(string);
            this.extension.addFaultMessageExtension(message, javaMethodImpl, checkedExceptionImpl);
            part = message.part().name("fault");
            part.element((QName)((Object)iterator));
            this.processedExceptions.add(qName);
        }
    }

    protected void generatePortType() {
        PortType portType = this.portDefinitions.portType().name(this.model.getPortTypeName().getLocalPart());
        this.extension.addPortTypeExtension(portType);
        for (JavaMethodImpl javaMethodImpl : this.model.getJavaMethods()) {
            Operation operation = portType.operation().name(javaMethodImpl.getOperationName());
            this.generateParameterOrder(operation, javaMethodImpl);
            this.extension.addOperationExtension(operation, javaMethodImpl);
            switch (javaMethodImpl.getMEP()) {
                case REQUEST_RESPONSE: {
                    this.generateInputMessage(operation, javaMethodImpl);
                    this.generateOutputMessage(operation, javaMethodImpl);
                    break;
                }
                case ONE_WAY: {
                    this.generateInputMessage(operation, javaMethodImpl);
                }
            }
            for (CheckedExceptionImpl checkedExceptionImpl : javaMethodImpl.getCheckedExceptions()) {
                QName qName = new QName(this.model.getTargetNamespace(), checkedExceptionImpl.getMessageName());
                FaultType faultType = operation.fault().message(qName).name(checkedExceptionImpl.getMessageName());
                this.extension.addOperationFaultExtension(faultType, javaMethodImpl, checkedExceptionImpl);
            }
        }
    }

    protected boolean isWrapperStyle(JavaMethodImpl javaMethodImpl) {
        if (javaMethodImpl.getRequestParameters().size() > 0) {
            ParameterImpl parameterImpl = javaMethodImpl.getRequestParameters().iterator().next();
            return parameterImpl.isWrapperStyle();
        }
        return false;
    }

    protected boolean isRpcLit(JavaMethodImpl javaMethodImpl) {
        return javaMethodImpl.getBinding().getStyle() == SOAPBinding.Style.RPC;
    }

    protected void generateParameterOrder(Operation operation, JavaMethodImpl javaMethodImpl) {
        if (javaMethodImpl.getMEP() == MEP.ONE_WAY) {
            return;
        }
        if (this.isRpcLit(javaMethodImpl)) {
            this.generateRpcParameterOrder(operation, javaMethodImpl);
        } else {
            this.generateDocumentParameterOrder(operation, javaMethodImpl);
        }
    }

    protected void generateRpcParameterOrder(Operation operation, JavaMethodImpl javaMethodImpl) {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        List<ParameterImpl> list = this.sortMethodParameters(javaMethodImpl);
        int n = 0;
        for (ParameterImpl parameterImpl : list) {
            String string;
            if (parameterImpl.getIndex() < 0 || hashSet.contains(string = parameterImpl.getPartName())) continue;
            if (n++ > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            hashSet.add(string);
        }
        if (n > 1) {
            operation.parameterOrder(stringBuffer.toString());
        }
    }

    protected void generateDocumentParameterOrder(Operation operation, JavaMethodImpl javaMethodImpl) {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        List<ParameterImpl> list = this.sortMethodParameters(javaMethodImpl);
        boolean bl = this.isWrapperStyle(javaMethodImpl);
        int n = 0;
        for (ParameterImpl parameterImpl : list) {
            if (parameterImpl.getIndex() < 0) continue;
            String string = bl && this.isBodyParameter(parameterImpl) ? (javaMethodImpl.getRequestParameters().contains(parameterImpl) ? "parameters" : RESPONSE) : parameterImpl.getPartName();
            if (hashSet.contains(string)) continue;
            if (n++ > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            hashSet.add(string);
        }
        if (n > 1) {
            operation.parameterOrder(stringBuffer.toString());
        }
    }

    protected List<ParameterImpl> sortMethodParameters(JavaMethodImpl javaMethodImpl) {
        ParameterImpl parameterImpl2;
        HashSet<ParameterImpl> hashSet = new HashSet<ParameterImpl>();
        ArrayList<ParameterImpl> arrayList = new ArrayList<ParameterImpl>();
        if (this.isRpcLit(javaMethodImpl)) {
            for (ParameterImpl parameterImpl2 : javaMethodImpl.getRequestParameters()) {
                if (parameterImpl2 instanceof WrapperParameter) {
                    hashSet.addAll(((WrapperParameter)parameterImpl2).getWrapperChildren());
                    continue;
                }
                hashSet.add(parameterImpl2);
            }
            for (ParameterImpl parameterImpl2 : javaMethodImpl.getResponseParameters()) {
                if (parameterImpl2 instanceof WrapperParameter) {
                    hashSet.addAll(((WrapperParameter)parameterImpl2).getWrapperChildren());
                    continue;
                }
                hashSet.add(parameterImpl2);
            }
        } else {
            hashSet.addAll(javaMethodImpl.getRequestParameters());
            hashSet.addAll(javaMethodImpl.getResponseParameters());
        }
        Iterator<ParameterImpl> iterator = hashSet.iterator();
        if (hashSet.size() == 0) {
            return arrayList;
        }
        parameterImpl2 = iterator.next();
        arrayList.add(parameterImpl2);
        for (int i = 1; i < hashSet.size(); ++i) {
            int n;
            parameterImpl2 = iterator.next();
            for (n = 0; n < i; ++n) {
                ParameterImpl parameterImpl3 = (ParameterImpl)arrayList.get(n);
                if (parameterImpl2.getIndex() == parameterImpl3.getIndex() && parameterImpl2 instanceof WrapperParameter || parameterImpl2.getIndex() < parameterImpl3.getIndex()) break;
            }
            arrayList.add(n, parameterImpl2);
        }
        return arrayList;
    }

    protected boolean isBodyParameter(ParameterImpl parameterImpl) {
        ParameterBinding parameterBinding = parameterImpl.getBinding();
        return parameterBinding.isBody();
    }

    protected boolean isHeaderParameter(ParameterImpl parameterImpl) {
        ParameterBinding parameterBinding = parameterImpl.getBinding();
        return parameterBinding.isHeader();
    }

    protected boolean isAttachmentParameter(ParameterImpl parameterImpl) {
        ParameterBinding parameterBinding = parameterImpl.getBinding();
        return parameterBinding.isAttachment();
    }

    protected void generateBinding() {
        Binding binding = this.serviceDefinitions.binding().name(this.model.getBoundPortTypeName().getLocalPart());
        this.extension.addBindingExtension(binding);
        binding.type(this.model.getPortTypeName());
        boolean bl = true;
        for (JavaMethodImpl javaMethodImpl : this.model.getJavaMethods()) {
            if (bl) {
                TypedXmlWriter typedXmlWriter;
                SOAPBindingImpl sOAPBindingImpl = javaMethodImpl.getBinding();
                SOAPVersion sOAPVersion = sOAPBindingImpl.getSOAPVersion();
                if (sOAPVersion == SOAPVersion.SOAP_12) {
                    typedXmlWriter = binding.soap12Binding();
                    typedXmlWriter.transport(this.binding.getBindingId().getTransport());
                    if (sOAPBindingImpl.getStyle().equals((Object)SOAPBinding.Style.DOCUMENT)) {
                        typedXmlWriter.style(DOCUMENT);
                    } else {
                        typedXmlWriter.style(RPC);
                    }
                } else {
                    typedXmlWriter = binding.soapBinding();
                    typedXmlWriter.transport(this.binding.getBindingId().getTransport());
                    if (sOAPBindingImpl.getStyle().equals((Object)SOAPBinding.Style.DOCUMENT)) {
                        typedXmlWriter.style(DOCUMENT);
                    } else {
                        typedXmlWriter.style(RPC);
                    }
                }
                bl = false;
            }
            if (this.binding.getBindingId().getSOAPVersion() == SOAPVersion.SOAP_12) {
                this.generateSOAP12BindingOperation(javaMethodImpl, binding);
                continue;
            }
            this.generateBindingOperation(javaMethodImpl, binding);
        }
    }

    protected void generateBindingOperation(JavaMethodImpl javaMethodImpl, Binding binding) {
        Object object;
        BindingOperationType bindingOperationType = binding.operation().name(javaMethodImpl.getOperationName());
        this.extension.addBindingOperationExtension(bindingOperationType, javaMethodImpl);
        String string = this.model.getTargetNamespace();
        QName qName = new QName(string, javaMethodImpl.getOperationName());
        ArrayList<ParameterImpl> arrayList = new ArrayList<ParameterImpl>();
        ArrayList<ParameterImpl> arrayList2 = new ArrayList<ParameterImpl>();
        this.splitParameters(arrayList, arrayList2, javaMethodImpl.getRequestParameters());
        SOAPBindingImpl sOAPBindingImpl = javaMethodImpl.getBinding();
        bindingOperationType.soapOperation().soapAction(sOAPBindingImpl.getSOAPAction());
        StartWithExtensionsType startWithExtensionsType = bindingOperationType.input();
        this.extension.addBindingOperationInputExtension(startWithExtensionsType, javaMethodImpl);
        BodyType bodyType = startWithExtensionsType._element(Body.class);
        boolean bl = sOAPBindingImpl.getStyle().equals((Object)SOAPBinding.Style.RPC);
        if (sOAPBindingImpl.getUse() == SOAPBinding.Use.LITERAL) {
            bodyType.use(LITERAL);
            if (arrayList2.size() > 0) {
                if (arrayList.size() > 0) {
                    ParameterImpl parameterImpl = (ParameterImpl)arrayList.iterator().next();
                    if (bl) {
                        StringBuffer object22 = new StringBuffer();
                        int n = 0;
                        object = ((WrapperParameter)parameterImpl).getWrapperChildren().iterator();
                        while (object.hasNext()) {
                            ParameterImpl parameterImpl2 = object.next();
                            if (n++ > 0) {
                                object22.append(' ');
                            }
                            object22.append(parameterImpl2.getPartName());
                        }
                        bodyType.parts(object22.toString());
                    } else if (parameterImpl.isWrapperStyle()) {
                        bodyType.parts("parameters");
                    } else {
                        bodyType.parts(parameterImpl.getPartName());
                    }
                } else {
                    bodyType.parts("");
                }
                this.generateSOAPHeaders(startWithExtensionsType, arrayList2, qName);
            }
            if (bl) {
                bodyType.namespace(javaMethodImpl.getRequestParameters().iterator().next().getName().getNamespaceURI());
            }
        } else {
            throw new WebServiceException("encoded use is not supported");
        }
        if (javaMethodImpl.getMEP() != MEP.ONE_WAY) {
            boolean bl2 = arrayList2.size() == 0;
            arrayList.clear();
            arrayList2.clear();
            this.splitParameters(arrayList, arrayList2, javaMethodImpl.getResponseParameters());
            bl2 = bl2 ? arrayList2.size() == 0 : bl2;
            StartWithExtensionsType startWithExtensionsType2 = bindingOperationType.output();
            this.extension.addBindingOperationOutputExtension(startWithExtensionsType2, javaMethodImpl);
            bodyType = startWithExtensionsType2._element(Body.class);
            bodyType.use(LITERAL);
            if (arrayList2.size() > 0) {
                String string2 = "";
                if (arrayList.size() > 0) {
                    Object object2 = object = arrayList.iterator().hasNext() ? (ParameterImpl)arrayList.iterator().next() : null;
                    if (object != null) {
                        if (bl) {
                            int n = 0;
                            for (ParameterImpl parameterImpl : ((WrapperParameter)object).getWrapperChildren()) {
                                if (n++ > 0) {
                                    string2 = string2 + " ";
                                }
                                string2 = string2 + parameterImpl.getPartName();
                            }
                        } else {
                            string2 = ((ParameterImpl)object).isWrapperStyle() ? (bl2 ? "parameters" : UNWRAPPABLE_RESULT) : ((ParameterImpl)object).getPartName();
                        }
                    }
                }
                bodyType.parts(string2);
                object = new QName(string, javaMethodImpl.getResponseMessageName());
                this.generateSOAPHeaders(startWithExtensionsType2, arrayList2, (QName)object);
            }
            if (bl) {
                bodyType.namespace(javaMethodImpl.getRequestParameters().iterator().next().getName().getNamespaceURI());
            }
        }
        for (CheckedExceptionImpl checkedExceptionImpl : javaMethodImpl.getCheckedExceptions()) {
            Fault fault = bindingOperationType.fault().name(checkedExceptionImpl.getMessageName());
            this.extension.addBindingOperationFaultExtension(fault, javaMethodImpl, checkedExceptionImpl);
            object = fault._element(com.sun.xml.internal.ws.wsdl.writer.document.soap.SOAPFault.class).name(checkedExceptionImpl.getMessageName());
            object.use(LITERAL);
        }
    }

    protected void generateSOAP12BindingOperation(JavaMethodImpl javaMethodImpl, Binding binding) {
        Object object;
        BindingOperationType bindingOperationType = binding.operation().name(javaMethodImpl.getOperationName());
        this.extension.addBindingOperationExtension(bindingOperationType, javaMethodImpl);
        String string = this.model.getTargetNamespace();
        QName qName = new QName(string, javaMethodImpl.getOperationName());
        ArrayList<ParameterImpl> arrayList = new ArrayList<ParameterImpl>();
        ArrayList<ParameterImpl> arrayList2 = new ArrayList<ParameterImpl>();
        this.splitParameters(arrayList, arrayList2, javaMethodImpl.getRequestParameters());
        SOAPBindingImpl sOAPBindingImpl = javaMethodImpl.getBinding();
        bindingOperationType.soap12Operation().soapAction(sOAPBindingImpl.getSOAPAction());
        StartWithExtensionsType startWithExtensionsType = bindingOperationType.input();
        this.extension.addBindingOperationInputExtension(startWithExtensionsType, javaMethodImpl);
        com.sun.xml.internal.ws.wsdl.writer.document.soap12.BodyType bodyType = startWithExtensionsType._element(com.sun.xml.internal.ws.wsdl.writer.document.soap12.Body.class);
        boolean bl = sOAPBindingImpl.getStyle().equals((Object)SOAPBinding.Style.RPC);
        if (sOAPBindingImpl.getUse().equals((Object)SOAPBinding.Use.LITERAL)) {
            bodyType.use(LITERAL);
            if (arrayList2.size() > 0) {
                if (arrayList.size() > 0) {
                    ParameterImpl parameterImpl = (ParameterImpl)arrayList.iterator().next();
                    if (bl) {
                        StringBuffer object22 = new StringBuffer();
                        int n = 0;
                        for (ParameterImpl parameterImpl2 : ((WrapperParameter)parameterImpl).getWrapperChildren()) {
                            if (n++ > 0) {
                                object22.append(' ');
                            }
                            object22.append(parameterImpl2.getPartName());
                        }
                        bodyType.parts(object22.toString());
                    } else if (parameterImpl.isWrapperStyle()) {
                        bodyType.parts("parameters");
                    } else {
                        bodyType.parts(parameterImpl.getPartName());
                    }
                } else {
                    bodyType.parts("");
                }
                this.generateSOAP12Headers(startWithExtensionsType, arrayList2, qName);
            }
            if (bl) {
                bodyType.namespace(javaMethodImpl.getRequestParameters().iterator().next().getName().getNamespaceURI());
            }
        } else {
            throw new WebServiceException("encoded use is not supported");
        }
        if (javaMethodImpl.getMEP() != MEP.ONE_WAY) {
            boolean bl2 = arrayList2.size() == 0;
            arrayList.clear();
            arrayList2.clear();
            this.splitParameters(arrayList, arrayList2, javaMethodImpl.getResponseParameters());
            bl2 = bl2 ? arrayList2.size() == 0 : bl2;
            StartWithExtensionsType startWithExtensionsType2 = bindingOperationType.output();
            this.extension.addBindingOperationOutputExtension(startWithExtensionsType2, javaMethodImpl);
            bodyType = startWithExtensionsType2._element(com.sun.xml.internal.ws.wsdl.writer.document.soap12.Body.class);
            bodyType.use(LITERAL);
            if (arrayList2.size() > 0) {
                if (arrayList.size() > 0) {
                    ParameterImpl parameterImpl = (ParameterImpl)arrayList.iterator().next();
                    if (bl) {
                        object = "";
                        int n = 0;
                        for (ParameterImpl parameterImpl3 : ((WrapperParameter)parameterImpl).getWrapperChildren()) {
                            if (n++ > 0) {
                                object = (String)object + " ";
                            }
                            object = (String)object + parameterImpl3.getPartName();
                        }
                        bodyType.parts((String)object);
                    } else if (parameterImpl.isWrapperStyle()) {
                        if (bl2) {
                            bodyType.parts("parameters");
                        } else {
                            bodyType.parts(UNWRAPPABLE_RESULT);
                        }
                    } else {
                        bodyType.parts(parameterImpl.getPartName());
                    }
                } else {
                    bodyType.parts("");
                }
                QName qName2 = new QName(string, javaMethodImpl.getResponseMessageName());
                this.generateSOAP12Headers(startWithExtensionsType2, arrayList2, qName2);
            }
            if (bl) {
                bodyType.namespace(javaMethodImpl.getRequestParameters().iterator().next().getName().getNamespaceURI());
            }
        }
        for (CheckedExceptionImpl checkedExceptionImpl : javaMethodImpl.getCheckedExceptions()) {
            Fault fault = bindingOperationType.fault().name(checkedExceptionImpl.getMessageName());
            this.extension.addBindingOperationFaultExtension(fault, javaMethodImpl, checkedExceptionImpl);
            object = fault._element(SOAPFault.class).name(checkedExceptionImpl.getMessageName());
            object.use(LITERAL);
        }
    }

    protected void splitParameters(List<ParameterImpl> list, List<ParameterImpl> list2, List<ParameterImpl> list3) {
        for (ParameterImpl parameterImpl : list3) {
            if (this.isBodyParameter(parameterImpl)) {
                list.add(parameterImpl);
                continue;
            }
            list2.add(parameterImpl);
        }
    }

    protected void generateSOAPHeaders(TypedXmlWriter typedXmlWriter, List<ParameterImpl> list, QName qName) {
        for (ParameterImpl parameterImpl : list) {
            com.sun.xml.internal.ws.wsdl.writer.document.soap.Header header = typedXmlWriter._element(com.sun.xml.internal.ws.wsdl.writer.document.soap.Header.class);
            header.message(qName);
            header.part(parameterImpl.getPartName());
            header.use(LITERAL);
        }
    }

    protected void generateSOAP12Headers(TypedXmlWriter typedXmlWriter, List<ParameterImpl> list, QName qName) {
        for (ParameterImpl parameterImpl : list) {
            Header header = typedXmlWriter._element(Header.class);
            header.message(qName);
            header.part(parameterImpl.getPartName());
            header.use(LITERAL);
        }
    }

    protected void generateService() {
        QName qName = this.model.getPortName();
        QName qName2 = this.model.getServiceQName();
        Service service = this.serviceDefinitions.service().name(qName2.getLocalPart());
        this.extension.addServiceExtension(service);
        Port port = service.port().name(qName.getLocalPart());
        port.binding(this.model.getBoundPortTypeName());
        this.extension.addPortExtension(port);
        if (this.model.getJavaMethods().size() == 0) {
            return;
        }
        if (this.binding.getBindingId().getSOAPVersion() == SOAPVersion.SOAP_12) {
            SOAPAddress sOAPAddress = port._element(SOAPAddress.class);
            sOAPAddress.location(this.endpointAddress);
        } else {
            com.sun.xml.internal.ws.wsdl.writer.document.soap.SOAPAddress sOAPAddress = port._element(com.sun.xml.internal.ws.wsdl.writer.document.soap.SOAPAddress.class);
            sOAPAddress.location(this.endpointAddress);
        }
    }

    protected void generateInputMessage(Operation operation, JavaMethodImpl javaMethodImpl) {
        ParamType paramType = operation.input();
        this.extension.addOperationInputExtension(paramType, javaMethodImpl);
        paramType.message(new QName(this.model.getTargetNamespace(), javaMethodImpl.getRequestMessageName()));
    }

    protected void generateOutputMessage(Operation operation, JavaMethodImpl javaMethodImpl) {
        ParamType paramType = operation.output();
        this.extension.addOperationOutputExtension(paramType, javaMethodImpl);
        paramType.message(new QName(this.model.getTargetNamespace(), javaMethodImpl.getResponseMessageName()));
    }

    public Result createOutputFile(String string, String string2) throws IOException {
        if (string.equals("")) {
            return null;
        }
        com.sun.xml.internal.ws.wsdl.writer.document.xsd.Import import_ = this.types.schema()._import().namespace(string);
        Holder<String> holder = new Holder<String>();
        holder.value = this.schemaPrefix + string2;
        Result result = this.wsdlResolver.getSchemaOutput(string, holder);
        String string3 = result == null ? (String)holder.value : WSDLGenerator.relativize(result.getSystemId(), this.wsdlLocation);
        import_.schemaLocation(string3);
        return result;
    }

    protected static String relativize(String string, String string2) {
        try {
            assert (string != null);
            if (string2 == null) {
                return string;
            }
            URI uRI = new URI(Util.escapeURI(string));
            URI uRI2 = new URI(Util.escapeURI(string2));
            if (uRI.isOpaque() || uRI2.isOpaque()) {
                return string;
            }
            if (!Util.equalsIgnoreCase(uRI.getScheme(), uRI2.getScheme()) || !Util.equal(uRI.getAuthority(), uRI2.getAuthority())) {
                return string;
            }
            String string3 = uRI.getPath();
            String string4 = uRI2.getPath();
            if (!string4.endsWith("/")) {
                string4 = Util.normalizeUriPath(string4);
            }
            if (string3.equals(string4)) {
                return ".";
            }
            String string5 = WSDLGenerator.calculateRelativePath(string3, string4);
            if (string5 == null) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string5);
            if (uRI.getQuery() != null) {
                stringBuffer.append('?').append(uRI.getQuery());
            }
            if (uRI.getFragment() != null) {
                stringBuffer.append('#').append(uRI.getFragment());
            }
            return stringBuffer.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError("Error escaping one of these uris:\n\t" + string + "\n\t" + string2);
        }
    }

    private static String calculateRelativePath(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return "../" + WSDLGenerator.calculateRelativePath(string, Util.getParentUriPath(string2));
    }

    private void register(WSDLGeneratorExtension wSDLGeneratorExtension) {
        this.extensionHandlers.add(wSDLGeneratorExtension);
    }

    protected class JAXWSOutputSchemaResolver
    extends SchemaOutputResolver {
        protected JAXWSOutputSchemaResolver() {
        }

        public Result createOutput(String string, String string2) throws IOException {
            return WSDLGenerator.this.createOutputFile(string, string2);
        }
    }

    private static class CommentFilter
    implements XmlSerializer {
        final XmlSerializer serializer;
        private static final String VERSION_COMMENT = " Generated by JAX-WS RI at http://jax-ws.dev.java.net. RI's version is " + RuntimeVersion.VERSION + ". ";

        CommentFilter(XmlSerializer xmlSerializer) {
            this.serializer = xmlSerializer;
        }

        public void startDocument() {
            this.serializer.startDocument();
            this.comment(new StringBuilder(VERSION_COMMENT));
            this.text(new StringBuilder("\n"));
        }

        public void beginStartTag(String string, String string2, String string3) {
            this.serializer.beginStartTag(string, string2, string3);
        }

        public void writeAttribute(String string, String string2, String string3, StringBuilder stringBuilder) {
            this.serializer.writeAttribute(string, string2, string3, stringBuilder);
        }

        public void writeXmlns(String string, String string2) {
            this.serializer.writeXmlns(string, string2);
        }

        public void endStartTag(String string, String string2, String string3) {
            this.serializer.endStartTag(string, string2, string3);
        }

        public void endTag() {
            this.serializer.endTag();
        }

        public void text(StringBuilder stringBuilder) {
            this.serializer.text(stringBuilder);
        }

        public void cdata(StringBuilder stringBuilder) {
            this.serializer.cdata(stringBuilder);
        }

        public void comment(StringBuilder stringBuilder) {
            this.serializer.comment(stringBuilder);
        }

        public void endDocument() {
            this.serializer.endDocument();
        }

        public void flush() {
            this.serializer.flush();
        }
    }
}

