/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.Spring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringLayout
implements LayoutManager2 {
    private Map componentConstraints = new HashMap();
    private Spring cyclicReference = Spring.constant(Integer.MIN_VALUE);
    private Set cyclicSprings;
    private Set acyclicSprings;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String HORIZONTAL_CENTER = "HorizontalCenter";
    public static final String VERTICAL_CENTER = "VerticalCenter";
    public static final String BASELINE = "Baseline";
    public static final String WIDTH = "Width";
    public static final String HEIGHT = "Height";
    private static String[] ALL_HORIZONTAL = new String[]{"West", "Width", "East", "HorizontalCenter"};
    private static String[] ALL_VERTICAL = new String[]{"North", "Height", "South", "VerticalCenter", "Baseline"};

    private void resetCyclicStatuses() {
        this.cyclicSprings = new HashSet();
        this.acyclicSprings = new HashSet();
    }

    private void setParent(Container container) {
        Spring spring;
        this.resetCyclicStatuses();
        Constraints constraints = this.getConstraints(container);
        constraints.setX(Spring.constant(0));
        constraints.setY(Spring.constant(0));
        Spring spring2 = constraints.getWidth();
        if (spring2 instanceof Spring.WidthSpring && ((Spring.WidthSpring)spring2).c == container) {
            constraints.setWidth(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
        if ((spring = constraints.getHeight()) instanceof Spring.HeightSpring && ((Spring.HeightSpring)spring).c == container) {
            constraints.setHeight(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
    }

    boolean isCyclic(Spring spring) {
        if (spring == null) {
            return false;
        }
        if (this.cyclicSprings.contains(spring)) {
            return true;
        }
        if (this.acyclicSprings.contains(spring)) {
            return false;
        }
        this.cyclicSprings.add(spring);
        boolean bl = spring.isCyclic(this);
        if (!bl) {
            this.acyclicSprings.add(spring);
            this.cyclicSprings.remove(spring);
        } else {
            System.err.println(spring + " is cyclic. ");
        }
        return bl;
    }

    private Spring abandonCycles(Spring spring) {
        return this.isCyclic(spring) ? this.cyclicReference : spring;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.componentConstraints.remove(component);
    }

    private static Dimension addInsets(int n, int n2, Container container) {
        Insets insets = container.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.setParent(container);
        Constraints constraints = this.getConstraints(container);
        return SpringLayout.addInsets(this.abandonCycles(constraints.getWidth()).getMinimumValue(), this.abandonCycles(constraints.getHeight()).getMinimumValue(), container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.setParent(container);
        Constraints constraints = this.getConstraints(container);
        return SpringLayout.addInsets(this.abandonCycles(constraints.getWidth()).getPreferredValue(), this.abandonCycles(constraints.getHeight()).getPreferredValue(), container);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        this.setParent(container);
        Constraints constraints = this.getConstraints(container);
        return SpringLayout.addInsets(this.abandonCycles(constraints.getWidth()).getMaximumValue(), this.abandonCycles(constraints.getHeight()).getMaximumValue(), container);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof Constraints) {
            this.putConstraints(component, (Constraints)object);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    public void putConstraint(String string, Component component, int n, String string2, Component component2) {
        this.putConstraint(string, component, Spring.constant(n), string2, component2);
    }

    public void putConstraint(String string, Component component, Spring spring, String string2, Component component2) {
        this.putConstraint(string, component, Spring.sum(spring, this.getConstraint(string2, component2)));
    }

    private void putConstraint(String string, Component component, Spring spring) {
        if (spring != null) {
            this.getConstraints(component).setConstraint(string, spring);
        }
    }

    private Constraints applyDefaults(Component component, Constraints constraints) {
        if (constraints == null) {
            constraints = new Constraints();
        }
        if (constraints.c == null) {
            constraints.c = component;
        }
        if (constraints.horizontalHistory.size() < 2) {
            this.applyDefaults(constraints, WEST, Spring.constant(0), WIDTH, Spring.width(component), constraints.horizontalHistory);
        }
        if (constraints.verticalHistory.size() < 2) {
            this.applyDefaults(constraints, NORTH, Spring.constant(0), HEIGHT, Spring.height(component), constraints.verticalHistory);
        }
        return constraints;
    }

    private void applyDefaults(Constraints constraints, String string, Spring spring, String string2, Spring spring2, List<String> list) {
        if (list.size() == 0) {
            constraints.setConstraint(string, spring);
            constraints.setConstraint(string2, spring2);
        } else {
            if (constraints.getConstraint(string2) == null) {
                constraints.setConstraint(string2, spring2);
            } else {
                constraints.setConstraint(string, spring);
            }
            Collections.rotate(list, 1);
        }
    }

    private void putConstraints(Component component, Constraints constraints) {
        this.componentConstraints.put(component, this.applyDefaults(component, constraints));
    }

    public Constraints getConstraints(Component component) {
        Constraints constraints = (Constraints)this.componentConstraints.get(component);
        if (constraints == null) {
            Object object;
            if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(SpringLayout.class)) instanceof Constraints) {
                return this.applyDefaults(component, (Constraints)object);
            }
            constraints = new Constraints();
            this.putConstraints(component, constraints);
        }
        return constraints;
    }

    public Spring getConstraint(String string, Component component) {
        string = string.intern();
        return new SpringProxy(string, component, this);
    }

    @Override
    public void layoutContainer(Container container) {
        this.setParent(container);
        int n = container.getComponentCount();
        this.getConstraints(container).reset();
        for (int i = 0; i < n; ++i) {
            this.getConstraints(container.getComponent(i)).reset();
        }
        Insets insets = container.getInsets();
        Constraints constraints = this.getConstraints(container);
        this.abandonCycles(constraints.getX()).setValue(0);
        this.abandonCycles(constraints.getY()).setValue(0);
        this.abandonCycles(constraints.getWidth()).setValue(container.getWidth() - insets.left - insets.right);
        this.abandonCycles(constraints.getHeight()).setValue(container.getHeight() - insets.top - insets.bottom);
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            Constraints constraints2 = this.getConstraints(component);
            int n2 = this.abandonCycles(constraints2.getX()).getValue();
            int n3 = this.abandonCycles(constraints2.getY()).getValue();
            int n4 = this.abandonCycles(constraints2.getWidth()).getValue();
            int n5 = this.abandonCycles(constraints2.getHeight()).getValue();
            component.setBounds(insets.left + n2, insets.top + n3, n4, n5);
        }
    }

    private static class SpringProxy
    extends Spring {
        private String edgeName;
        private Component c;
        private SpringLayout l;

        public SpringProxy(String string, Component component, SpringLayout springLayout) {
            this.edgeName = string;
            this.c = component;
            this.l = springLayout;
        }

        private Spring getConstraint() {
            return this.l.getConstraints(this.c).getConstraint(this.edgeName);
        }

        public int getMinimumValue() {
            return this.getConstraint().getMinimumValue();
        }

        public int getPreferredValue() {
            return this.getConstraint().getPreferredValue();
        }

        public int getMaximumValue() {
            return this.getConstraint().getMaximumValue();
        }

        public int getValue() {
            return this.getConstraint().getValue();
        }

        public void setValue(int n) {
            this.getConstraint().setValue(n);
        }

        boolean isCyclic(SpringLayout springLayout) {
            return springLayout.isCyclic(this.getConstraint());
        }

        public String toString() {
            return "SpringProxy for " + this.edgeName + " edge of " + this.c.getName() + ".";
        }
    }

    public static class Constraints {
        private Spring x;
        private Spring y;
        private Spring width;
        private Spring height;
        private Spring east;
        private Spring south;
        private Spring horizontalCenter;
        private Spring verticalCenter;
        private Spring baseline;
        private List<String> horizontalHistory = new ArrayList<String>(2);
        private List<String> verticalHistory = new ArrayList<String>(2);
        private Component c;

        public Constraints() {
        }

        public Constraints(Spring spring, Spring spring2) {
            this.setX(spring);
            this.setY(spring2);
        }

        public Constraints(Spring spring, Spring spring2, Spring spring3, Spring spring4) {
            this.setX(spring);
            this.setY(spring2);
            this.setWidth(spring3);
            this.setHeight(spring4);
        }

        public Constraints(Component component) {
            this.c = component;
            this.setX(Spring.constant(component.getX()));
            this.setY(Spring.constant(component.getY()));
            this.setWidth(Spring.width(component));
            this.setHeight(Spring.height(component));
        }

        private void pushConstraint(String string, Spring spring, boolean bl) {
            List<String> list;
            boolean bl2 = true;
            List<String> list2 = list = bl ? this.horizontalHistory : this.verticalHistory;
            if (list.contains(string)) {
                list.remove(string);
                bl2 = false;
            } else if (list.size() == 2 && spring != null) {
                list.remove(0);
                bl2 = false;
            }
            if (spring != null) {
                list.add(string);
            }
            if (!bl2) {
                String[] stringArray = bl ? ALL_HORIZONTAL : ALL_VERTICAL;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (list.contains(string2)) continue;
                    this.setConstraint(string2, null);
                }
            }
        }

        private Spring sum(Spring spring, Spring spring2) {
            return spring == null || spring2 == null ? null : Spring.sum(spring, spring2);
        }

        private Spring difference(Spring spring, Spring spring2) {
            return spring == null || spring2 == null ? null : Spring.difference(spring, spring2);
        }

        private Spring scale(Spring spring, float f) {
            return spring == null ? null : Spring.scale(spring, f);
        }

        private int getBaselineFromHeight(int n) {
            if (n < 0) {
                return -this.c.getBaseline(this.c.getPreferredSize().width, -n);
            }
            return this.c.getBaseline(this.c.getPreferredSize().width, n);
        }

        private int getHeightFromBaseLine(int n) {
            Dimension dimension = this.c.getPreferredSize();
            int n2 = dimension.height;
            int n3 = this.c.getBaseline(dimension.width, n2);
            if (n3 == n) {
                return n2;
            }
            switch (this.c.getBaselineResizeBehavior()) {
                case CONSTANT_DESCENT: {
                    return n2 + (n - n3);
                }
                case CENTER_OFFSET: {
                    return n2 + 2 * (n - n3);
                }
            }
            return Integer.MIN_VALUE;
        }

        private Spring heightToRelativeBaseline(Spring spring) {
            return new Spring.SpringMap(spring){

                protected int map(int n) {
                    return Constraints.this.getBaselineFromHeight(n);
                }

                protected int inv(int n) {
                    return Constraints.this.getHeightFromBaseLine(n);
                }
            };
        }

        private Spring relativeBaselineToHeight(Spring spring) {
            return new Spring.SpringMap(spring){

                protected int map(int n) {
                    return Constraints.this.getHeightFromBaseLine(n);
                }

                protected int inv(int n) {
                    return Constraints.this.getBaselineFromHeight(n);
                }
            };
        }

        private boolean defined(List list, String string, String string2) {
            return list.contains(string) && list.contains(string2);
        }

        public void setX(Spring spring) {
            this.x = spring;
            this.pushConstraint(SpringLayout.WEST, spring, true);
        }

        public Spring getX() {
            if (this.x == null) {
                if (this.defined(this.horizontalHistory, SpringLayout.EAST, SpringLayout.WIDTH)) {
                    this.x = this.difference(this.east, this.width);
                } else if (this.defined(this.horizontalHistory, SpringLayout.HORIZONTAL_CENTER, SpringLayout.WIDTH)) {
                    this.x = this.difference(this.horizontalCenter, this.scale(this.width, 0.5f));
                } else if (this.defined(this.horizontalHistory, SpringLayout.HORIZONTAL_CENTER, SpringLayout.EAST)) {
                    this.x = this.difference(this.scale(this.horizontalCenter, 2.0f), this.east);
                }
            }
            return this.x;
        }

        public void setY(Spring spring) {
            this.y = spring;
            this.pushConstraint(SpringLayout.NORTH, spring, false);
        }

        public Spring getY() {
            if (this.y == null) {
                if (this.defined(this.verticalHistory, SpringLayout.SOUTH, SpringLayout.HEIGHT)) {
                    this.y = this.difference(this.south, this.height);
                } else if (this.defined(this.verticalHistory, SpringLayout.VERTICAL_CENTER, SpringLayout.HEIGHT)) {
                    this.y = this.difference(this.verticalCenter, this.scale(this.height, 0.5f));
                } else if (this.defined(this.verticalHistory, SpringLayout.VERTICAL_CENTER, SpringLayout.SOUTH)) {
                    this.y = this.difference(this.scale(this.verticalCenter, 2.0f), this.south);
                } else if (this.defined(this.verticalHistory, SpringLayout.BASELINE, SpringLayout.HEIGHT)) {
                    this.y = this.difference(this.baseline, this.heightToRelativeBaseline(this.height));
                } else if (this.defined(this.verticalHistory, SpringLayout.BASELINE, SpringLayout.SOUTH)) {
                    this.y = this.scale(this.difference(this.baseline, this.heightToRelativeBaseline(this.south)), 2.0f);
                }
            }
            return this.y;
        }

        public void setWidth(Spring spring) {
            this.width = spring;
            this.pushConstraint(SpringLayout.WIDTH, spring, true);
        }

        public Spring getWidth() {
            if (this.width == null) {
                if (this.horizontalHistory.contains(SpringLayout.EAST)) {
                    this.width = this.difference(this.east, this.getX());
                } else if (this.horizontalHistory.contains(SpringLayout.HORIZONTAL_CENTER)) {
                    this.width = this.scale(this.difference(this.horizontalCenter, this.getX()), 2.0f);
                }
            }
            return this.width;
        }

        public void setHeight(Spring spring) {
            this.height = spring;
            this.pushConstraint(SpringLayout.HEIGHT, spring, false);
        }

        public Spring getHeight() {
            if (this.height == null) {
                if (this.verticalHistory.contains(SpringLayout.SOUTH)) {
                    this.height = this.difference(this.south, this.getY());
                } else if (this.verticalHistory.contains(SpringLayout.VERTICAL_CENTER)) {
                    this.height = this.scale(this.difference(this.verticalCenter, this.getY()), 2.0f);
                } else if (this.verticalHistory.contains(SpringLayout.BASELINE)) {
                    this.height = this.relativeBaselineToHeight(this.difference(this.baseline, this.getY()));
                }
            }
            return this.height;
        }

        private void setEast(Spring spring) {
            this.east = spring;
            this.pushConstraint(SpringLayout.EAST, spring, true);
        }

        private Spring getEast() {
            if (this.east == null) {
                this.east = this.sum(this.getX(), this.getWidth());
            }
            return this.east;
        }

        private void setSouth(Spring spring) {
            this.south = spring;
            this.pushConstraint(SpringLayout.SOUTH, spring, false);
        }

        private Spring getSouth() {
            if (this.south == null) {
                this.south = this.sum(this.getY(), this.getHeight());
            }
            return this.south;
        }

        private Spring getHorizontalCenter() {
            if (this.horizontalCenter == null) {
                this.horizontalCenter = this.sum(this.getX(), this.scale(this.getWidth(), 0.5f));
            }
            return this.horizontalCenter;
        }

        private void setHorizontalCenter(Spring spring) {
            this.horizontalCenter = spring;
            this.pushConstraint(SpringLayout.HORIZONTAL_CENTER, spring, true);
        }

        private Spring getVerticalCenter() {
            if (this.verticalCenter == null) {
                this.verticalCenter = this.sum(this.getY(), this.scale(this.getHeight(), 0.5f));
            }
            return this.verticalCenter;
        }

        private void setVerticalCenter(Spring spring) {
            this.verticalCenter = spring;
            this.pushConstraint(SpringLayout.VERTICAL_CENTER, spring, false);
        }

        private Spring getBaseline() {
            if (this.baseline == null) {
                this.baseline = this.sum(this.getY(), this.heightToRelativeBaseline(this.getHeight()));
            }
            return this.baseline;
        }

        private void setBaseline(Spring spring) {
            this.baseline = spring;
            this.pushConstraint(SpringLayout.BASELINE, spring, false);
        }

        public void setConstraint(String string, Spring spring) {
            if ((string = string.intern()) == SpringLayout.WEST) {
                this.setX(spring);
            } else if (string == SpringLayout.NORTH) {
                this.setY(spring);
            } else if (string == SpringLayout.EAST) {
                this.setEast(spring);
            } else if (string == SpringLayout.SOUTH) {
                this.setSouth(spring);
            } else if (string == SpringLayout.HORIZONTAL_CENTER) {
                this.setHorizontalCenter(spring);
            } else if (string == SpringLayout.WIDTH) {
                this.setWidth(spring);
            } else if (string == SpringLayout.HEIGHT) {
                this.setHeight(spring);
            } else if (string == SpringLayout.VERTICAL_CENTER) {
                this.setVerticalCenter(spring);
            } else if (string == SpringLayout.BASELINE) {
                this.setBaseline(spring);
            }
        }

        public Spring getConstraint(String string) {
            return (string = string.intern()) == SpringLayout.WEST ? this.getX() : (string == SpringLayout.NORTH ? this.getY() : (string == SpringLayout.EAST ? this.getEast() : (string == SpringLayout.SOUTH ? this.getSouth() : (string == SpringLayout.WIDTH ? this.getWidth() : (string == SpringLayout.HEIGHT ? this.getHeight() : (string == SpringLayout.HORIZONTAL_CENTER ? this.getHorizontalCenter() : (string == SpringLayout.VERTICAL_CENTER ? this.getVerticalCenter() : (string == SpringLayout.BASELINE ? this.getBaseline() : null))))))));
        }

        void reset() {
            Spring[] springArray = new Spring[]{this.x, this.y, this.width, this.height, this.east, this.south, this.horizontalCenter, this.verticalCenter, this.baseline};
            for (int i = 0; i < springArray.length; ++i) {
                Spring spring = springArray[i];
                if (spring == null) continue;
                spring.setValue(Integer.MIN_VALUE);
            }
        }
    }
}

