/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.sun.awt.AWTUtilities;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAccessor;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.ComponentFactory;
import sun.awt.DebugHelper;
import sun.awt.DefaultMouseInfoPeer;
import sun.awt.InputMethodSupport;
import sun.awt.KeyboardFocusManagerPeerImpl;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.PeerEvent;
import sun.awt.PostEventQueue;
import sun.awt.WindowClosingListener;
import sun.awt.WindowClosingSupport;
import sun.awt.im.InputContext;
import sun.awt.im.SimpleInputMethodWindow;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.awt.image.URLImageSource;
import sun.font.FontDesignMetrics;
import sun.misc.SoftCache;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SunToolkit
extends Toolkit
implements WindowClosingSupport,
WindowClosingListener,
ComponentFactory,
InputMethodSupport {
    private static final Logger log = Logger.getLogger("sun.awt.SunToolkit");
    public static final int GRAB_EVENT_MASK = Integer.MIN_VALUE;
    private static Method wakeupMethod;
    private static final String POST_EVENT_QUEUE_KEY = "PostEventQueue";
    private static final ReentrantLock AWT_LOCK;
    private static final Condition AWT_LOCK_COND;
    protected static final Hashtable peerMap;
    private static final Map appContextMap;
    static SoftCache imgCache;
    private static Locale startupLocale;
    private static String dataTransfererClassName;
    private transient WindowClosingListener windowClosingListener;
    private static DefaultMouseInfoPeer mPeer;
    private static Dialog.ModalExclusionType DEFAULT_MODAL_EXCLUSION_TYPE;
    private ModalityListenerList modalityListeners;
    public static final int WAIT_TIME = 10000;
    private static final int MAX_ITERS = 20;
    private static final int MIN_ITERS = 0;
    private static final int MINIMAL_EDELAY = 0;
    private boolean eventDispatched;
    private boolean queueEmpty;
    private final Object waitLock;
    static Method eqNoEvents;
    private static boolean checkedSystemAAFontSettings;
    private static boolean useSystemAAFontSettings;
    private static boolean lastExtraCondition;
    private static RenderingHints desktopFontHints;
    public static final String DESKTOPFONTHINTS = "awt.font.desktophints";
    private static Method consumeNextKeyTypedMethod;
    private static Method setMostRecentFocusOwnerMethod;
    private static Boolean sunAwtDisableMixing;

    public SunToolkit() {
        Object object;
        DebugHelper.init();
        this.windowClosingListener = null;
        this.modalityListeners = new ModalityListenerList();
        this.eventDispatched = false;
        this.queueEmpty = false;
        this.waitLock = "Wait Lock";
        ThreadGroup threadGroup = null;
        String string = System.getProperty("awt.threadgroup", "");
        if (string.length() != 0) {
            try {
                object = Class.forName(string).getConstructor(String.class);
                threadGroup = (ThreadGroup)((Constructor)object).newInstance("AWT-ThreadGroup");
            }
            catch (Exception exception) {
                System.err.println("Failed loading " + string + ": " + exception);
            }
        }
        object = new Runnable(){

            public void run() {
                EventQueue eventQueue;
                String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
                try {
                    eventQueue = (EventQueue)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    System.err.println("Failed loading " + string + ": " + exception);
                    eventQueue = new EventQueue();
                }
                AppContext appContext = AppContext.getAppContext();
                appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
                PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
                appContext.put(SunToolkit.POST_EVENT_QUEUE_KEY, postEventQueue);
            }
        };
        if (threadGroup != null) {
            Thread thread = new Thread(threadGroup, (Runnable)object, "EventQueue-Init");
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            object.run();
        }
    }

    public boolean useBufferPerWindow() {
        return false;
    }

    @Override
    public abstract WindowPeer createWindow(Window var1) throws HeadlessException;

    @Override
    public abstract FramePeer createFrame(Frame var1) throws HeadlessException;

    @Override
    public abstract DialogPeer createDialog(Dialog var1) throws HeadlessException;

    @Override
    public abstract ButtonPeer createButton(Button var1) throws HeadlessException;

    @Override
    public abstract TextFieldPeer createTextField(TextField var1) throws HeadlessException;

    @Override
    public abstract ChoicePeer createChoice(Choice var1) throws HeadlessException;

    @Override
    public abstract LabelPeer createLabel(Label var1) throws HeadlessException;

    @Override
    public abstract ListPeer createList(List var1) throws HeadlessException;

    @Override
    public abstract CheckboxPeer createCheckbox(Checkbox var1) throws HeadlessException;

    @Override
    public abstract ScrollbarPeer createScrollbar(Scrollbar var1) throws HeadlessException;

    @Override
    public abstract ScrollPanePeer createScrollPane(ScrollPane var1) throws HeadlessException;

    @Override
    public abstract TextAreaPeer createTextArea(TextArea var1) throws HeadlessException;

    @Override
    public abstract FileDialogPeer createFileDialog(FileDialog var1) throws HeadlessException;

    @Override
    public abstract MenuBarPeer createMenuBar(MenuBar var1) throws HeadlessException;

    @Override
    public abstract MenuPeer createMenu(Menu var1) throws HeadlessException;

    @Override
    public abstract PopupMenuPeer createPopupMenu(PopupMenu var1) throws HeadlessException;

    @Override
    public abstract MenuItemPeer createMenuItem(MenuItem var1) throws HeadlessException;

    @Override
    public abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1) throws HeadlessException;

    @Override
    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1) throws InvalidDnDOperationException;

    public abstract TrayIconPeer createTrayIcon(TrayIcon var1) throws HeadlessException, AWTException;

    public abstract SystemTrayPeer createSystemTray(SystemTray var1);

    public abstract boolean isTraySupported();

    @Override
    public abstract FontPeer getFontPeer(String var1, int var2);

    @Override
    public abstract RobotPeer createRobot(Robot var1, GraphicsDevice var2) throws AWTException;

    public KeyboardFocusManagerPeer createKeyboardFocusManagerPeer(KeyboardFocusManager keyboardFocusManager) throws HeadlessException {
        KeyboardFocusManagerPeerImpl keyboardFocusManagerPeerImpl = new KeyboardFocusManagerPeerImpl(keyboardFocusManager);
        return keyboardFocusManagerPeerImpl;
    }

    public static final void awtLock() {
        AWT_LOCK.lock();
    }

    public static final boolean awtTryLock() {
        return AWT_LOCK.tryLock();
    }

    public static final void awtUnlock() {
        AWT_LOCK.unlock();
    }

    public static final void awtLockWait() throws InterruptedException {
        AWT_LOCK_COND.await();
    }

    public static final void awtLockWait(long l) throws InterruptedException {
        AWT_LOCK_COND.await(l, TimeUnit.MILLISECONDS);
    }

    public static final void awtLockNotify() {
        AWT_LOCK_COND.signal();
    }

    public static final void awtLockNotifyAll() {
        AWT_LOCK_COND.signalAll();
    }

    public static final boolean isAWTLockHeldByCurrentThread() {
        return AWT_LOCK.isHeldByCurrentThread();
    }

    public static AppContext createNewAppContext() {
        EventQueue eventQueue;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            eventQueue = (EventQueue)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Failed loading " + string + ": " + exception);
            eventQueue = new EventQueue();
        }
        AppContext appContext = new AppContext(threadGroup);
        appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
        appContext.put(POST_EVENT_QUEUE_KEY, postEventQueue);
        return appContext;
    }

    private static Object getPrivateKey(Object object) {
        Object object2 = null;
        if (object instanceof Component) {
            object2 = AWTAccessor.getComponentAccessor().getPrivateKey((Component)object);
        } else if (object instanceof MenuComponent) {
            object2 = AWTAccessor.getMenuComponentAccessor().getPrivateKey((MenuComponent)object);
        } else if (object instanceof TrayIcon) {
            object2 = AWTAccessor.getTrayIconAccessor().getPrivateKey((TrayIcon)object);
        }
        return object2;
    }

    private static Field getField(final Class clazz, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                block5: {
                    try {
                        Field field = clazz.getDeclaredField(string);
                        assert (field != null);
                        field.setAccessible(true);
                        return field;
                    }
                    catch (SecurityException securityException) {
                        assert (false);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
                return null;
            }
        });
    }

    static void wakeupEventQueue(EventQueue eventQueue, boolean bl) {
        block6: {
            if (wakeupMethod == null) {
                wakeupMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        block5: {
                            try {
                                Method method = EventQueue.class.getDeclaredMethod("wakeup", Boolean.TYPE);
                                if (method != null) {
                                    method.setAccessible(true);
                                }
                                return method;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                assert (false);
                            }
                            catch (SecurityException securityException) {
                                if ($assertionsDisabled) break block5;
                                throw new AssertionError();
                            }
                        }
                        return null;
                    }
                });
            }
            try {
                if (wakeupMethod != null) {
                    wakeupMethod.invoke(eventQueue, bl);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    protected static Object targetToPeer(Object object) {
        if (object != null && !GraphicsEnvironment.isHeadless()) {
            return peerMap.get(SunToolkit.getPrivateKey(object));
        }
        return null;
    }

    protected static void targetCreatedPeer(Object object, Object object2) {
        if (object != null && object2 != null && !GraphicsEnvironment.isHeadless()) {
            peerMap.put(SunToolkit.getPrivateKey(object), object2);
        }
    }

    protected static void targetDisposedPeer(Object object, Object object2) {
        Object object3;
        if (object != null && object2 != null && !GraphicsEnvironment.isHeadless() && peerMap.get(object3 = SunToolkit.getPrivateKey(object)) == object2) {
            peerMap.remove(object3);
        }
    }

    private static boolean setAppContext(Object object, AppContext appContext) {
        if (object instanceof Component) {
            AWTAccessor.getComponentAccessor().setAppContext((Component)object, appContext);
        } else if (object instanceof MenuComponent) {
            AWTAccessor.getMenuComponentAccessor().setAppContext((MenuComponent)object, appContext);
        } else {
            return false;
        }
        return true;
    }

    private static AppContext getAppContext(Object object) {
        if (object instanceof Component) {
            return AWTAccessor.getComponentAccessor().getAppContext((Component)object);
        }
        if (object instanceof MenuComponent) {
            return AWTAccessor.getMenuComponentAccessor().getAppContext((MenuComponent)object);
        }
        return null;
    }

    public static AppContext targetToAppContext(Object object) {
        if (object == null || GraphicsEnvironment.isHeadless()) {
            return null;
        }
        AppContext appContext = SunToolkit.getAppContext(object);
        if (appContext == null) {
            appContext = (AppContext)appContextMap.get(object);
        }
        return appContext;
    }

    public static void setLWRequestStatus(Window window, boolean bl) {
        AWTAccessor.getWindowAccessor().setLWRequestStatus(window, bl);
    }

    public static void checkAndSetPolicy(Container container, boolean bl) {
        FocusTraversalPolicy focusTraversalPolicy = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy();
        String string = Toolkit.getDefaultToolkit().getClass().getName();
        if (!"sun.awt.X11.XToolkit".equals(string)) {
            container.setFocusTraversalPolicy(focusTraversalPolicy);
            return;
        }
        String string2 = focusTraversalPolicy.getClass().getName();
        if (DefaultFocusTraversalPolicy.class != focusTraversalPolicy.getClass()) {
            if (string2.startsWith("java.awt.")) {
                if (bl) {
                    focusTraversalPolicy = SunToolkit.createLayoutPolicy();
                }
            } else if (string2.startsWith("javax.swing.") && !bl) {
                focusTraversalPolicy = new DefaultFocusTraversalPolicy();
            }
        } else if (bl) {
            focusTraversalPolicy = SunToolkit.createLayoutPolicy();
        }
        container.setFocusTraversalPolicy(focusTraversalPolicy);
    }

    private static FocusTraversalPolicy createLayoutPolicy() {
        FocusTraversalPolicy focusTraversalPolicy;
        block6: {
            focusTraversalPolicy = null;
            try {
                Class<?> clazz = Class.forName("javax.swing.LayoutFocusTraversalPolicy");
                focusTraversalPolicy = (FocusTraversalPolicy)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                assert (false);
            }
            catch (InstantiationException instantiationException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return focusTraversalPolicy;
    }

    public static void insertTargetMapping(Object object, AppContext appContext) {
        if (!GraphicsEnvironment.isHeadless() && !SunToolkit.setAppContext(object, appContext)) {
            appContextMap.put(object, appContext);
        }
    }

    public static void postEvent(AppContext appContext, AWTEvent aWTEvent) {
        PostEventQueue postEventQueue;
        if (aWTEvent == null) {
            throw new NullPointerException();
        }
        SunToolkit.setSystemGenerated(aWTEvent);
        AppContext appContext2 = SunToolkit.targetToAppContext(aWTEvent.getSource());
        if (appContext2 != null && !appContext2.equals(appContext)) {
            log.fine("Event posted on wrong app context : " + aWTEvent);
        }
        if ((postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY)) != null) {
            postEventQueue.postEvent(aWTEvent);
        }
    }

    public static void postPriorityEvent(final AWTEvent aWTEvent) {
        PeerEvent peerEvent = new PeerEvent(Toolkit.getDefaultToolkit(), new Runnable(){

            public void run() {
                AWTAccessor.getAWTEventAccessor().setPosted(aWTEvent);
                ((Component)aWTEvent.getSource()).dispatchEvent(aWTEvent);
            }
        }, 2L);
        SunToolkit.postEvent(SunToolkit.targetToAppContext(aWTEvent.getSource()), peerEvent);
    }

    public static void flushPendingEvents() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            postEventQueue.flush();
        }
    }

    public static boolean isPostEventQueueEmpty() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            return postEventQueue.noEvents();
        }
        return true;
    }

    public static void executeOnEventHandlerThread(Object object, Runnable runnable) {
        SunToolkit.executeOnEventHandlerThread(new PeerEvent(object, runnable, 1L));
    }

    public static void executeOnEventHandlerThread(Object object, Runnable runnable, final long l) {
        SunToolkit.executeOnEventHandlerThread(new PeerEvent(object, runnable, 1L){

            public long getWhen() {
                return l;
            }
        });
    }

    public static void executeOnEventHandlerThread(PeerEvent peerEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(peerEvent.getSource()), peerEvent);
    }

    public static void invokeLaterOnAppContext(AppContext appContext, Runnable runnable) {
        SunToolkit.postEvent(appContext, new PeerEvent(Toolkit.getDefaultToolkit(), runnable, 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeOnEDTAndWait(Object object, Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call executeOnEDTAndWait from any event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        PeerEvent peerEvent = new PeerEvent(object, runnable, aWTInvocationLock, true, 1L);
        Object object2 = aWTInvocationLock;
        synchronized (object2) {
            SunToolkit.executeOnEventHandlerThread(peerEvent);
            aWTInvocationLock.wait();
        }
        object2 = peerEvent.getThrowable();
        if (object2 != null) {
            throw new InvocationTargetException((Throwable)object2);
        }
    }

    private static EventQueue getNextQueue(Object object) {
        EventQueue eventQueue;
        block2: {
            eventQueue = null;
            try {
                Field field = SunToolkit.getField(EventQueue.class, "nextQueue");
                eventQueue = (EventQueue)field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return eventQueue;
    }

    private static Thread getDispatchThread(Object object) {
        Thread thread;
        block2: {
            thread = null;
            try {
                Field field = SunToolkit.getField(EventQueue.class, "dispatchThread");
                thread = (Thread)field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return thread;
    }

    public static boolean isDispatchThreadForAppContext(Object object) {
        AppContext appContext = SunToolkit.targetToAppContext(object);
        EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        EventQueue eventQueue2 = SunToolkit.getNextQueue(eventQueue);
        while (eventQueue2 != null) {
            eventQueue = eventQueue2;
            eventQueue2 = SunToolkit.getNextQueue(eventQueue);
        }
        return Thread.currentThread() == SunToolkit.getDispatchThread(eventQueue);
    }

    @Override
    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    protected abstract int getScreenWidth();

    protected abstract int getScreenHeight();

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return FontDesignMetrics.getMetrics(font);
    }

    @Override
    public String[] getFontList() {
        String[] stringArray = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};
        return stringArray;
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        return (PanelPeer)((Object)this.createComponent(panel));
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        return (CanvasPeer)((Object)this.createComponent(canvas));
    }

    public void disableBackgroundErase(Canvas canvas) {
        this.disableBackgroundEraseImpl(canvas);
    }

    public void disableBackgroundErase(Component component) {
        this.disableBackgroundEraseImpl(component);
    }

    private void disableBackgroundEraseImpl(Component component) {
        AWTAccessor.getComponentAccessor().setBackgroundEraseDisabled(component, true);
    }

    public static boolean getSunAwtNoerasebackground() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.noerasebackground"));
    }

    public static boolean getSunAwtErasebackgroundonresize() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.erasebackgroundonresize"));
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, URL uRL) {
        Object object;
        block10: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    object = uRL.openConnection().getPermission();
                    if (object == null) break block10;
                    try {
                        securityManager.checkPermission((Permission)object);
                    }
                    catch (SecurityException securityException) {
                        if (object instanceof FilePermission && ((Permission)object).getActions().indexOf("read") != -1) {
                            securityManager.checkRead(((Permission)object).getName());
                            break block10;
                        }
                        if (object instanceof SocketPermission && ((Permission)object).getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block10;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        if ((object = (Image)imgCache.get(uRL)) == null) {
            try {
                object = toolkit.createImage(new URLImageSource(uRL));
                imgCache.put(uRL, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, String string) {
        Image image;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if ((image = (Image)imgCache.get(string)) == null) {
            try {
                image = toolkit.createImage(new FileImageSource(string));
                imgCache.put(string, image);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return image;
    }

    @Override
    public Image getImage(String string) {
        return SunToolkit.getImageFromHash((Toolkit)this, string);
    }

    @Override
    public Image getImage(URL uRL) {
        return SunToolkit.getImageFromHash((Toolkit)this, uRL);
    }

    @Override
    public Image createImage(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return this.createImage(new FileImageSource(string));
    }

    @Override
    public Image createImage(URL uRL) {
        block7: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    Permission permission = uRL.openConnection().getPermission();
                    if (permission == null) break block7;
                    try {
                        securityManager.checkPermission(permission);
                    }
                    catch (SecurityException securityException) {
                        if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                            securityManager.checkRead(permission.getName());
                            break block7;
                        }
                        if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block7;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        return this.createImage(new URLImageSource(uRL));
    }

    @Override
    public Image createImage(byte[] byArray, int n, int n2) {
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    @Override
    public Image createImage(ImageProducer imageProducer) {
        return new ToolkitImage(imageProducer);
    }

    @Override
    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (!(image instanceof ToolkitImage)) {
            return 32;
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        int n3 = n == 0 || n2 == 0 ? 32 : toolkitImage.getImageRep().check(imageObserver);
        return toolkitImage.check(imageObserver) | n3;
    }

    @Override
    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        if (!(image instanceof ToolkitImage)) {
            return true;
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (toolkitImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getScaledIconImage(java.util.List<Image> list, int n, int n2) {
        int n3;
        if (n == 0 || n2 == 0) {
            return null;
        }
        Image object2 = null;
        int n4 = 0;
        int n5 = 0;
        double d = 3.0;
        double d2 = 0.0;
        for (Image object3 : list) {
            double d3;
            int n9;
            if (object3 == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("SunToolkit.getScaledIconImage: Skipping the image passed into Java because it's null.");
                continue;
            }
            if (object3 instanceof ToolkitImage) {
                ImageRepresentation n6 = ((ToolkitImage)object3).getImageRep();
                n6.reconstruct(32);
            }
            try {
                n9 = object3.getWidth(null);
                n3 = object3.getHeight(null);
            }
            catch (Exception d4) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("SunToolkit.getScaledIconImage: Perhaps the image passed into Java is broken. Skipping this icon.");
                continue;
            }
            if (n9 <= 0 || n3 <= 0) continue;
            double d4 = Math.min((double)n / (double)n9, (double)n2 / (double)n3);
            int n6 = 0;
            int n7 = 0;
            double d5 = 1.0;
            if (d4 >= 2.0) {
                d4 = Math.floor(d4);
                n6 = n9 * (int)d4;
                n7 = n3 * (int)d4;
                d5 = 1.0 - 0.5 / d4;
            } else if (d4 >= 1.0) {
                d4 = 1.0;
                n6 = n9;
                n7 = n3;
                d5 = 0.0;
            } else if (d4 >= 0.75) {
                d4 = 0.75;
                n6 = n9 * 3 / 4;
                n7 = n3 * 3 / 4;
                d5 = 0.3;
            } else if (d4 >= 0.6666) {
                d4 = 0.6666;
                n6 = n9 * 2 / 3;
                n7 = n3 * 2 / 3;
                d5 = 0.33;
            } else {
                d3 = Math.ceil(1.0 / d4);
                d4 = 1.0 / d3;
                n6 = (int)Math.round((double)n9 / d3);
                n7 = (int)Math.round((double)n3 / d3);
                d5 = 1.0 - 1.0 / d3;
            }
            d3 = ((double)n - (double)n6) / (double)n + ((double)n2 - (double)n7) / (double)n2 + d5;
            if (d3 < d) {
                d = d3;
                d2 = d4;
                object2 = object3;
                n4 = n6;
                n5 = n7;
            }
            if (d3 != 0.0) continue;
            break;
        }
        if (object2 == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            int n8 = (n - n4) / 2;
            n3 = (n2 - n5) / 2;
            if (log.isLoggable(Level.FINER)) {
                log.finer("WWindowPeer.getScaledIconData() result : w : " + n + " h : " + n2 + " iW : " + object2.getWidth(null) + " iH : " + object2.getHeight(null) + " sim : " + d + " sf : " + d2 + " adjW : " + n4 + " adjH : " + n5 + " x : " + n8 + " y : " + n3);
            }
            graphics2D.drawImage(object2, n8, n3, n4, n5, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static DataBufferInt getScaledIconData(java.util.List<Image> list, int n, int n2) {
        BufferedImage bufferedImage = SunToolkit.getScaledIconImage(list, n, n2);
        if (bufferedImage == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("SunToolkit.getScaledIconData: Perhaps the image passed into Java is broken. Skipping this icon.");
            }
            return null;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        return (DataBufferInt)dataBuffer;
    }

    @Override
    protected EventQueue getSystemEventQueueImpl() {
        return SunToolkit.getSystemEventQueueImplPP();
    }

    static EventQueue getSystemEventQueueImplPP() {
        return SunToolkit.getSystemEventQueueImplPP(AppContext.getAppContext());
    }

    public static EventQueue getSystemEventQueueImplPP(AppContext appContext) {
        EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        return eventQueue;
    }

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    @Override
    public Window createInputMethodWindow(String string, InputContext inputContext) {
        return new SimpleInputMethodWindow(string, inputContext);
    }

    @Override
    public boolean enableInputMethodsForTextComponent() {
        return false;
    }

    public static Locale getStartupLocale() {
        if (startupLocale == null) {
            String string;
            String string2;
            String string3 = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
            String string4 = AccessController.doPrivileged(new GetPropertyAction("user.region"));
            if (string4 != null) {
                int n = string4.indexOf(95);
                if (n >= 0) {
                    string2 = string4.substring(0, n);
                    string = string4.substring(n + 1);
                } else {
                    string2 = string4;
                    string = "";
                }
            } else {
                string2 = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
                string = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
            }
            startupLocale = new Locale(string3, string2, string);
        }
        return startupLocale;
    }

    @Override
    public Locale getDefaultKeyboardLocale() {
        return SunToolkit.getStartupLocale();
    }

    protected static void setDataTransfererClassName(String string) {
        dataTransfererClassName = string;
    }

    public static String getDataTransfererClassName() {
        if (dataTransfererClassName == null) {
            Toolkit.getDefaultToolkit();
        }
        return dataTransfererClassName;
    }

    @Override
    public WindowClosingListener getWindowClosingListener() {
        return this.windowClosingListener;
    }

    @Override
    public void setWindowClosingListener(WindowClosingListener windowClosingListener) {
        this.windowClosingListener = windowClosingListener;
    }

    @Override
    public RuntimeException windowClosingNotify(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingNotify(windowEvent);
        }
        return null;
    }

    @Override
    public RuntimeException windowClosingDelivered(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingDelivered(windowEvent);
        }
        return null;
    }

    @Override
    protected synchronized MouseInfoPeer getMouseInfoPeer() {
        if (mPeer == null) {
            mPeer = new DefaultMouseInfoPeer();
        }
        return mPeer;
    }

    public static boolean needsXEmbed() {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.awt.noxembed", "false"));
        if ("true".equals(string)) {
            return false;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            return ((SunToolkit)toolkit).needsXEmbedImpl();
        }
        return false;
    }

    protected boolean needsXEmbedImpl() {
        return false;
    }

    protected final boolean isXEmbedServerRequested() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.xembedserver"));
    }

    public static boolean isModalExcludedSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.isModalExclusionTypeSupported(DEFAULT_MODAL_EXCLUSION_TYPE);
    }

    protected boolean isModalExcludedSupportedImpl() {
        return false;
    }

    public static void setModalExcluded(Window window) {
        if (DEFAULT_MODAL_EXCLUSION_TYPE == null) {
            DEFAULT_MODAL_EXCLUSION_TYPE = Dialog.ModalExclusionType.APPLICATION_EXCLUDE;
        }
        window.setModalExclusionType(DEFAULT_MODAL_EXCLUSION_TYPE);
    }

    public static boolean isModalExcluded(Window window) {
        if (DEFAULT_MODAL_EXCLUSION_TYPE == null) {
            DEFAULT_MODAL_EXCLUSION_TYPE = Dialog.ModalExclusionType.APPLICATION_EXCLUDE;
        }
        return window.getModalExclusionType().compareTo(DEFAULT_MODAL_EXCLUSION_TYPE) >= 0;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.APPLICATION_MODAL;
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType modalExclusionType) {
        return modalExclusionType == Dialog.ModalExclusionType.NO_EXCLUDE;
    }

    public void addModalityListener(ModalityListener modalityListener) {
        this.modalityListeners.add(modalityListener);
    }

    public void removeModalityListener(ModalityListener modalityListener) {
        this.modalityListeners.remove(modalityListener);
    }

    public void notifyModalityPushed(Dialog dialog) {
        this.notifyModalityChange(1300, dialog);
    }

    public void notifyModalityPopped(Dialog dialog) {
        this.notifyModalityChange(1301, dialog);
    }

    final void notifyModalityChange(int n, Dialog dialog) {
        ModalityEvent modalityEvent = new ModalityEvent(dialog, this.modalityListeners, n);
        modalityEvent.dispatch();
    }

    public static boolean isLightweightOrUnknown(Component component) {
        if (component.isLightweight() || !(SunToolkit.getDefaultToolkit() instanceof SunToolkit)) {
            return true;
        }
        return !(component instanceof Button) && !(component instanceof Canvas) && !(component instanceof Checkbox) && !(component instanceof Choice) && !(component instanceof Label) && !(component instanceof List) && !(component instanceof Panel) && !(component instanceof Scrollbar) && !(component instanceof ScrollPane) && !(component instanceof TextArea) && !(component instanceof TextField) && !(component instanceof Window);
    }

    static Method getMethod(final Class clazz, final String string, final Class[] classArray) {
        Method method = null;
        try {
            method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Method method = clazz.getDeclaredMethod(string, classArray);
                    method.setAccessible(true);
                    return method;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        return method;
    }

    public void realSync() throws OperationTimedOut, InfiniteLoop {
        int n = 0;
        do {
            int n2;
            this.sync();
            for (n2 = 0; n2 < 0; ++n2) {
                this.syncNativeQueue();
            }
            while (this.syncNativeQueue() && n2 < 20) {
                ++n2;
            }
            if (n2 >= 20) {
                throw new InfiniteLoop();
            }
            for (n2 = 0; n2 < 0; ++n2) {
                this.waitForIdle();
            }
            while (this.waitForIdle() && n2 < 20) {
                ++n2;
            }
            if (n2 < 20) continue;
            throw new InfiniteLoop();
        } while ((this.syncNativeQueue() || this.waitForIdle()) && ++n < 20);
    }

    protected abstract boolean syncNativeQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEQEmpty() {
        EventQueue eventQueue = this.getSystemEventQueueImpl();
        Class<SunToolkit> clazz = SunToolkit.class;
        synchronized (SunToolkit.class) {
            if (eqNoEvents == null) {
                eqNoEvents = SunToolkit.getMethod(EventQueue.class, "noEvents", null);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                return (Boolean)eqNoEvents.invoke(eventQueue, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForIdle() {
        SunToolkit.flushPendingEvents();
        boolean bl = this.isEQEmpty();
        this.queueEmpty = false;
        this.eventDispatched = false;
        Object object = this.waitLock;
        synchronized (object) {
            SunToolkit.postEvent(AppContext.getAppContext(), new PeerEvent(this.getSystemEventQueueImpl(), null, 4L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dispatch() {
                    int n;
                    for (n = 0; n < 0; ++n) {
                        SunToolkit.this.syncNativeQueue();
                    }
                    while (SunToolkit.this.syncNativeQueue() && n < 20) {
                        ++n;
                    }
                    SunToolkit.flushPendingEvents();
                    Object object = SunToolkit.this.waitLock;
                    synchronized (object) {
                        SunToolkit.this.queueEmpty = SunToolkit.this.isEQEmpty();
                        SunToolkit.this.eventDispatched = true;
                        SunToolkit.this.waitLock.notifyAll();
                    }
                }
            });
            try {
                while (!this.eventDispatched) {
                    this.waitLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted");
        }
        SunToolkit.flushPendingEvents();
        object = this.waitLock;
        synchronized (object) {
            return !this.queueEmpty || !this.isEQEmpty() || !bl;
        }
    }

    public abstract void grab(Window var1);

    public abstract void ungrab(Window var1);

    public static native void closeSplashScreen();

    private void fireDesktopFontPropertyChanges() {
        this.setDesktopProperty(DESKTOPFONTHINTS, SunToolkit.getDesktopFontHints());
    }

    public static void setAAFontSettingsCondition(boolean bl) {
        if (bl != lastExtraCondition) {
            lastExtraCondition = bl;
            if (checkedSystemAAFontSettings) {
                checkedSystemAAFontSettings = false;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit instanceof SunToolkit) {
                    ((SunToolkit)toolkit).fireDesktopFontPropertyChanges();
                }
            }
        }
    }

    private static RenderingHints getDesktopAAHintsByName(String string) {
        Object object = null;
        if ((string = string.toLowerCase(Locale.ENGLISH)).equals("on")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        } else if (string.equals("gasp")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
        } else if (string.equals("lcd") || string.equals("lcd_hrgb")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
        } else if (string.equals("lcd_hbgr")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
        } else if (string.equals("lcd_vrgb")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB;
        } else if (string.equals("lcd_vbgr")) {
            object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
        }
        if (object != null) {
            RenderingHints renderingHints = new RenderingHints(null);
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return renderingHints;
        }
        return null;
    }

    private static boolean useSystemAAFontSettings() {
        if (!checkedSystemAAFontSettings) {
            useSystemAAFontSettings = true;
            String string = null;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof SunToolkit) {
                string = AccessController.doPrivileged(new GetPropertyAction("awt.useSystemAAFontSettings"));
            }
            if (string != null && !(useSystemAAFontSettings = Boolean.valueOf(string).booleanValue())) {
                desktopFontHints = SunToolkit.getDesktopAAHintsByName(string);
            }
            if (useSystemAAFontSettings) {
                useSystemAAFontSettings = lastExtraCondition;
            }
            checkedSystemAAFontSettings = true;
        }
        return useSystemAAFontSettings;
    }

    protected RenderingHints getDesktopAAHints() {
        return null;
    }

    public static RenderingHints getDesktopFontHints() {
        if (SunToolkit.useSystemAAFontSettings()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof SunToolkit) {
                RenderingHints renderingHints = ((SunToolkit)toolkit).getDesktopAAHints();
                return renderingHints;
            }
            return null;
        }
        if (desktopFontHints != null) {
            return (RenderingHints)desktopFontHints.clone();
        }
        return null;
    }

    public abstract boolean isDesktopSupported();

    public static synchronized void consumeNextKeyTyped(KeyEvent keyEvent) {
        if (consumeNextKeyTypedMethod == null) {
            consumeNextKeyTypedMethod = SunToolkit.getMethod(DefaultKeyboardFocusManager.class, "consumeNextKeyTyped", new Class[]{KeyEvent.class});
        }
        try {
            consumeNextKeyTypedMethod.invoke(KeyboardFocusManager.getCurrentKeyboardFocusManager(), keyEvent);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMostRecentFocusOwner(Window window, Component component) {
        Class<SunToolkit> clazz = SunToolkit.class;
        synchronized (SunToolkit.class) {
            if (setMostRecentFocusOwnerMethod == null) {
                setMostRecentFocusOwnerMethod = SunToolkit.getMethod(KeyboardFocusManager.class, "setMostRecentFocusOwner", new Class[]{Window.class, Component.class});
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                setMostRecentFocusOwnerMethod.invoke(null, window, component);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                return;
            }
            return;
        }
    }

    public abstract boolean isWindowOpacityControlSupported();

    public abstract boolean isWindowShapingSupported();

    public abstract boolean isWindowTranslucencySupported();

    public boolean isTranslucencyCapable(GraphicsConfiguration graphicsConfiguration) {
        return false;
    }

    public static boolean getSunAwtUntrustedTopLevelTranslucency() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.untrustedTopLevelTranslucency"));
    }

    public static Window getContainingWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public static synchronized boolean getSunAwtDisableMixing() {
        if (sunAwtDisableMixing == null) {
            sunAwtDisableMixing = (boolean)AccessController.doPrivileged(new GetBooleanAction("sun.awt.disableMixing"));
        }
        return sunAwtDisableMixing;
    }

    public static boolean isContainingTopLevelOpaque(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return component != null && AWTUtilities.isWindowOpaque((Window)component);
    }

    public static boolean isContainingTopLevelTranslucent(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return component != null && AWTUtilities.getWindowOpacity((Window)component) < 1.0f;
    }

    public boolean needUpdateWindow() {
        return false;
    }

    public static void setSystemGenerated(AWTEvent aWTEvent) {
        AWTAccessor.getAWTEventAccessor().setSystemGenerated(aWTEvent);
    }

    public static boolean isSystemGenerated(AWTEvent aWTEvent) {
        return AWTAccessor.getAWTEventAccessor().isSystemGenerated(aWTEvent);
    }

    public static boolean isInstanceOf(Object object, String string) {
        if (object == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        return SunToolkit.isInstanceOf(object.getClass(), string);
    }

    private static boolean isInstanceOf(Class clazz, String string) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals(string)) {
            return true;
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (!clazz2.getName().equals(string)) continue;
            return true;
        }
        return SunToolkit.isInstanceOf(clazz.getSuperclass(), string);
    }

    static {
        AWT_LOCK = new ReentrantLock();
        AWT_LOCK_COND = AWT_LOCK.newCondition();
        peerMap = AWTAutoShutdown.getInstance().getPeerMap();
        appContextMap = Collections.synchronizedMap(new WeakHashMap());
        imgCache = new SoftCache();
        startupLocale = null;
        dataTransfererClassName = null;
        mPeer = null;
        DEFAULT_MODAL_EXCLUSION_TYPE = null;
        lastExtraCondition = true;
        consumeNextKeyTypedMethod = null;
        sunAwtDisableMixing = null;
    }

    public static class InfiniteLoop
    extends RuntimeException {
    }

    public static class OperationTimedOut
    extends RuntimeException {
        public OperationTimedOut(String string) {
            super(string);
        }

        public OperationTimedOut() {
        }
    }

    static class ModalityListenerList
    implements ModalityListener {
        Vector<ModalityListener> listeners = new Vector();

        ModalityListenerList() {
        }

        void add(ModalityListener modalityListener) {
            this.listeners.addElement(modalityListener);
        }

        void remove(ModalityListener modalityListener) {
            this.listeners.removeElement(modalityListener);
        }

        public void modalityPushed(ModalityEvent modalityEvent) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((ModalityListener)iterator.next()).modalityPushed(modalityEvent);
            }
        }

        public void modalityPopped(ModalityEvent modalityEvent) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((ModalityListener)iterator.next()).modalityPopped(modalityEvent);
            }
        }
    }
}

