/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;

class UTF_8
extends Unicode {
    public UTF_8() {
        super("UTF-8", StandardCharsets.aliases_UTF_8);
    }

    public String historicalName() {
        return "UTF8";
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static final void updatePositions(Buffer buffer, int n, Buffer buffer2, int n2) {
        buffer.position(n - buffer.arrayOffset());
        buffer2.position(n2 - buffer2.arrayOffset());
    }

    private static class Encoder
    extends CharsetEncoder {
        private Surrogate.Parser sgp;

        private Encoder(Charset charset) {
            super(charset, 1.1f, 4.0f);
        }

        public boolean canEncode(char c) {
            return !Surrogate.is(c);
        }

        public boolean isLegalReplacement(byte[] byArray) {
            return byArray.length == 1 && byArray[0] >= 0 || super.isLegalReplacement(byArray);
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n, ByteBuffer byteBuffer, int n2) {
            UTF_8.updatePositions(charBuffer, n, byteBuffer, n2);
            return CoderResult.OVERFLOW;
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n) {
            charBuffer.position(n);
            return CoderResult.OVERFLOW;
        }

        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            int n5 = n3 + Math.min(n2 - n, n4 - n3);
            while (n3 < n5 && cArray[n] < '\u0080') {
                byArray[n3++] = (byte)cArray[n++];
            }
            while (n < n2) {
                char c = cArray[n];
                if (c < '\u0080') {
                    if (n3 >= n4) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)c;
                } else if (c < '\u0800') {
                    if (n4 - n3 < 2) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xC0 | c >> 6);
                    byArray[n3++] = (byte)(0x80 | c & 0x3F);
                } else if (Surrogate.is(c)) {
                    int n6;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n6 = this.sgp.parse(c, cArray, n, n2)) < 0) {
                        UTF_8.updatePositions(charBuffer, n, byteBuffer, n3);
                        return this.sgp.error();
                    }
                    if (n4 - n3 < 4) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xF0 | n6 >> 18);
                    byArray[n3++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n6 & 0x3F);
                    ++n;
                } else {
                    if (n4 - n3 < 3) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xE0 | c >> 12);
                    byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | c & 0x3F);
                }
                ++n;
            }
            UTF_8.updatePositions(charBuffer, n, byteBuffer, n3);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c < '\u0080') {
                    if (!byteBuffer.hasRemaining()) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)c);
                } else if (c < '\u0800') {
                    if (byteBuffer.remaining() < 2) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xC0 | c >> 6));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                } else if (Surrogate.is(c)) {
                    int n2;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n2 = this.sgp.parse(c, charBuffer)) < 0) {
                        charBuffer.position(n);
                        return this.sgp.error();
                    }
                    if (byteBuffer.remaining() < 4) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xF0 | n2 >> 18));
                    byteBuffer.put((byte)(0x80 | n2 >> 12 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n2 >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n2 & 0x3F));
                    ++n;
                } else {
                    if (byteBuffer.remaining() < 3) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xE0 | c >> 12));
                    byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                }
                ++n;
            }
            charBuffer.position(n);
            return CoderResult.UNDERFLOW;
        }

        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        private static boolean isNotContinuation(int n) {
            return (n & 0xC0) != 128;
        }

        private static final boolean isMalformed2(int n, int n2) {
            return (n & 0x1E) == 0 || (n2 & 0xC0) != 128;
        }

        private static boolean isMalformed3(int n, int n2, int n3) {
            return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
        }

        private static final boolean isMalformed4(int n, int n2, int n3) {
            return (n & 0xC0) != 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
        }

        private static CoderResult lookupN(ByteBuffer byteBuffer, int n) {
            for (int i = 1; i < n; ++i) {
                if (!Decoder.isNotContinuation(byteBuffer.get())) continue;
                return CoderResult.malformedForLength(i);
            }
            return CoderResult.malformedForLength(n);
        }

        private static CoderResult malformedN(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 1: {
                    byte by = byteBuffer.get();
                    if (by >> 2 == -2) {
                        if (byteBuffer.remaining() < 4) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(byteBuffer, 5);
                    }
                    if (by >> 1 == -2) {
                        if (byteBuffer.remaining() < 5) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(byteBuffer, 6);
                    }
                    return CoderResult.malformedForLength(1);
                }
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte by = byteBuffer.get();
                    byte by2 = byteBuffer.get();
                    return CoderResult.malformedForLength(by == -32 && (by2 & 0xE0) == 128 || Decoder.isNotContinuation(by2) ? 1 : 2);
                }
                case 4: {
                    int n2 = byteBuffer.get() & 0xFF;
                    int n3 = byteBuffer.get() & 0xFF;
                    if (n2 > 244 || n2 == 240 && (n3 < 144 || n3 > 191) || n2 == 244 && (n3 & 0xF0) != 128 || Decoder.isNotContinuation(n3)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(byteBuffer.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            assert (false);
            return null;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n, CharBuffer charBuffer, int n2, int n3) {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n3);
            UTF_8.updatePositions(byteBuffer, n, charBuffer, n2);
            return coderResult;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n, int n2) {
            byteBuffer.position(n);
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n2);
            byteBuffer.position(n);
            return coderResult;
        }

        private static CoderResult xflow(Buffer buffer, int n, int n2, Buffer buffer2, int n3, int n4) {
            UTF_8.updatePositions(buffer, n, buffer2, n3);
            return n4 == 0 || n2 - n < n4 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult xflow(Buffer buffer, int n, int n2) {
            CoderResult coderResult = n2 == 0 || buffer.remaining() < n2 - 1 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
            buffer.position(n);
            return coderResult;
        }

        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            int n5 = n3 + Math.min(n2 - n, n4 - n3);
            while (n3 < n5 && byArray[n] >= 0) {
                cArray[n3++] = (char)byArray[n++];
            }
            while (n < n2) {
                byte by;
                byte by2;
                byte by3 = byArray[n];
                if (by3 >= 0) {
                    if (n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 1);
                    }
                    cArray[n3++] = (char)by3;
                    ++n;
                    continue;
                }
                if (by3 >> 5 == -2) {
                    if (n2 - n < 2 || n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 2);
                    }
                    by2 = byArray[n + 1];
                    if (Decoder.isMalformed2(by3, by2)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 2);
                    }
                    cArray[n3++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                    n += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    if (n2 - n < 3 || n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 3);
                    }
                    by2 = byArray[n + 1];
                    by = byArray[n + 2];
                    if (Decoder.isMalformed3(by3, by2, by)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 3);
                    }
                    cArray[n3++] = (char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80);
                    n += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    if (n2 - n < 4 || n4 - n3 < 2) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 4);
                    }
                    by2 = byArray[n + 1];
                    by = byArray[n + 2];
                    byte by4 = byArray[n + 3];
                    int n6 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                    if (Decoder.isMalformed4(by2, by, by4) || !Surrogate.neededFor(n6)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 4);
                    }
                    cArray[n3++] = Surrogate.high(n6);
                    cArray[n3++] = Surrogate.low(n6);
                    n += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n, charBuffer, n3, 1);
            }
            return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = byteBuffer.limit();
            while (n < n2) {
                byte by;
                byte by2;
                byte by3 = byteBuffer.get();
                if (by3 >= 0) {
                    if (charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 1);
                    }
                    charBuffer.put((char)by3);
                    ++n;
                    continue;
                }
                if (by3 >> 5 == -2) {
                    if (n2 - n < 2 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 2);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed2(by3, by2)) {
                        return Decoder.malformed(byteBuffer, n, 2);
                    }
                    charBuffer.put((char)(by3 << 6 ^ by2 ^ 0xF80));
                    n += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    if (n2 - n < 3 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 3);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed3(by3, by2, by = byteBuffer.get())) {
                        return Decoder.malformed(byteBuffer, n, 3);
                    }
                    charBuffer.put((char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80));
                    n += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    if (n2 - n < 4 || charBuffer.remaining() < 2) {
                        return Decoder.xflow(byteBuffer, n, 4);
                    }
                    by2 = byteBuffer.get();
                    by = byteBuffer.get();
                    byte by4 = byteBuffer.get();
                    int n3 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                    if (Decoder.isMalformed4(by2, by, by4) || !Surrogate.neededFor(n3)) {
                        return Decoder.malformed(byteBuffer, n, 4);
                    }
                    charBuffer.put(Surrogate.high(n3));
                    charBuffer.put(Surrogate.low(n3));
                    n += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n, 1);
            }
            return Decoder.xflow(byteBuffer, n, 0);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }
}

