//
//  NSBundle+Sandvox.h
//  Sandvox
//
//  Created by Mike on 25/11/2010.
//  Copyright 2010-2012 Karelia Software. All rights reserved.
//
//  THIS SOFTWARE IS PROVIDED BY KARELIA SOFTWARE AND ITS CONTRIBUTORS "AS-IS"
//  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
//  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
//  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
//  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//  ARISING IN ANY WAY OUR OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//  POSSIBILITY OF SUCH DAMAGE.
//

//  Utilities for localization. Further information can be found at 
//  http://www.karelia.com/sandvox/help/z/Sandvox_Developers_Guide.html


#import <Cocoa/Cocoa.h>


@interface NSBundle (Sandvox)

- (NSString *)localizedStringForString:(NSString *)aString
                              language:(NSString *)aLocalization
                              fallback:(NSString *)aFallbackString;

- (NSURL *)svURLForImageResource:(NSString *)name language:(NSString *)preferredLanguage AVAILABLE_SANDVOX_VERSION_2_7_AND_LATER __attribute__((nonnull(1)));
- (NSString *)pathForImageResource:(NSString *)name language:(NSString *)preferredLanguage DEPRECATED_IN_SANDVOX_VERSION_2_7_AND_LATER("Use -svURLForImageResource:language: instead") __attribute__((nonnull(1)));

@end
