//
//  SVIndexPlugIn.h
//  Sandvox
//
//  Created by Mike on 10/08/2010.
//  Copyright 2010-2012 Karelia Software. All rights reserved.
//
//  THIS SOFTWARE IS PROVIDED BY KARELIA SOFTWARE AND ITS CONTRIBUTORS "AS-IS"
//  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
//  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
//  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
//  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//  ARISING IN ANY WAY OUR OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//  POSSIBILITY OF SUCH DAMAGE.
//


//  +makeInspectorViewController will return a SVIndexInspectorViewController if no better class is provided by the plug-in. Further information can be found at 
//  http://www.karelia.com/sandvox/help/z/Sandvox_Developers_Guide.html




#import "SVPlugIn.h"


@interface SVIndexPlugIn : SVPlugIn
{
  @private
#ifndef __clang_analyzer__
    id                  _reserved3;
    id                  _reserved4;
#endif
    NSUInteger          _maxItems;
    BOOL                _enableMaxItems;
}

#pragma mark HTML

// THIS IS THE REAL MEAT OF AN INDEX PLUG-IN
// Returns an array of SVPage objects
// 
// OK, maybe I should ease off the capslock. As a general rule, your plug-in should loop through
// each page in this array, and generate HTML from them. e.g. write out the title, mod date,
// or summary. Perhaps even ask the context to generate a thumbnail
//
// By using this method, the system can calculate for you which pages to show. i.e. it'll filter
// out any the user has requested ([SVPage shouldIncludeInIndexes]). And cut off the array at
// -maxItems if appropriate
//
- (NSArray *)indexedPages;


#pragma mark Properties
/*  The properties most indexes display in their inspector */
@property(nonatomic, retain, readonly) NSObject <SVPage> *indexedCollection;
@property(nonatomic) BOOL enableMaxItems;
@property(nonatomic) NSUInteger maxItems;


#pragma mark Metrics
// Plug-ins normally default to 200px wide. Indexes instead go for nil (auto) width
- (void)makeOriginalSize;


@end
