//
//  SVInspectorViewController.h
//  Sandvox
//
//  Created by Mike on 23/10/2009.
//  Copyright 2009-2012 Karelia Software. All rights reserved.
//
//  THIS SOFTWARE IS PROVIDED BY KARELIA SOFTWARE AND ITS CONTRIBUTORS "AS-IS"
//  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
//  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
//  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
//  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//  ARISING IN ANY WAY OUR OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//  POSSIBILITY OF SUCH DAMAGE.
//


//  This header should be well commented as to its functionality. Further information can be found at 
//  http://www.karelia.com/sandvox/help/z/Sandvox_Developers_Guide.html


#import <Cocoa/Cocoa.h>


@protocol SVPage;

@interface SVInspectorViewController : NSViewController
{
  @private
    NSArrayController   *_inspectedObjectsController;
    NSArray             *_inspectedPages;
#ifndef __clang_analyzer__
    id                  _reserved2;
    id                  _reserved3;
    id                  _reserved4;
#endif
    CGFloat             _tabHeight;
}

#pragma mark Inspected Objects

- (NSArray *)inspectedObjects;  // NOT KVO-compliant yet

// Bind to File's Owner inspectedObjectsController.selection.<key>
// Should have no reason to start introspecting or editing the controller's other properties; Plug-in system will do that for you.
- (NSArrayController *)inspectedObjectsController;

- (NSArray *)inspectedPages;    // KVO-compliant


#pragma mark Presentation
// defaults to height of view during -setView:
@property(nonatomic) CGFloat contentHeightForViewInInspector;


#pragma mark Page Utilities
- (NSURL *)URLForPage:(id <SVPage>)page AVAILABLE_SANDVOX_VERSION_2_8_AND_LATER;


@end