//
//  SVPageProtocol.h
//  Sandvox
//
//  Created by Mike on 02/01/2010.
//  Copyright 2010-2012 Karelia Software. All rights reserved.
//
//  THIS SOFTWARE IS PROVIDED BY KARELIA SOFTWARE AND ITS CONTRIBUTORS "AS-IS"
//  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
//  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
//  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
//  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//  ARISING IN ANY WAY OUR OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//  POSSIBILITY OF SUCH DAMAGE.
//


//  This header should be well commented as to its functionality. Further information can be found at 
//  http://www.karelia.com/sandvox/help/z/Sandvox_Developers_Guide.html


#import <Cocoa/Cocoa.h>
#import "SVPlugIn.h"

@protocol SVPlugInContext;


typedef NS_OPTIONS(NSUInteger, SVPageWritingOptions) {
    SVPageWritingSkipThumbnail = 1 << 0,
    SVPageWritingPlainText = 1 << 1 AVAILABLE_SANDVOX_VERSION_2_5_AND_LATER,
    SVPageWritingWithSharingBar = 1 << 2 AVAILABLE_SANDVOX_VERSION_2_8_AND_LATER,
};


@protocol SVPage <NSObject>;

#pragma mark Content

- (BOOL)writeContent:(id <SVPlugInContext>)context
			  plugIn:(SVPlugIn *)plugIn
			 options:(SVPageWritingOptions)options __attribute__((nonnull(1,2)));

// Pass 0 for untruncated string
- (NSString *)contentAsPlainTextTruncatedToLength:(NSUInteger)maxItemLength AVAILABLE_SANDVOX_VERSION_2_5_AND_LATER;

// For the image representation of a page, see SVPlugInContext


#pragma mark Properties

- (NSString *)title;
- (BOOL)showsTitle;

- (NSString *)language; // KVO-compliant
- (NSArray *)keywords AVAILABLE_SANDVOX_VERSION_2_2_AND_LATER;  // NOT KVO-compliant

@property(readonly) BOOL showsSharingBar AVAILABLE_SANDVOX_VERSION_2_8_AND_LATER;   // KVO-compliant

@property(nonatomic, copy, readonly) NSString *fileNameExtension AVAILABLE_SANDVOX_VERSION_2_2_AND_LATER;

// Want to know the URL of a page? Ask SVPlugInContext


#pragma mark Dates
- (NSString *)timestampDescription; // nil if page does't have/want timestamp
@property(nonatomic, copy, readonly) NSDate *creationDate;
@property(nonatomic, copy, readonly) NSDate *modificationDate;
- (NSString *)timestampDescriptionWithDate:(NSDate *)date;


#pragma mark Hierarchy

@property(nonatomic, readonly) BOOL isCollection;
- (id <SVPage>)parentPage;
- (id <SVPage>)rootPage;

// Looking for child pages? See SVPlugInContext

- (NSArray *)archivePages;


#pragma mark Navigation
// All KVO-compliant
- (BOOL)shouldIncludeInIndexes;
- (BOOL)shouldIncludeInSiteMaps;
@property(nonatomic, readonly) BOOL hasFeed;


@end