//
//  SVPasteboardItem.h
//  Sandvox
//
//  Created by Mike on 08/10/2010.
//  Copyright 2010-2012 Karelia Software. All rights reserved.
//
//  THIS SOFTWARE IS PROVIDED BY KARELIA SOFTWARE AND ITS CONTRIBUTORS "AS-IS"
//  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
//  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
//  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
//  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//  ARISING IN ANY WAY OUR OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//  POSSIBILITY OF SUCH DAMAGE.
//


//  This header should be well commented as to its functionality. Further information can be found at 
//  http://www.karelia.com/sandvox/help/z/Sandvox_Developers_Guide.html


#import <Cocoa/Cocoa.h>


@protocol SVPasteboardItem <NSObject>

// These methods try their best to infer the info from pasteboard.
- (NSString *)title;
- (NSURL *)URL;
- (NSDictionary *)metadata;

/* Returns an array of UTI strings of the data types supported by the receiver.
 */
- (NSArray *)types;

/* Given an array of types, will return the first type contained in the pasteboard item, according to the sender's ordering of types.  It will check for UTI conformance of the requested types, preferring an exact match to conformance.
 */
- (NSString *)availableTypeFromArray:(NSArray *)types __attribute__((nonnull(1)));

/* Returns a value for the provided UTI type string.
 */
- (NSData *)dataForType:(NSString *)type __attribute__((nonnull(1)));
- (NSString *)stringForType:(NSString *)type __attribute__((nonnull(1)));
- (id)propertyListForType:(NSString *)type __attribute__((nonnull(1)));

@end


#pragma mark -


@interface NSWorkspace (SVPasteboardItem)
- (id <SVPasteboardItem>)fetchBrowserWebLocation;
- (id <SVPasteboardItem>)fetchFeedWebLocation;
@end


//  If you're looking for more functionality, SVPlugIn features some support methods for handling pasteboard items