## Specta

This is just an alternate form of writing test cases. 

Rather than writing a subclass of `SenTestCase` or `ECTestCase` and then writing methods with `test` prepended to their names that run as individual tests; With Specta you write blocks of code that will be run as test cases.

The tests are grouped description blocks with sub-blocks (`context` is just an alias for `describe`) and within each of those there are `it` blocks which are run as individual tests.

It's also easier to set up tests as you can provide code that will be run before/after all or before/after each test block, and these can be nested into the blocks.

Specta runs on top of OCUnit, so all I had to do was add the static library and the headers to UnitTests/Support/Specta

## Expecta

This is an alternate form of writing expectations in test cases. 

Rather than using the `STAssert…` macros, expecta provides a different set of functions to match expectations to results in tests.

In almost all the cases I've used the simplest one `expect(what_I_want).to.equal(what_I_actually_got);`

As with Specta - all I did was add the static library and the header files to UnitTests/Support/Expecta and add `-ObjC` to the Other Linker Flags.

There aren't many matchers; they are described in the Readme file (which is in the folder)

This just provides matchers - you can still use `STAssert…` macros in the tests - as I've done in a couple of places to test exceptions.

## Running the tests

There is nothing extra that needs to be done. Specta runs on top of OCUnit, so just adding the test files (i.e. code containing a `SpecBegin` and `SpecEnd` means they will run along with any other tests with ⌘+U.

## Did the tests actually change anything?

Although I didn't write the tests to drive development (which is why I couldn't bring myself to write `should` as part of the test descriptions) I saw **each** of the tests fail as I wrote them; Initially, the `expectedString` was set to `@" "` and I ran the test to see an actual failure - a difference between the actual output and the expected output - before I wrote the specific expectation string and saw it pass. Just the same as if I were using SenTestCases, where I would write the `STAssert…` in such a way as to see a failure in the first place.

Also - in the same way - you can expect the test to fail if the output changes unexpectedly.

If you want to see what failing tests look like - just change the `expectedString` in any of the tests to see what the output looks like.

## Why?

- The tests can be broken down into smaller groups easier than if they were methods in a class.
- No need to provide a description string for the `STAssert…` macros, as the description for each test is built up from the nested descriptions and contexts rather than the method names.
- Granular set up and tear down for the test contexts.
- Very little set up required, as it runs within the current testing framework.
