$(document).ready(function () {
	var devicePixelRatio = (window.devicePixelRatio && window.devicePixelRatio > 1) ? window.devicePixelRatio : 1,
		deviceWidth = (window.innerWidth > window.innerHeight) ? screen.height : screen.width;

    $('span[data-img-src-hr]').each(function () {
		var width = $(this).data('width'),
			height = $(this).data('height'),
			alt = $(this).data('alt'),
			t = '<img src="',
			d = (devicePixelRatio > 1) // Must be Hi DPI of course
				&& (width < 2 * deviceWidth), // and also single-image pixel size is less than half of screen width (for reduced web pages like Sandvox 2)
			i = 0,
			r = ($(this)[0]).attributes;

		if (d)
		{
			t += $(this).data('img-src-hr');
		}
		else
		{
			t += $(this).data('img-src');
		}
		t += '"';
		if (alt) t += ' alt="' + alt + '"';
		if (width) t += ' width="' + width + '"';
		if (height) t += ' height="' + height + '"';
								   
		for (l = r.length; i < l; i++) {
			var n = r[i].name;

			if ( !n.match(/(data-width|data-height|data-alt|data-img-src)/g) ) {
				t += ' ' + n + '="' + r[i].value + '"';
			}
		}
								   
		t += ' />';
		$(this).replaceWith($(t));
	});
});