﻿using System;
using System.Reflection;
using HarmonyLib;
using HarmonyLib.Tools;
using UnityEngine;
using GameData.Domains.Item;
using GameData.Domains.Item.Display;
using GameData.GameDataBridge;



namespace Antonia_MOD
{
    [TaiwuModdingLib.Core.Plugin.PluginConfig("ChooseReward", "Antonia", "0.1")]
    public class ModEntry : TaiwuModdingLib.Core.Plugin.TaiwuRemakeHarmonyPlugin
    {
        private static Boolean LogEnabled = false;
        public static void Log(string str)
        {
            if (!LogEnabled) return;
            FileLog.Log(str);
        }
        public override void Initialize()
        {
#if DEBUG
            LogEnabled = true;
#else
            LogEnabled = false;
#endif
            Log("version-001");
            this.OnModSettingUpdate();
        }
        public override void OnModSettingUpdate()
        {
            Log("started");
            MethodInfo resultWindow = AccessTools.FirstMethod(typeof(UI_CombatResult), (MethodInfo it) => it.Name.Contains("OnInit"));
            MethodInfo patchMethod = typeof(Patch).GetMethod("AddOnclickEvent");
            //MethodInfo debug = typeof(Patch).GetMethod("DoNothing");
            base.HarmonyInstance.Patch(resultWindow, null, new HarmonyMethod(patchMethod));
            MethodInfo resultWindow2 = AccessTools.FirstMethod(typeof(UI_CombatResult), (MethodInfo it) => it.Name.Contains("OnClick"));
            MethodInfo patchMethod2 = typeof(Patch).GetMethod("Onclick");
            base.HarmonyInstance.Patch(resultWindow2, new HarmonyMethod(patchMethod2));
            Log("patched one");
            Log("patched all");
        }



        public static class Patch
        {
            public static void DoNothing()
            {
                return;
            }
            public static Boolean Onclick(UI_CombatResult __instance, CButton btn)
            {
                Log("action replace");
                Log(btn.name);
                Log(btn.GetInstanceID().ToString());
                return false;
            }
            public static void AddOnclickEvent(ref UI_CombatResult __instance)
            {
                var close = __instance.CGet<CButton>("Close");
                close.gameObject.SetActive(false);
                Log("add");
                var showedItems = __instance.CGet<RectTransform>("ItemHolder");
                taiwu_ = SingletonObject.getInstance<BasicGameData>().TaiwuCharId;
                Int32 itemsCnt = showedItems.childCount;
                UIBase temp = __instance;
                
                for(UInt16 itr = 0; itr< itemsCnt; ++itr)
                {
                    
                    Log("add---"+itr.ToString());
                    var itemv = showedItems.GetChild(itr).GetComponent<ItemView>();
                    UnityEngine.Events.UnityAction func = () =>
                    {
                        var itemData = itemv.Data;
                        Log("action start");
                        GameDataBridge.AddMethodCall<int, ItemKey, int>(temp.Element.GameDataListenerId, 6, 19, taiwu_, itemData.Key, itemData.Amount);
                        itemv.gameObject.SetActive(false);
                        Log("action end");
                    };
                    itemv.SetClickEvent(func);
                    itemv.SetInteractable(true);
                    Log("component2---" + itemv.isActiveAndEnabled.ToString());
                }
                Log("added");
                Log("end");
            }
            public static int taiwu_ = -1;
            
            
        }

    }
}
