import c4d
from c4d import documents
from c4d import gui

# This script places all animation tracks in a sequence
# Author: Mike Udin, 

# Check out more useful Cinema 4D plugins and scripts
# http://mikeudin.net

class Dialog(gui.GeDialog):
    cancel = True
    overlap = 0
    fromTM = False
    
    def CreateLayout(self):
        self.SetTitle("C4D序列插件Sequence Tracks")
        self.GroupBegin(10, c4d.BFH_CENTER,2, 2,title='group')
        self.AddStaticText(11, c4d.BFH_RIGHT, 0, 0, "重叠: ", 0)
        self.AddEditNumberArrows(12,c4d.BFH_LEFT,70,0)
        self.GroupEnd()
        self.AddCheckbox(13, c4d.BFH_CENTER, 180, 0,'从当前时间')
        self.GroupSpace(20,15)
        self.GroupBorderSpace(0,5,0,5)
        self.AddDlgGroup(c4d.DLG_OK|c4d.DLG_CANCEL)
        self.GroupEnd()
        return True

    def InitValues(self):
        self.SetFloat(12,0)
        self.SetBool(13,False)

        return True

    def Command(self, id, msg):
        if (id == 1):
            self.cancel = False
            self.overlap = self.GetFloat(12)
            self.fromTM = self.GetBool(13)
            self.Close()
        if (id == 2):
            self.Close()
        return True


def moveKeys(objectID, overlap, offsetTime, fromTM,number):
    
    # get fps
    fps = doc.GetFps()

    if offsetTime == 0 and fromTM: 
        overlap = doc.GetTime().GetFrame(fps)
    if offsetTime == 0 and not fromTM: 
        overlap = 0
    # get animation tracks inside the objects
    cTracks = objectID.GetCTracks()
    lastKeyTime = offsetTime
    # find first key of the track with lowest time
    firstList = []
    for cTrack in cTracks:
        keyCurve = cTrack.GetCurve()
        first_cKey = keyCurve.GetKey(0)
        first_cKeyTime = first_cKey.GetTime().Get() * fps
        firstList.append(first_cKeyTime)
        # print first_cKeyTime
    lowestKeyTime = min(firstList)
    # loop across each track
    # print lowestKeyTime   
    for cTrack in cTracks:
        
        # get the curve and keys in each track
        keyCurve = cTrack.GetCurve()
        keyCount = cTrack.GetCurve().GetKeyCount()
        first_cKey = keyCurve.GetKey(0)
        first_cKeyTime = first_cKey.GetTime().Get() * fps
        # loop across each key
        for i in range(keyCount):
            
            cKey = keyCurve.GetKey(i)
            cKeyTime = cKey.GetTime().Get() * fps
            
            if cKeyTime == lowestKeyTime and number == 0 and not fromTM: lowestKeyTime = 0
            newTime = (int(overlap)+offsetTime)+(cKeyTime-lowestKeyTime)
            cKey.SetTime(keyCurve,c4d.BaseTime(newTime,fps))
            
            if i == keyCount-1 and newTime > lastKeyTime: 
                # print cKeyTime
                lastKeyTime = newTime 
    
    return lastKeyTime
    
def main():
    
    selList = doc.GetActiveObjects(2)
    
    if not selList:
        c4d.gui.MessageDialog("书生汉化提示：请选择一些对象")
        return

    dial = Dialog()
    dial.Open(c4d.DLG_TYPE_MODAL)
    if dial.cancel: return

    offsetTime = 0

    for number,obj in enumerate([s for s in selList if s.GetCTracks()]):
        offsetTime = moveKeys(obj, dial.overlap, offsetTime, dial.fromTM,number)
        # print offsetTime

    c4d.EventAdd()

if __name__=='__main__':
    # c4d.CallCommand(13957, 13957) # Clear Console
    main()