# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# <pep8 compliant>

# ----------------------------------------------------------
# Author: Cody Winchester (codywinch)
# ----------------------------------------------------------

# ----------------------------------------------
# Define Addon info
# --
from . import ui
from . import operators
from . import properties
from bpy.props import *
import bpy
bl_info = {
    "name": "Shape Key Manger Pro",
    "author": "Cody Winchester (codywinch)",
    "version": (1, 4, 2),
    "blender": (2, 80, 0),
    "location": "3D View > Object and Properties > Object tab",
    "description": "by vfxmed.com Shape Key Manger Pro",
    "warning": "",
    "wiki_url": "",
    "category": "System"
}


if "bpy" in locals():
    import importlib
    if "__init__" in locals():
        importlib.reload(__init__)
    if "ui" in locals():
        importlib.reload(ui)
    if "properties" in locals():
        importlib.reload(properties)
    if "operators" in locals():
        importlib.reload(operators)


def register():
    ui.register()
    operators.register()
    properties.register()


def unregister():
    ui.unregister()
    operators.unregister()
    properties.unregister()
