import bpy
from bpy.props import *
from bpy.types import UIList, Panel, Operator
from .properties import *
from .operators import *


class SKMP_OT_relation_add(Operator):
    bl_idname = "skmp.relation_add"
    bl_label = "Add Relation to List"

    def execute(self, context):
        item = context.active_object.skmp_par_coll.shape_key_coll.add()
        l = len(context.active_object.skmp_par_coll.shape_key_coll) - 1
        context.active_object.skmp_par_coll.shape_key_coll[l]['parent_sk'] = ""
        context.active_object.skmp_par_coll.shape_key_coll[l]['child_sk'] = ""
        return {'FINISHED'}


class SKMP_OT_relation_remove(Operator):
    bl_idname = "skmp.relation_remove"
    bl_label = "Remove Relation from List"

    @classmethod
    def poll(cls, context):
        ob = context.active_object
        return len(ob.skmp_par_coll.shape_key_coll) > ob.skmp_par_coll.index >= 0

    def execute(self, context):
        ob = context.active_object
        ob.skmp_par_coll.shape_key_coll.remove(ob.skmp_par_coll.index)
        if ob.skmp_par_coll.index > 0:
            ob.skmp_par_coll.index -= 1
        return {'FINISHED'}


class SKMP_OT_relation_move(Operator):
    bl_idname = "skmp.relation_move"
    bl_label = "Move Relation Up/Down in List "

    direction: EnumProperty(items=(
        ('UP', "Up", "Move up"),
        ('DOWN', "Down", "Move down"))
    )

    @classmethod
    def poll(cls, context):
        ob = context.active_object
        return len(ob.skmp_par_coll.shape_key_coll) > ob.skmp_par_coll.index >= 0

    def execute(self, context):
        ob = context.active_object
        d = -1 if self.direction == 'UP' else 1
        new_index = (ob.skmp_par_coll.index +
                     d) % len(ob.skmp_par_coll.shape_key_coll)
        ob.skmp_par_coll.shape_key_coll.move(ob.skmp_par_coll.index, new_index)
        ob.skmp_par_coll.index = new_index
        return {'FINISHED'}


class SKMP_UL_parents_uilist(UIList):
    """for drawing each row"""

    def draw_item(self, context, layout, data, item, icon, active_data, active_propname):
        if self.layout_type in {'DEFAULT', 'COMPACT', 'GRID'}:
            col = layout.column(align=True)
            col.prop_search(
                item, "parent_sk", context.active_object.data.shape_keys, "key_blocks", text="")
            col = layout.column(align=True)
            col.prop_search(
                item, "child_sk", context.active_object.data.shape_keys, 'key_blocks', text="")


class SKMP_PT_tools_panel(Panel):
    """Creates a Panel in the scene context of the properties editor"""
    bl_label = "Shape Key Manager Pro"
    bl_idname = "OBJECT_PT_skmp"
    bl_space_type = 'PROPERTIES'
    bl_region_type = 'WINDOW'
    bl_context = 'data'

    @classmethod
    def poll(cls, context):
        obj = context.active_object
        if obj is not None:
            if obj.type == 'MESH' or obj.type == 'LATTICE' or obj.type == 'CURVE':
                return True

    def draw(self, context):
        layout = self.layout
        scn = context.scene
        data = bpy.data
        aobj = context.active_object

        scn_prop = scn.skmp_props

        box = layout.box()
        # ERROR NO SHAPE KEYS
        if aobj.data.shape_keys == None:
            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.label(icon='ERROR')
            row.label(text="Object has no Shape Keys")
            row.label(icon='ERROR')
            row.alignment = 'CENTER'

        # DUP MIRROR SETTINGS
        else:
            row = box.row()
            row.alignment = 'CENTER'
            row.label(icon='QUESTION')
            row.label(text="These settings are used for all operators")
            row.label(icon='QUESTION')
            row.alignment = 'CENTER'

            row = box.row()
            row.alignment = 'CENTER'
            row.label(icon='QUESTION')
            row.label(text="with the label (Filtered) and for renaming")
            row.label(icon='QUESTION')
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.prop(scn_prop, 'text_filter', text='Text Filter')
            row.prop(scn_prop, 'text_rename', text='Text Rename')
            row.alignment = 'CENTER'

            if scn_prop.text_filter == '':
                row = box.row(align=True)
                row.alignment = 'CENTER'
                row.label(icon='ERROR')
                row.label(text="No Filter is set, the (Filtered) operators")
                row.label(icon='ERROR')
                row.alignment = 'CENTER'
                row.alert = True

                row = box.row(align=True)
                row.alignment = 'CENTER'
                row.label(icon='ERROR')
                row.label(text="will apply to all Shape Keys")
                row.label(icon='ERROR')
                row.alignment = 'CENTER'
                row.alert = True

            row = box.row(align=True)
            row.operator("skmp.rename_filter_sk",
                         text='Rename Filtered Keys')
            row.alignment = 'CENTER'

            box.separator()

            row = box.row()
            row.alignment = 'CENTER'
            row.label(text="Utility Operators")
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.operator("skmp.toggle_vis_filter",
                         text='Mute Filtered Keys').onoroff = 0
            row.operator("skmp.toggle_vis_filter",
                         text='Unmute Filtered Keys').onoroff = 1
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.operator("skmp.toggle_vis_filter",
                         text='Mute Filtered Keys').onoroff = 2
            row.operator("skmp.toggle_vis_filter",
                         text='Unmute Filtered Keys').onoroff = 3
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.operator("skmp.apply_filter_vertex_weights",
                         text='Apply Filtered Keys Vertex Weights')
            row.alignment = 'CENTER'

            box.separator()

            row = box.row()
            row.alignment = 'CENTER'
            row.label(text="VERTEX GROUP ASSIGN")

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.prop_search(scn_prop, 'vgroup', aobj,
                            'vertex_groups', text='')
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.operator("skmp.assign_vgroup_filtered",
                         text='Assign Vertex Group To Filtered Keys')
            row.scale_y = 1.5

            box.separator()

            row = box.row()
            row.alignment = 'CENTER'
            row.label(text="MIRROR/DUPLICATE OPTIONS")

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.label(text='Mirror Axis')

            row = box.row(align=True)
            row.alignment = 'CENTER'
            if scn_prop.mirror_axis == 0:
                row.operator("skmp.set_mirror_axis", text="X",
                             emboss=False, icon='EMPTY_ARROWS').mirror_axis = 0
            else:
                row.operator("skmp.set_mirror_axis", text="X", emboss=True,
                             icon='OUTLINER_DATA_EMPTY').mirror_axis = 0
            if scn_prop.mirror_axis == 1:
                row.operator("skmp.set_mirror_axis", text="Y",
                             emboss=False, icon='EMPTY_ARROWS').mirror_axis = 1
            else:
                row.operator("skmp.set_mirror_axis", text="Y", emboss=True,
                             icon='OUTLINER_DATA_EMPTY').mirror_axis = 1
            if scn_prop.mirror_axis == 2:
                row.operator("skmp.set_mirror_axis", text="Z",
                             emboss=False, icon='EMPTY_ARROWS').mirror_axis = 2
            else:
                row.operator("skmp.set_mirror_axis", text="Z", emboss=True,
                             icon='OUTLINER_DATA_EMPTY').mirror_axis = 2
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.prop(scn_prop, 'copy_drivers', text='Copy Shape Keys Driver')
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.prop(scn_prop, 'rename_driver_bones',
                     text='Filter Rename Driver Bones/Paths')
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.label(text="Mirror Method")
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.prop(scn_prop, 'mirror_method', text='')
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.alignment = 'CENTER'
            row.prop(scn_prop, 'absoulte_mirror_coordinates',
                     text='Mirror Absoulte Coordinates')
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.operator("skmp.dupmirror_active_sk",
                         text='Dupe Active Key').execution = 'Dup'
            row.operator("skmp.dupmirror_active_sk",
                         text='Mir Active Key').execution = 'Mir'
            row.operator("skmp.dupmirror_active_sk",
                         text='DupMir Active Key').execution = 'MirDup'
            row.scale_y = 2
            row.alignment = 'CENTER'

            row = box.row(align=True)
            row.operator("skmp.dupmirror_filter_sk",
                         text='Dupe Filtered Keys').execution = 'Dup'
            row.operator("skmp.dupmirror_filter_sk",
                         text='Mir Filtered Keys').execution = 'Mir'
            row.operator("skmp.dupmirror_filter_sk",
                         text='DupMir Filtered Keys').execution = 'MirDup'
            row.scale_y = 2
            row.alignment = 'CENTER'

        # COPY AND SEPARATE SHAPE KEYS
        if True:
            box = layout.box()
            row = box.row()
            row.alignment = 'CENTER'
            row.prop(scn_prop, "copy_and_separate_bool",
                     icon="TRIA_DOWN" if scn_prop.copy_and_separate_bool else "TRIA_RIGHT",
                     icon_only=True, emboss=False
                     )
            row.label(text="Copy and Separate SK Settings")

            if scn_prop.copy_and_separate_bool:
                if aobj.data.shape_keys == None:
                    row = box.row(align=True)
                    row.alignment = 'CENTER'
                    row.label(icon='ERROR')
                    row.label(text="Object has no Shape Keys")
                    row.label(icon='ERROR')
                    row.alignment = 'CENTER'

                else:
                    row = box.row()
                    row.alignment = 'CENTER'
                    row.label(text="Explode Shape Keys to Separate Objects")

                    row = box.row()
                    row.alignment = 'CENTER'
                    row.prop(scn_prop, 'explode_apply_vgroup',
                             text='Apply Vertex Group Weights')
                    row.prop(scn_prop, 'sep_distance',
                             text='Separation Distance')
                    row = box.row()
                    row.alignment = 'CENTER'
                    row.operator('skmp.explode_sks')

                box.separator()
                box.separator()
                box.separator()

                row = box.row()
                row.alignment = 'CENTER'
                row.prop(scn_prop, 'copy_drivers',
                         text='Copy Shape Keys Driver')

                boxx = box.box()

                row = boxx.row(align=True)
                row.alignment = 'CENTER'
                row.label(text="Copy Shape Keys From Selected Objects")
                row.alignment = 'CENTER'

                row = boxx.row(align=True)
                row.alignment = 'CENTER'
                row.label(text='Matching Data Structure')

                row = boxx.row(align=True)
                row.operator("skmp.copy_selected_obj",
                             text='Selected Objects To Shape Keys', icon='SHAPEKEY_DATA')
                row.operator("skmp.copy_selected_sks",
                             text='Shape Keys From Selected Objs', icon='GROUP')
                row.scale_y = 1.5
                row.alignment = 'CENTER'

                if len(context.selected_objects) > 1:
                    all_mismatch = True
                    act_len = len(context.active_object.data.vertices)
                    mismatch_list = []
                    for ob in context.selected_objects:
                        if ob != context.active_object and ob.type == 'MESH':
                            if len(ob.data.vertices) != act_len:
                                mismatch_list.append(ob.name)
                            else:
                                all_mismatch = False

                    if len(mismatch_list) > 0:
                        name_list = ' '.join(mismatch_list)
                        row = boxx.row(align=True)
                        row.alignment = 'CENTER'
                        row.label(text='', icon='ERROR')
                        row.label(
                            text='These objects have mismatching data: ' + name_list)
                        row.label(text='', icon='ERROR')

                        if all_mismatch == True:
                            boxx.enabled = False

                boxx = box.box()

                row = boxx.row(align=True)
                row.alignment = 'CENTER'
                row.label(text='Mismatching Data Structure')

                row = boxx.row(align=True)
                row.prop(scn_prop, 'limit_selected',
                         text='Limit To Selected Vertices')
                row.prop(scn_prop, 'smooth_iterations',
                         text='Smoothng Iterations')
                row.alignment = 'CENTER'

                row = boxx.row(align=True)
                row.prop(scn_prop, 'copy_world_space',
                         text='World Space Coordinates')
                row.prop(scn_prop, 'copy_scale', text='Deformation Scale')
                row.alignment = 'CENTER'

                row = boxx.row(align=True)
                row.alignment = 'CENTER'
                row.operator("skmp.copy_sks_from_selected_mismatch",
                             text='Shape Keys From Selected Objects', icon='SHAPEKEY_DATA')
                row.scale_y = 1.5
                row.alignment = 'CENTER'

        # PARENT SHAPE KEYS
        if aobj.data.shape_keys != None:
            box = layout.box()
            row = box.row()
            row.alignment = 'CENTER'
            row.prop(scn_prop, "parent_menu_bool",
                     icon="TRIA_DOWN" if scn_prop.parent_menu_bool else "TRIA_RIGHT",
                     icon_only=True, emboss=False
                     )
            row.label(text="Parent Shape Key Settings")

            if scn_prop.parent_menu_bool:
                if aobj.data.shape_keys != None:
                    row = box.row(align=True)
                    row.alignment = 'CENTER'
                    row.operator('skmp.refresh_relations')
                    row.alignment = 'CENTER'

                    row = box.row()
                    col = row.column(align=True)
                    col.label(text="Parent Shape Key")
                    col.alignment = 'CENTER'
                    col = row.column(align=True)
                    col.label(text="Child Shape Key")
                    col.alignment = 'CENTER'

                    row = box.row(align=True)
                    row.template_list("SKMP_UL_parents_uilist", "", aobj.skmp_par_coll,
                                      "shape_key_coll", aobj.skmp_par_coll, "index")
                    col = row.column()
                    sub = col.column(align=True)
                    blid_ap = SKMP_OT_relation_add.bl_idname
                    sub.operator(blid_ap, text="", icon="ADD")
                    blid_ar = SKMP_OT_relation_remove.bl_idname
                    sub.operator(blid_ar, text="", icon="REMOVE")

                    sub = col.column(align=True)
                    sub.separator()
                    blid_am = SKMP_OT_relation_move.bl_idname
                    sub.operator(blid_am, text="",
                                 icon="TRIA_UP").direction = 'UP'
                    sub.operator(blid_am, text="",
                                 icon="TRIA_DOWN").direction = 'DOWN'
                else:
                    row = box.row(align=True)
                    row.alignment = 'CENTER'
                    row.label(icon='ERROR')
                    row.label(text="Object has no Shape Keys")
                    row.label(icon='ERROR')
                    row.alignment = 'CENTER'


def draw_item(self, context):
    layout = self.layout
    layout.separator()
    layout.label(text='SKMP Operators')
    layout.operator("skmp.apply_shape_keys", text='Apply All')
    layout.operator("skmp.set_active_as_basis", text='Set Active As Basis')
    layout.operator("skmp.apply_active_vertex_weights",
                    text='Apply Active Vertex Weights')
    layout.separator()
    layout.operator("skmp.toggle_vis", text='Mute All').onoroff = True
    layout.operator("skmp.toggle_vis", text='Unmute All').onoroff = False
    layout.separator()
    layout.operator("skmp.dupmirror_active_sk",
                    text='Duplicate Active Key').execution = 'Dup'
    layout.operator("skmp.dupmirror_active_sk",
                    text='Mirror Active Key').execution = 'Mir'
    layout.operator("skmp.dupmirror_active_sk",
                    text='Duplicate and Mirror Active Key').execution = 'MirDup'
    layout.separator()
    layout.operator("skmp.copy_drivers_to_selected_by_name",
                    text='Copy SK Drivers to Selected Objects by Name')


def register():
    bpy.utils.register_class(SKMP_OT_relation_add)
    bpy.utils.register_class(SKMP_OT_relation_remove)
    bpy.utils.register_class(SKMP_OT_relation_move)

    bpy.utils.register_class(SKMP_UL_parents_uilist)
    bpy.utils.register_class(SKMP_PT_tools_panel)
    bpy.types.MESH_MT_shape_key_context_menu.append(draw_item)
    return


def unregister():
    bpy.utils.unregister_class(SKMP_OT_relation_add)
    bpy.utils.unregister_class(SKMP_OT_relation_remove)
    bpy.utils.unregister_class(SKMP_OT_relation_move)

    bpy.utils.unregister_class(SKMP_UL_parents_uilist)
    bpy.utils.unregister_class(SKMP_PT_tools_panel)
    bpy.types.MESH_MT_shape_key_context_menu.remove(draw_item)
    return
