/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.action;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.Animate;
import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.exception.LostGroundException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.VariableMap;
import java.awt.Point;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Breed
extends Animate {
    private static final Logger log = Logger.getLogger(Breed.class.getName());
    public static final String PARAMETER_BORNX = "BornX";
    private static final int DEFAULT_BORNX = 0;
    public static final String PARAMETER_BORNY = "BornY";
    private static final int DEFAULT_BORNY = 0;
    public static final String PARAMETER_BORNBEHAVIOR = "BornBehavior";
    private static final String DEFAULT_BORNBEHAVIOR = "";

    public Breed(List<Animation> animations, VariableMap params) {
        super(animations, params);
    }

    @Override
    protected void tick() throws LostGroundException, VariableException {
        super.tick();
        if (this.getTime() == this.getAnimation().getDuration() - 1) {
            this.breed();
        }
    }

    private void breed() throws VariableException {
        Mascot mascot = new Mascot(this.getMascot().getImageSet());
        log.log(Level.INFO, "Breed Mascot ({0},{1},{2})", new Object[]{this.getMascot(), this, mascot});
        if (this.getMascot().isLookRight()) {
            mascot.setAnchor(new Point(this.getMascot().getAnchor().x - this.getBornX(), this.getMascot().getAnchor().y + this.getBornY().intValue()));
        } else {
            mascot.setAnchor(new Point(this.getMascot().getAnchor().x + this.getBornX(), this.getMascot().getAnchor().y + this.getBornY().intValue()));
        }
        mascot.setLookRight(this.getMascot().isLookRight());
        try {
            mascot.setBehavior(Main.getInstance().getConfiguration(this.getMascot().getImageSet()).buildBehavior(this.getBornBehavior()));
            this.getMascot().getManager().add(mascot);
        }
        catch (BehaviorInstantiationException e) {
            log.log(Level.SEVERE, "Fatal Exception", e);
            Main.showError("Failed to create new Shimeji.\nSee log for more details.");
            mascot.dispose();
        }
        catch (CantBeAliveException e) {
            log.log(Level.SEVERE, "Fatal Exception", e);
            Main.showError("Failed to create new Shimeji.\nSee log for more details.");
            mascot.dispose();
        }
    }

    private Number getBornY() throws VariableException {
        return this.eval(PARAMETER_BORNY, Number.class, 0);
    }

    private int getBornX() throws VariableException {
        return ((Number)this.eval(PARAMETER_BORNX, Number.class, 0)).intValue();
    }

    private String getBornBehavior() throws VariableException {
        return this.eval(PARAMETER_BORNBEHAVIOR, String.class, DEFAULT_BORNBEHAVIOR);
    }
}

