local assets = {
	Asset("ANIM", "anim/grenade.zip"),

	Asset("ATLAS", "images/inventoryimages/grenade.xml"),
	Asset("IMAGE", "images/inventoryimages/grenade.tex"),
}

local function onhit(inst, attacker, target)
	SpawnPrefab("collapse_small").Transform:SetPosition(target.Transform:GetWorldPosition())
	SpawnPrefab("explode_small").Transform:SetPosition(target.Transform:GetWorldPosition())
	GetPlayer().components.playercontroller:ShakeCamera(inst, "FULL", 0.7, 0.02, 0.5, 40)
	inst.components.combat:DoAreaAttack(target, 6, inst)
	inst:Remove()
end

local function onthrown(inst, data)
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("grenade")
    inst.AnimState:SetBuild("grenade")
    inst.AnimState:PlayAnimation("idle")

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("inspectable")

	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(200)
	inst.components.weapon:SetRange(10, 10)

	inst:AddComponent("combat")
	inst.components.combat:SetDefaultDamage(200)

	inst:AddComponent("equippable")
	inst.components.equippable.equipstack = true

	inst:AddComponent("projectile")
	inst.components.projectile:SetSpeed(30)
	inst.components.projectile:SetOnHitFn(onhit)

	inst:ListenForEvent("onthrown", onthrown)

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/grenade.xml"

	inst:AddComponent("selfstacker")

	return inst
end

return Prefab("common/inventory/grenade", fn, assets)
