local assets = {
	Asset("ANIM", "anim/healthkit.zip"),

	Asset("ATLAS", "images/inventoryimages/healthkit.xml"),
	Asset("IMAGE", "images/inventoryimages/healthkit.tex"),
}

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("healthkit")
	inst.AnimState:SetBuild("healthkit")
	inst.AnimState:PlayAnimation("idle")

	inst:AddComponent("healer")
	inst.components.healer:SetHealthAmount(TUNING.HEALING_MED*2)

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/healthkit.xml"

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	return inst
end

return Prefab("common/inventory/healthkit", fn, assets)
