# -*- coding: utf-8 -*-
# Generated by Django 1.9.10 on 2016-12-14 22:16
from __future__ import unicode_literals

from django.db import migrations, models


def copy_category_to_categories(apps, schema_editor):
    CategoryProductsBasketCondition = apps.get_model("campaigns", "CategoryProductsBasketCondition")
    for condition in CategoryProductsBasketCondition.objects.all():
        if condition.category:
            condition.categories.add(condition.category)


def copy_first_categories_to_category(apps, schema_editor):
    CategoryProductsBasketCondition = apps.get_model("campaigns", "CategoryProductsBasketCondition")
    for condition in CategoryProductsBasketCondition.objects.all():
        first_category = condition.categories.first()
        if first_category:
            condition.category = first_category
            condition.save()

class Migration(migrations.Migration):

    dependencies = [
        ('shuup', '0022_add_favicon'),
        ('campaigns', '0005_catalogfiltercachedshopproduct'),
    ]

    operations = [
        migrations.AddField(
            model_name='categoryproductsbasketcondition',
            name='categories',
            field=models.ManyToManyField(to='shuup.Category'),
        ),
        migrations.RunPython(copy_category_to_categories, reverse_code=copy_first_categories_to_category),
        migrations.RemoveField(
            model_name='categoryproductsbasketcondition',
            name='category',
        )
    ]
