# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2019-03-20 18:12
from __future__ import unicode_literals

from django.db import migrations


def set_coupons_shop(apps, schema_editor):
    Coupon = apps.get_model("campaigns", "Coupon")
    for coupon_code in Coupon.objects.filter(campaign__isnull=False):
        coupon_code.shop = coupon_code.campaign.shop
        coupon_code.save()


def remove_coupons_shop(apps, schema_editor):
    Coupon = apps.get_model("campaigns", "Coupon")
    Coupon.objects.all().update(shop=None)


class Migration(migrations.Migration):

    dependencies = [
        ('campaigns', '0014_campaign_supplier'),
    ]

    operations = [
        migrations.RunPython(set_coupons_shop, remove_coupons_shop),
    ]
