# -*- coding: utf-8 -*-
# Generated by Django 1.9.10 on 2016-11-21 22:29
from __future__ import unicode_literals

from django.db import migrations


def ensure_default_currencies_exists(apps, schema_editor):
    Currency = apps.get_model("shuup", "Currency")
    default_currencies = [
        ("USD", 2),
        ("EUR", 2),
        ("BRL", 2),
        ("JPY", 0),
        ("CNY", 2),
        ("GBP", 2)
    ]
    for code, decimal_places in default_currencies:
        cur, created = Currency.objects.get_or_create(code=code)
        if created:
            cur.decimal_places = decimal_places
            cur.save()


class Migration(migrations.Migration):

    dependencies = [
        ('shuup', '0016_currency'),
    ]

    operations = [
        migrations.RunPython(ensure_default_currencies_exists, migrations.RunPython.noop)
    ]
