# -*- coding: utf-8 -*-
# Generated by Django 1.9.11 on 2016-12-07 18:54
from __future__ import unicode_literals

from django.db import migrations
from markdown import Markdown


def update_field(md, model, field):
    for id, value in model.objects.exclude(**{field: ""}).values_list("id", field):
        md.reset()
        try:
            value = md.convert(value)
        except:
            # not valid markdown - leave it as-is
            continue
        model.objects.filter(id=id).update(**{field: value})


def md_to_html(apps, schema_editor):
    md = Markdown(extensions=[
        'markdown.extensions.extra',
        'markdown.extensions.nl2br',
    ], output_format="html5")
    ProductTranslation = apps.get_model("shuup", "ProductTranslation")
    CategoryTranslation = apps.get_model("shuup", "CategoryTranslation")
    PaymentMethodTranslation = apps.get_model("shuup", "PaymentMethodTranslation")
    ShippingMethodTranslation = apps.get_model("shuup", "ShippingMethodTranslation")
    update_field(md, ProductTranslation, "description")
    update_field(md, CategoryTranslation, "description")
    update_field(md, PaymentMethodTranslation, "description")
    update_field(md, ShippingMethodTranslation, "description")


class Migration(migrations.Migration):

    dependencies = [
        ('shuup', '0019_order_total_limit_behavior_component'),
    ]

    operations = [
        migrations.RunPython(md_to_html, migrations.RunPython.noop)
    ]
