# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2017-03-08 19:57
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import shuup.core.fields
import shuup.core.models._basket
import shuup.utils.properties


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('shuup', '0030_add_db_indices'),
    ]

    operations = [
        migrations.CreateModel(
            name='Basket',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('key', models.CharField(db_index=True, default=shuup.core.models._basket.generate_key, max_length=32, unique=True)),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_on', models.DateTimeField(auto_now=True, db_index=True)),
                ('persistent', models.BooleanField(db_index=True, default=False)),
                ('deleted', models.BooleanField(db_index=True, default=False)),
                ('finished', models.BooleanField(db_index=True, default=False)),
                ('title', models.CharField(blank=True, max_length=64)),
                ('data', shuup.core.fields.TaggedJSONField()),
                ('taxless_total_price_value', shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, default=0, max_digits=36, null=True)),
                ('taxful_total_price_value', shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, default=0, max_digits=36, null=True)),
                ('currency', shuup.core.fields.CurrencyField(max_length=4)),
                ('prices_include_tax', models.BooleanField()),
                ('product_count', models.IntegerField(default=0)),
                ('creator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='core_baskets_created', to=settings.AUTH_USER_MODEL)),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='customer_core_baskets', to='shuup.Contact')),
                ('orderer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='orderer_core_baskets', to='shuup.PersonContact')),
                ('products', models.ManyToManyField(blank=True, to='shuup.Product')),
                ('shop', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shuup.Shop')),
            ],
            options={
                'verbose_name_plural': 'baskets',
                'verbose_name': 'basket',
            },
            bases=(shuup.utils.properties.MoneyPropped, models.Model),
        ),
    ]
