# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2017-12-14 10:47
from __future__ import unicode_literals

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import enumfields.fields
import filer.fields.image
import jsonfield.fields
import mptt.fields
import shuup.core.fields
import shuup.core.models
import shuup.core.models._basket
import shuup.core.models._shops
import shuup.core.models._units
import timezone_field.fields


class Migration(migrations.Migration):

    dependencies = [
        ('shuup', '0038_order_date_index'),
    ]

    operations = [
        migrations.AlterField(
            model_name='attribute',
            name='searchable',
            field=models.BooleanField(default=True, help_text='Searchable attributes will be used for product lookup when customers search your store.', verbose_name='searchable'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='type',
            field=enumfields.fields.EnumIntegerField(default=20, enum=shuup.core.models.AttributeType, help_text='The attribute data type. Attribute values can be set on the product editor page.', verbose_name='type'),
        ),
        migrations.AlterField(
            model_name='attribute',
            name='visibility_mode',
            field=enumfields.fields.EnumIntegerField(default=1, enum=shuup.core.models.AttributeVisibility, help_text='Select the attribute visibility setting. Attributes can be shown on the product detail page or can be used to enhance product search results.', verbose_name='visibility mode'),
        ),
        migrations.AlterField(
            model_name='attributetranslation',
            name='name',
            field=models.CharField(help_text='The attribute name. Product attributes can be used to list the various features of a product and can be shown on the product detail page. The product attributes for a product are determined by the product type and can be set on the product editor page.', max_length=64, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='created_on',
            field=models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created on'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='creator',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='core_baskets_created', to=settings.AUTH_USER_MODEL, verbose_name='creator'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='currency',
            field=shuup.core.fields.CurrencyField(max_length=4, verbose_name='currency'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='customer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='customer_core_baskets', to='shuup.Contact', verbose_name='customer'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='data',
            field=shuup.core.fields.TaggedJSONField(verbose_name='data'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='deleted',
            field=models.BooleanField(db_index=True, default=False, verbose_name='deleted'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='finished',
            field=models.BooleanField(db_index=True, default=False, verbose_name='finished'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='id',
            field=models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='key',
            field=models.CharField(db_index=True, default=shuup.core.models._basket.generate_key, max_length=32, unique=True, verbose_name='key'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='orderer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='orderer_core_baskets', to='shuup.PersonContact', verbose_name='orderer'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='persistent',
            field=models.BooleanField(db_index=True, default=False, verbose_name='persistent'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='prices_include_tax',
            field=models.BooleanField(verbose_name='prices include tax'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='product_count',
            field=models.IntegerField(default=0, verbose_name='product_count'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='products',
            field=models.ManyToManyField(blank=True, to='shuup.Product', verbose_name='products'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='shop',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shuup.Shop', verbose_name='shop'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='taxful_total_price_value',
            field=shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, default=0, max_digits=36, null=True, verbose_name='taxful total price'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='taxless_total_price_value',
            field=shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, default=0, max_digits=36, null=True, verbose_name='taxless total price'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='title',
            field=models.CharField(blank=True, max_length=64, verbose_name='title'),
        ),
        migrations.AlterField(
            model_name='basket',
            name='updated_on',
            field=models.DateTimeField(auto_now=True, db_index=True, verbose_name='updated on'),
        ),
        migrations.AlterField(
            model_name='category',
            name='image',
            field=filer.fields.image.FilerImageField(blank=True, help_text='Category image. Will be shown at theme.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='filer.Image', verbose_name='image'),
        ),
        migrations.AlterField(
            model_name='category',
            name='ordering',
            field=models.IntegerField(default=0, help_text='You can set the order of categories in your store numerically.', verbose_name='ordering'),
        ),
        migrations.AlterField(
            model_name='category',
            name='parent',
            field=mptt.fields.TreeForeignKey(blank=True, help_text='If your category is a sub-category of another category, you can link them here.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='shuup.Category', verbose_name='parent category'),
        ),
        migrations.AlterField(
            model_name='category',
            name='shops',
            field=models.ManyToManyField(blank=True, help_text='You can select which shops the category is visible in.', related_name='categories', to='shuup.Shop', verbose_name='shops'),
        ),
        migrations.AlterField(
            model_name='category',
            name='status',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=1, enum=shuup.core.models.CategoryStatus, help_text='Here you can choose whether or not you want the category to be visible in your store.', verbose_name='status'),
        ),
        migrations.AlterField(
            model_name='category',
            name='visibility',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=1, enum=shuup.core.models.CategoryVisibility, help_text='You can choose to limit who sees your category based on whether they are logged in or if they are  part of a customer group.', verbose_name='visibility limitations'),
        ),
        migrations.AlterField(
            model_name='category',
            name='visibility_groups',
            field=models.ManyToManyField(blank=True, help_text='Select the customer groups you would like to be able to see the category. These groups are defined in Contacts Settings - Contact Groups.', related_name='visible_categories', to='shuup.ContactGroup', verbose_name='visible for groups'),
        ),
        migrations.AlterField(
            model_name='category',
            name='visible_in_menu',
            field=models.BooleanField(default=True, help_text='Check this if this category should be visible in menu.', verbose_name='visible in menu'),
        ),
        migrations.AlterField(
            model_name='categorytranslation',
            name='description',
            field=models.TextField(blank=True, help_text='Give your product category a detailed description. This will help shoppers find your products under that category in your store and on the web.', verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='categorytranslation',
            name='name',
            field=models.CharField(help_text='Enter a descriptive name for your product category. Products can be found in menus and in search in your store under the category name.', max_length=128, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='categorytranslation',
            name='slug',
            field=models.SlugField(blank=True, help_text='Enter a URL slug for your category. This is what your product category page URL will be. A default will be created using the category name.', null=True, verbose_name='slug'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='_language',
            field=shuup.core.fields.LanguageField(blank=True, choices=[('aa', 'aa'), ('ab', 'ab'), ('ace', 'ace'), ('ach', 'ach'), ('ada', 'ada'), ('ady', 'ady'), ('ae', 'ae'), ('aeb', 'aeb'), ('af', 'af'), ('afh', 'afh'), ('agq', 'agq'), ('ain', 'ain'), ('ak', 'ak'), ('akk', 'akk'), ('akz', 'akz'), ('ale', 'ale'), ('aln', 'aln'), ('alt', 'alt'), ('am', 'am'), ('an', 'an'), ('ang', 'ang'), ('anp', 'anp'), ('ar', 'ar'), ('ar_001', 'ar_001'), ('arc', 'arc'), ('arn', 'arn'), ('aro', 'aro'), ('arp', 'arp'), ('arq', 'arq'), ('arw', 'arw'), ('ary', 'ary'), ('arz', 'arz'), ('as', 'as'), ('asa', 'asa'), ('ase', 'ase'), ('ast', 'ast'), ('av', 'av'), ('avk', 'avk'), ('awa', 'awa'), ('ay', 'ay'), ('az', 'az'), ('ba', 'ba'), ('bal', 'bal'), ('ban', 'ban'), ('bar', 'bar'), ('bas', 'bas'), ('bax', 'bax'), ('bbc', 'bbc'), ('bbj', 'bbj'), ('be', 'be'), ('bej', 'bej'), ('bem', 'bem'), ('bew', 'bew'), ('bez', 'bez'), ('bfd', 'bfd'), ('bfq', 'bfq'), ('bg', 'bg'), ('bgn', 'bgn'), ('bho', 'bho'), ('bi', 'bi'), ('bik', 'bik'), ('bin', 'bin'), ('bjn', 'bjn'), ('bkm', 'bkm'), ('bla', 'bla'), ('bm', 'bm'), ('bn', 'bn'), ('bo', 'bo'), ('bpy', 'bpy'), ('bqi', 'bqi'), ('br', 'br'), ('bra', 'bra'), ('brh', 'brh'), ('brx', 'brx'), ('bs', 'bs'), ('bss', 'bss'), ('bua', 'bua'), ('bug', 'bug'), ('bum', 'bum'), ('byn', 'byn'), ('byv', 'byv'), ('ca', 'ca'), ('cad', 'cad'), ('car', 'car'), ('cay', 'cay'), ('cch', 'cch'), ('ce', 'ce'), ('ceb', 'ceb'), ('cgg', 'cgg'), ('ch', 'ch'), ('chb', 'chb'), ('chg', 'chg'), ('chk', 'chk'), ('chm', 'chm'), ('chn', 'chn'), ('cho', 'cho'), ('chp', 'chp'), ('chr', 'chr'), ('chy', 'chy'), ('ckb', 'ckb'), ('co', 'co'), ('cop', 'cop'), ('cps', 'cps'), ('cr', 'cr'), ('crh', 'crh'), ('cs', 'cs'), ('csb', 'csb'), ('cu', 'cu'), ('cv', 'cv'), ('cy', 'cy'), ('da', 'da'), ('dak', 'dak'), ('dar', 'dar'), ('dav', 'dav'), ('de', 'de'), ('de_AT', 'de_AT'), ('de_CH', 'de_CH'), ('del', 'del'), ('den', 'den'), ('dgr', 'dgr'), ('din', 'din'), ('dje', 'dje'), ('doi', 'doi'), ('dsb', 'dsb'), ('dtp', 'dtp'), ('dua', 'dua'), ('dum', 'dum'), ('dv', 'dv'), ('dyo', 'dyo'), ('dyu', 'dyu'), ('dz', 'dz'), ('dzg', 'dzg'), ('ebu', 'ebu'), ('ee', 'ee'), ('efi', 'efi'), ('egl', 'egl'), ('egy', 'egy'), ('eka', 'eka'), ('el', 'el'), ('elx', 'elx'), ('en', 'en'), ('en_AU', 'en_AU'), ('en_CA', 'en_CA'), ('en_GB', 'en_GB'), ('en_US', 'en_US'), ('enm', 'enm'), ('eo', 'eo'), ('es', 'es'), ('es_419', 'es_419'), ('es_ES', 'es_ES'), ('es_MX', 'es_MX'), ('esu', 'esu'), ('et', 'et'), ('eu', 'eu'), ('ewo', 'ewo'), ('ext', 'ext'), ('fa', 'fa'), ('fa_AF', 'fa_AF'), ('fan', 'fan'), ('fat', 'fat'), ('ff', 'ff'), ('fi', 'fi'), ('fil', 'fil'), ('fit', 'fit'), ('fj', 'fj'), ('fo', 'fo'), ('fon', 'fon'), ('fr', 'fr'), ('fr_CA', 'fr_CA'), ('fr_CH', 'fr_CH'), ('frc', 'frc'), ('frm', 'frm'), ('fro', 'fro'), ('frp', 'frp'), ('frr', 'frr'), ('frs', 'frs'), ('fur', 'fur'), ('fy', 'fy'), ('ga', 'ga'), ('gaa', 'gaa'), ('gag', 'gag'), ('gan', 'gan'), ('gay', 'gay'), ('gba', 'gba'), ('gbz', 'gbz'), ('gd', 'gd'), ('gez', 'gez'), ('gil', 'gil'), ('gl', 'gl'), ('glk', 'glk'), ('gmh', 'gmh'), ('gn', 'gn'), ('goh', 'goh'), ('gom', 'gom'), ('gon', 'gon'), ('gor', 'gor'), ('got', 'got'), ('grb', 'grb'), ('grc', 'grc'), ('gsw', 'gsw'), ('gu', 'gu'), ('guc', 'guc'), ('gur', 'gur'), ('guz', 'guz'), ('gv', 'gv'), ('gwi', 'gwi'), ('ha', 'ha'), ('hai', 'hai'), ('hak', 'hak'), ('haw', 'haw'), ('he', 'he'), ('hi', 'hi'), ('hif', 'hif'), ('hil', 'hil'), ('hit', 'hit'), ('hmn', 'hmn'), ('ho', 'ho'), ('hr', 'hr'), ('hsb', 'hsb'), ('hsn', 'hsn'), ('ht', 'ht'), ('hu', 'hu'), ('hup', 'hup'), ('hy', 'hy'), ('hz', 'hz'), ('ia', 'ia'), ('iba', 'iba'), ('ibb', 'ibb'), ('id', 'id'), ('ie', 'ie'), ('ig', 'ig'), ('ii', 'ii'), ('ik', 'ik'), ('ilo', 'ilo'), ('inh', 'inh'), ('io', 'io'), ('is', 'is'), ('it', 'it'), ('iu', 'iu'), ('izh', 'izh'), ('ja', 'ja'), ('jam', 'jam'), ('jbo', 'jbo'), ('jgo', 'jgo'), ('jmc', 'jmc'), ('jpr', 'jpr'), ('jrb', 'jrb'), ('jut', 'jut'), ('jv', 'jv'), ('ka', 'ka'), ('kaa', 'kaa'), ('kab', 'kab'), ('kac', 'kac'), ('kaj', 'kaj'), ('kam', 'kam'), ('kaw', 'kaw'), ('kbd', 'kbd'), ('kbl', 'kbl'), ('kcg', 'kcg'), ('kde', 'kde'), ('kea', 'kea'), ('ken', 'ken'), ('kfo', 'kfo'), ('kg', 'kg'), ('kgp', 'kgp'), ('kha', 'kha'), ('kho', 'kho'), ('khq', 'khq'), ('khw', 'khw'), ('ki', 'ki'), ('kiu', 'kiu'), ('kj', 'kj'), ('kk', 'kk'), ('kkj', 'kkj'), ('kl', 'kl'), ('kln', 'kln'), ('km', 'km'), ('kmb', 'kmb'), ('kn', 'kn'), ('ko', 'ko'), ('koi', 'koi'), ('kok', 'kok'), ('kos', 'kos'), ('kpe', 'kpe'), ('kr', 'kr'), ('krc', 'krc'), ('kri', 'kri'), ('krj', 'krj'), ('krl', 'krl'), ('kru', 'kru'), ('ks', 'ks'), ('ksb', 'ksb'), ('ksf', 'ksf'), ('ksh', 'ksh'), ('ku', 'ku'), ('kum', 'kum'), ('kut', 'kut'), ('kv', 'kv'), ('kw', 'kw'), ('ky', 'ky'), ('la', 'la'), ('lad', 'lad'), ('lag', 'lag'), ('lah', 'lah'), ('lam', 'lam'), ('lb', 'lb'), ('lez', 'lez'), ('lfn', 'lfn'), ('lg', 'lg'), ('li', 'li'), ('lij', 'lij'), ('liv', 'liv'), ('lkt', 'lkt'), ('lmo', 'lmo'), ('ln', 'ln'), ('lo', 'lo'), ('lol', 'lol'), ('loz', 'loz'), ('lrc', 'lrc'), ('lt', 'lt'), ('ltg', 'ltg'), ('lu', 'lu'), ('lua', 'lua'), ('lui', 'lui'), ('lun', 'lun'), ('luo', 'luo'), ('lus', 'lus'), ('luy', 'luy'), ('lv', 'lv'), ('lzh', 'lzh'), ('lzz', 'lzz'), ('mad', 'mad'), ('maf', 'maf'), ('mag', 'mag'), ('mai', 'mai'), ('mak', 'mak'), ('man', 'man'), ('mas', 'mas'), ('mde', 'mde'), ('mdf', 'mdf'), ('mdr', 'mdr'), ('men', 'men'), ('mer', 'mer'), ('mfe', 'mfe'), ('mg', 'mg'), ('mga', 'mga'), ('mgh', 'mgh'), ('mgo', 'mgo'), ('mh', 'mh'), ('mi', 'mi'), ('mic', 'mic'), ('min', 'min'), ('mk', 'mk'), ('ml', 'ml'), ('mn', 'mn'), ('mnc', 'mnc'), ('mni', 'mni'), ('moh', 'moh'), ('mos', 'mos'), ('mr', 'mr'), ('mrj', 'mrj'), ('ms', 'ms'), ('mt', 'mt'), ('mua', 'mua'), ('mul', 'mul'), ('mus', 'mus'), ('mwl', 'mwl'), ('mwr', 'mwr'), ('mwv', 'mwv'), ('my', 'my'), ('mye', 'mye'), ('myv', 'myv'), ('mzn', 'mzn'), ('na', 'na'), ('nan', 'nan'), ('nap', 'nap'), ('naq', 'naq'), ('nb', 'nb'), ('nd', 'nd'), ('nds', 'nds'), ('nds_NL', 'nds_NL'), ('ne', 'ne'), ('new', 'new'), ('ng', 'ng'), ('nia', 'nia'), ('niu', 'niu'), ('njo', 'njo'), ('nl', 'nl'), ('nl_BE', 'nl_BE'), ('nmg', 'nmg'), ('nn', 'nn'), ('nnh', 'nnh'), ('no', 'no'), ('nog', 'nog'), ('non', 'non'), ('nov', 'nov'), ('nqo', 'nqo'), ('nr', 'nr'), ('nso', 'nso'), ('nus', 'nus'), ('nv', 'nv'), ('nwc', 'nwc'), ('ny', 'ny'), ('nym', 'nym'), ('nyn', 'nyn'), ('nyo', 'nyo'), ('nzi', 'nzi'), ('oc', 'oc'), ('oj', 'oj'), ('om', 'om'), ('or', 'or'), ('os', 'os'), ('osa', 'osa'), ('ota', 'ota'), ('pa', 'pa'), ('pag', 'pag'), ('pal', 'pal'), ('pam', 'pam'), ('pap', 'pap'), ('pau', 'pau'), ('pcd', 'pcd'), ('pdc', 'pdc'), ('pdt', 'pdt'), ('peo', 'peo'), ('pfl', 'pfl'), ('phn', 'phn'), ('pi', 'pi'), ('pl', 'pl'), ('pms', 'pms'), ('pnt', 'pnt'), ('pon', 'pon'), ('prg', 'prg'), ('pro', 'pro'), ('ps', 'ps'), ('pt', 'pt'), ('pt_BR', 'pt_BR'), ('pt_PT', 'pt_PT'), ('qu', 'qu'), ('quc', 'quc'), ('qug', 'qug'), ('raj', 'raj'), ('rap', 'rap'), ('rar', 'rar'), ('rgn', 'rgn'), ('rif', 'rif'), ('rm', 'rm'), ('rn', 'rn'), ('ro', 'ro'), ('ro_MD', 'ro_MD'), ('rof', 'rof'), ('rom', 'rom'), ('root', 'root'), ('rtm', 'rtm'), ('ru', 'ru'), ('rue', 'rue'), ('rug', 'rug'), ('rup', 'rup'), ('rw', 'rw'), ('rwk', 'rwk'), ('sa', 'sa'), ('sad', 'sad'), ('sah', 'sah'), ('sam', 'sam'), ('saq', 'saq'), ('sas', 'sas'), ('sat', 'sat'), ('saz', 'saz'), ('sba', 'sba'), ('sbp', 'sbp'), ('sc', 'sc'), ('scn', 'scn'), ('sco', 'sco'), ('sd', 'sd'), ('sdc', 'sdc'), ('sdh', 'sdh'), ('se', 'se'), ('see', 'see'), ('seh', 'seh'), ('sei', 'sei'), ('sel', 'sel'), ('ses', 'ses'), ('sg', 'sg'), ('sga', 'sga'), ('sgs', 'sgs'), ('sh', 'sh'), ('shi', 'shi'), ('shn', 'shn'), ('shu', 'shu'), ('si', 'si'), ('sid', 'sid'), ('sk', 'sk'), ('sl', 'sl'), ('sli', 'sli'), ('sly', 'sly'), ('sm', 'sm'), ('sma', 'sma'), ('smj', 'smj'), ('smn', 'smn'), ('sms', 'sms'), ('sn', 'sn'), ('snk', 'snk'), ('so', 'so'), ('sog', 'sog'), ('sq', 'sq'), ('sr', 'sr'), ('srn', 'srn'), ('srr', 'srr'), ('ss', 'ss'), ('ssy', 'ssy'), ('st', 'st'), ('stq', 'stq'), ('su', 'su'), ('suk', 'suk'), ('sus', 'sus'), ('sux', 'sux'), ('sv', 'sv'), ('sw', 'sw'), ('sw_CD', 'sw_CD'), ('swb', 'swb'), ('syc', 'syc'), ('syr', 'syr'), ('szl', 'szl'), ('ta', 'ta'), ('tcy', 'tcy'), ('te', 'te'), ('tem', 'tem'), ('teo', 'teo'), ('ter', 'ter'), ('tet', 'tet'), ('tg', 'tg'), ('th', 'th'), ('ti', 'ti'), ('tig', 'tig'), ('tiv', 'tiv'), ('tk', 'tk'), ('tkl', 'tkl'), ('tkr', 'tkr'), ('tl', 'tl'), ('tlh', 'tlh'), ('tli', 'tli'), ('tly', 'tly'), ('tmh', 'tmh'), ('tn', 'tn'), ('to', 'to'), ('tog', 'tog'), ('tpi', 'tpi'), ('tr', 'tr'), ('tru', 'tru'), ('trv', 'trv'), ('ts', 'ts'), ('tsd', 'tsd'), ('tsi', 'tsi'), ('tt', 'tt'), ('ttt', 'ttt'), ('tum', 'tum'), ('tvl', 'tvl'), ('tw', 'tw'), ('twq', 'twq'), ('ty', 'ty'), ('tyv', 'tyv'), ('tzm', 'tzm'), ('udm', 'udm'), ('ug', 'ug'), ('uga', 'uga'), ('uk', 'uk'), ('umb', 'umb'), ('und', 'und'), ('ur', 'ur'), ('uz', 'uz'), ('vai', 'vai'), ('ve', 've'), ('vec', 'vec'), ('vep', 'vep'), ('vi', 'vi'), ('vls', 'vls'), ('vmf', 'vmf'), ('vo', 'vo'), ('vot', 'vot'), ('vro', 'vro'), ('vun', 'vun'), ('wa', 'wa'), ('wae', 'wae'), ('wal', 'wal'), ('war', 'war'), ('was', 'was'), ('wbp', 'wbp'), ('wo', 'wo'), ('wuu', 'wuu'), ('xal', 'xal'), ('xh', 'xh'), ('xmf', 'xmf'), ('xog', 'xog'), ('yao', 'yao'), ('yap', 'yap'), ('yav', 'yav'), ('ybb', 'ybb'), ('yi', 'yi'), ('yo', 'yo'), ('yrl', 'yrl'), ('yue', 'yue'), ('za', 'za'), ('zap', 'zap'), ('zbl', 'zbl'), ('zea', 'zea'), ('zen', 'zen'), ('zgh', 'zgh'), ('zh', 'zh'), ('zh_Hans', 'zh_Hans'), ('zh_Hant', 'zh_Hant'), ('zu', 'zu'), ('zun', 'zun'), ('zxx', 'zxx'), ('zza', 'zza')], help_text='The primary language to be used in all communications with the contact.', max_length=10, verbose_name='language'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='email',
            field=models.EmailField(blank=True, help_text='The email that will receive order confirmations and promotional materials (if permitted).', max_length=256, verbose_name='email'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='is_active',
            field=models.BooleanField(db_index=True, default=True, help_text='Check this if the contact is an active customer.', verbose_name='active'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='marketing_permission',
            field=models.BooleanField(default=True, help_text='Check this if the contact can receive marketing and promotional materials.', verbose_name='marketing permission'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='merchant_notes',
            field=models.TextField(blank=True, help_text='Enter any private notes for this customer that are only accessible in Shuup admin.', verbose_name='merchant notes'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='modified_on',
            field=models.DateTimeField(auto_now=True, db_index=True, null=True, verbose_name='modified on'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='name',
            field=models.CharField(help_text='The contact name', max_length=256, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='phone',
            field=models.CharField(blank=True, help_text='The primary phone number of the contact.', max_length=64, verbose_name='phone'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='prefix',
            field=models.CharField(blank=True, help_text='The name prefix of the contact. For example, Mr, Mrs, Dr, etc.', max_length=64, verbose_name='name prefix'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='shops',
            field=models.ManyToManyField(blank=True, help_text='Inform which shops have access to this contact.', to='shuup.Shop', verbose_name='shops'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='suffix',
            field=models.CharField(blank=True, help_text='The name suffix of the contact. For example, Sr, Jr, etc.', max_length=64, verbose_name='name suffix'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='tax_group',
            field=models.ForeignKey(blank=True, help_text='Select the contact tax group to use for this contact. Tax groups can be used to customize the tax rules the that apply to any of this contacts orders. Tax groups are defined in Settings - Customer Tax Groups and can be applied to tax rules in Settings - Tax Rules', null=True, on_delete=django.db.models.deletion.PROTECT, to='shuup.CustomerTaxGroup', verbose_name='tax group'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='timezone',
            field=timezone_field.fields.TimeZoneField(blank=True, help_text='The timezone in which the contact resides. This can be used to target the delivery of promotional materials at a particular time.', null=True, verbose_name='time zone'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='www',
            field=models.URLField(blank=True, help_text='The web address of the contact, if any.', max_length=128, verbose_name='web address'),
        ),
        migrations.AlterField(
            model_name='contactgrouptranslation',
            name='name',
            field=models.CharField(help_text='The contact group name. Contact groups can be used to target sales and campaigns to specific set of users.', max_length=64, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='countrylimitbehaviorcomponent',
            name='available_in_countries',
            field=jsonfield.fields.JSONField(blank=True, null=True, verbose_name='available in countries'),
        ),
        migrations.AlterField(
            model_name='countrylimitbehaviorcomponent',
            name='available_in_european_countries',
            field=models.BooleanField(default=False, verbose_name='available in european countries'),
        ),
        migrations.AlterField(
            model_name='countrylimitbehaviorcomponent',
            name='unavailable_in_countries',
            field=jsonfield.fields.JSONField(blank=True, null=True, verbose_name='unavailable in countries'),
        ),
        migrations.AlterField(
            model_name='countrylimitbehaviorcomponent',
            name='unavailable_in_european_countries',
            field=models.BooleanField(default=False, verbose_name='unavailable in european countries'),
        ),
        migrations.AlterField(
            model_name='currency',
            name='decimal_places',
            field=models.PositiveSmallIntegerField(default=2, help_text='The number of decimal places supported by this currency.', validators=[django.core.validators.MaxValueValidator(10)], verbose_name='decimal places'),
        ),
        migrations.AlterField(
            model_name='customertaxgrouptranslation',
            name='name',
            field=models.CharField(help_text='The customer tax group name. Customer tax groups can be used to control how taxes are applied to a set of customers. ', max_length=100, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='allow_bare_number',
            field=models.BooleanField(default=False, help_text="If true, values of this unit can be shown without the symbol occasionally.  Usually wanted if the unit is a piece, so that product listings can show just '$5.95' rather than '$5.95 per pc.'.", verbose_name='allow bare number'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='comparison_value',
            field=shuup.core.fields.QuantityField(decimal_places=9, default=1, help_text='Value to use when displaying unit prices.  E.g. if the display unit is g and the comparison value is 100, then unit prices are shown per 100g, like: $2.95 per 100g.', max_digits=36, validators=[shuup.core.models._units.validate_positive_not_zero], verbose_name='comparison value'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='decimals',
            field=models.PositiveSmallIntegerField(default=0, help_text='The number of decimal places to use for values in the display unit.  The internal values are still rounded based on settings of the internal unit.', verbose_name='decimal places'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='default',
            field=models.BooleanField(default=False, help_text='Use this display unit by default when displaying values of the internal unit.', verbose_name='use by default'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='id',
            field=models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='internal_unit',
            field=models.ForeignKey(help_text='The sales unit that this display unit is linked to.', on_delete=django.db.models.deletion.CASCADE, related_name='display_units', to='shuup.SalesUnit', verbose_name='internal unit'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='ratio',
            field=shuup.core.fields.QuantityField(decimal_places=9, default=1, help_text='Size of the display unit in internal unit.  E.g. if internal unit is kilogram and display unit is gram, ratio is 0.001.', max_digits=36, validators=[shuup.core.models._units.validate_positive_not_zero], verbose_name='ratio'),
        ),
        migrations.AlterField(
            model_name='displayunittranslation',
            name='id',
            field=models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
        ),
        migrations.AlterField(
            model_name='displayunittranslation',
            name='language_code',
            field=models.CharField(db_index=True, max_length=15, verbose_name='Language'),
        ),
        migrations.AlterField(
            model_name='displayunittranslation',
            name='name',
            field=models.CharField(help_text='Name of the display unit, e.g. Grams.', max_length=150, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='displayunittranslation',
            name='symbol',
            field=models.CharField(help_text="An abbreviated name of the display unit, e.g. 'g'.", max_length=50, verbose_name='symbol'),
        ),
        migrations.AlterField(
            model_name='fixedcostbehaviorcomponent',
            name='price_value',
            field=shuup.core.fields.MoneyValueField(decimal_places=9, help_text='The fixed cost to apply to this service.', max_digits=36),
        ),
        migrations.AlterField(
            model_name='fixedcostbehaviorcomponenttranslation',
            name='description',
            field=models.CharField(blank=True, help_text='The order line text to display when this behavior is applied.', max_length=100, verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='groupavailabilitybehaviorcomponent',
            name='groups',
            field=models.ManyToManyField(help_text='The contact groups for which this service is available.', to='shuup.ContactGroup', verbose_name='groups'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='city',
            field=models.CharField(help_text='The address city.', max_length=255, verbose_name='city'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='company_name',
            field=models.CharField(blank=True, help_text='The company name for the address.', max_length=255, verbose_name='company name'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='country',
            field=django_countries.fields.CountryField(help_text='The address country.', max_length=2, verbose_name='country'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='email',
            field=models.EmailField(blank=True, help_text='The primary email for the address.', max_length=128, verbose_name='email'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='name',
            field=models.CharField(help_text='The name for the address.', max_length=255, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='name_ext',
            field=models.CharField(blank=True, help_text='Any other text to display along with the address. This could be department names (for companies) or titles (for people).', max_length=255, verbose_name='name extension'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='phone',
            field=models.CharField(blank=True, help_text='The primary phone number for the address.', max_length=64, verbose_name='phone'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='postal_code',
            field=models.CharField(blank=True, help_text='The address postal/zip code.', max_length=64, verbose_name='postal code'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='prefix',
            field=models.CharField(blank=True, help_text='The name prefix. For example, Mr, Mrs, Ms, Dr, etc.', max_length=64, verbose_name='name prefix'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='region',
            field=models.CharField(blank=True, help_text='The address region, province, or state.', max_length=64, verbose_name='region'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='region_code',
            field=models.CharField(blank=True, help_text='The address region, province, or state.', max_length=16, verbose_name='region code'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='street',
            field=models.CharField(help_text='The street address.', max_length=255, verbose_name='street'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='street2',
            field=models.CharField(blank=True, help_text='An additional street address line.', max_length=255, verbose_name='street (2)'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='street3',
            field=models.CharField(blank=True, help_text='Any additional street address line.', max_length=255, verbose_name='street (3)'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='suffix',
            field=models.CharField(blank=True, help_text='The name suffix. For example, Jr, Sr, etc.', max_length=64, verbose_name='name suffix'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='tax_number',
            field=models.CharField(blank=True, help_text='The business tax number. For example, EIN in US or VAT code in Europe.', max_length=64, verbose_name='tax number'),
        ),
        migrations.AlterField(
            model_name='manufacturer',
            name='name',
            field=models.CharField(help_text='Enter the manufacturer’s name. Products can be filtered by the manufacturer and can be useful for inventory and stock management.', max_length=128, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='manufacturer',
            name='url',
            field=models.CharField(blank=True, help_text="Enter the URL of the product manufacturer if you would like customers to be able to visit the manufacturer's website.", max_length=128, null=True, verbose_name='URL'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='city',
            field=models.CharField(help_text='The address city.', max_length=255, verbose_name='city'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='company_name',
            field=models.CharField(blank=True, help_text='The company name for the address.', max_length=255, verbose_name='company name'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='country',
            field=django_countries.fields.CountryField(help_text='The address country.', max_length=2, verbose_name='country'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='email',
            field=models.EmailField(blank=True, help_text='The primary email for the address.', max_length=128, verbose_name='email'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='name',
            field=models.CharField(help_text='The name for the address.', max_length=255, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='name_ext',
            field=models.CharField(blank=True, help_text='Any other text to display along with the address. This could be department names (for companies) or titles (for people).', max_length=255, verbose_name='name extension'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='phone',
            field=models.CharField(blank=True, help_text='The primary phone number for the address.', max_length=64, verbose_name='phone'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='postal_code',
            field=models.CharField(blank=True, help_text='The address postal/zip code.', max_length=64, verbose_name='postal code'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='prefix',
            field=models.CharField(blank=True, help_text='The name prefix. For example, Mr, Mrs, Ms, Dr, etc.', max_length=64, verbose_name='name prefix'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='region',
            field=models.CharField(blank=True, help_text='The address region, province, or state.', max_length=64, verbose_name='region'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='region_code',
            field=models.CharField(blank=True, help_text='The address region, province, or state.', max_length=16, verbose_name='region code'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='street',
            field=models.CharField(help_text='The street address.', max_length=255, verbose_name='street'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='street2',
            field=models.CharField(blank=True, help_text='An additional street address line.', max_length=255, verbose_name='street (2)'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='street3',
            field=models.CharField(blank=True, help_text='Any additional street address line.', max_length=255, verbose_name='street (3)'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='suffix',
            field=models.CharField(blank=True, help_text='The name suffix. For example, Jr, Sr, etc.', max_length=64, verbose_name='name suffix'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='tax_number',
            field=models.CharField(blank=True, help_text='The business tax number. For example, EIN in US or VAT code in Europe.', max_length=64, verbose_name='tax number'),
        ),
        migrations.AlterField(
            model_name='order',
            name='modified_on',
            field=models.DateTimeField(auto_now=True, db_index=True, verbose_name='modified on'),
        ),
        migrations.AlterField(
            model_name='ordertotallimitbehaviorcomponent',
            name='max_price_value',
            field=shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, max_digits=36, null=True, verbose_name='max price value'),
        ),
        migrations.AlterField(
            model_name='ordertotallimitbehaviorcomponent',
            name='min_price_value',
            field=shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, max_digits=36, null=True, verbose_name='min price value'),
        ),
        migrations.AlterField(
            model_name='paymentmethod',
            name='enabled',
            field=models.BooleanField(default=False, help_text='Check this if this service is selectable on checkout.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='paymentmethod',
            name='shop',
            field=models.ForeignKey(help_text='The shop for this service.', on_delete=django.db.models.deletion.CASCADE, to='shuup.Shop', verbose_name='shop'),
        ),
        migrations.AlterField(
            model_name='paymentmethod',
            name='tax_class',
            field=models.ForeignKey(help_text='The tax class to use for this service. Tax classes are defined in Settings - Tax Classes.', on_delete=django.db.models.deletion.PROTECT, to='shuup.TaxClass', verbose_name='tax class'),
        ),
        migrations.AlterField(
            model_name='paymentmethodtranslation',
            name='description',
            field=models.CharField(blank=True, help_text='The payment method description. This description is shown to customers on checkout.', max_length=500, verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='paymentmethodtranslation',
            name='name',
            field=models.CharField(help_text='The payment method name. This name is shown to customers on checkout.', max_length=100, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='personcontact',
            name='birth_date',
            field=models.DateField(blank=True, help_text='The birth date of the contact.', null=True, verbose_name='birth date'),
        ),
        migrations.AlterField(
            model_name='personcontact',
            name='first_name',
            field=models.CharField(blank=True, help_text='The first name of the contact.', max_length=120, verbose_name='first name'),
        ),
        migrations.AlterField(
            model_name='personcontact',
            name='gender',
            field=enumfields.fields.EnumField(default='u', enum=shuup.core.models.Gender, help_text='The gender of the contact.', max_length=4, verbose_name='gender'),
        ),
        migrations.AlterField(
            model_name='personcontact',
            name='last_name',
            field=models.CharField(blank=True, help_text='The last name of the contact.', max_length=120, verbose_name='last name'),
        ),
        migrations.AlterField(
            model_name='product',
            name='barcode',
            field=models.CharField(blank=True, help_text='You can enter the barcode number for your product. This is useful for inventory/stock tracking and analysis.', max_length=40, verbose_name='barcode'),
        ),
        migrations.AlterField(
            model_name='product',
            name='depth',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text='Set the measured depth or length of your product or product packaging. This will provide customers with your product size and help with calculating shipping costs.', max_digits=36, unit='mm', verbose_name='depth (mm)'),
        ),
        migrations.AlterField(
            model_name='product',
            name='gross_weight',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text='Set the measured gross Weight of your product WITH its packaging. This will help with calculating shipping costs.', max_digits=36, unit='g', verbose_name='gross weight (g)'),
        ),
        migrations.AlterField(
            model_name='product',
            name='gtin',
            field=models.CharField(blank=True, help_text='You can enter a Global Trade Item Number. This is typically a 14 digit identification number for all of your trade items. It can often be found by the barcode.', max_length=40, verbose_name='GTIN'),
        ),
        migrations.AlterField(
            model_name='product',
            name='height',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text='Set the measured height of your product or product packaging. This will provide customers with your product size and help with calculating shipping costs.', max_digits=36, unit='mm', verbose_name='height (mm)'),
        ),
        migrations.AlterField(
            model_name='product',
            name='manufacturer',
            field=models.ForeignKey(blank=True, help_text='Select a manufacturer for your product. These are defined in Products Settings - Manufacturers', null=True, on_delete=django.db.models.deletion.PROTECT, to='shuup.Manufacturer', verbose_name='manufacturer'),
        ),
        migrations.AlterField(
            model_name='product',
            name='net_weight',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text='Set the measured weight of your product WITHOUT its packaging. This will provide customers with your product weight.', max_digits=36, unit='g', verbose_name='net weight (g)'),
        ),
        migrations.AlterField(
            model_name='product',
            name='sales_unit',
            field=models.ForeignKey(blank=True, help_text='Select a sales unit for your product. This is shown in your store front and is used to determine whether the product can be purchased using fractional amounts. Sales units are defined in Products - Sales Units.', null=True, on_delete=django.db.models.deletion.PROTECT, to='shuup.SalesUnit', verbose_name='sales unit'),
        ),
        migrations.AlterField(
            model_name='product',
            name='shipping_mode',
            field=enumfields.fields.EnumIntegerField(default=1, enum=shuup.core.models.ShippingMode, help_text='Set to shipped if the product requires shipment.', verbose_name='shipping mode'),
        ),
        migrations.AlterField(
            model_name='product',
            name='sku',
            field=models.CharField(db_index=True, help_text='Enter a SKU (Stock Keeping Unit) number for your product. This is a product identification code that helps you track it through your inventory. People often use the number by the barcode on the product, but you can set up any numerical system you want to keep track of products.', max_length=128, unique=True, verbose_name='SKU'),
        ),
        migrations.AlterField(
            model_name='product',
            name='stock_behavior',
            field=enumfields.fields.EnumIntegerField(default=0, enum=shuup.core.models.StockBehavior, help_text='Set to stocked if inventory should be managed within Shuup.', verbose_name='stock'),
        ),
        migrations.AlterField(
            model_name='product',
            name='tax_class',
            field=models.ForeignKey(help_text='Select a tax class for your product. The tax class is used to determine which taxes to apply to your product. Tax classes are defined in Settings - Tax Classes. The rules by which taxes are applied are defined in Settings - Tax Rules.', on_delete=django.db.models.deletion.PROTECT, to='shuup.TaxClass', verbose_name='tax class'),
        ),
        migrations.AlterField(
            model_name='product',
            name='type',
            field=models.ForeignKey(help_text='Select a product type for your product. These allow you to configure custom attributes to help with classification and analysis.', on_delete=django.db.models.deletion.PROTECT, related_name='products', to='shuup.ProductType', verbose_name='product type'),
        ),
        migrations.AlterField(
            model_name='product',
            name='width',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text='Set the measured width of your product or product packaging. This will provide customers with your product size and help with calculating shipping costs.', max_digits=36, unit='mm', verbose_name='width (mm)'),
        ),
        migrations.AlterField(
            model_name='productmedia',
            name='kind',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=1, enum=shuup.core.models.ProductMediaKind, help_text='Select what type the media is. It can either be a normal file, part of the documentation, or a sample.', verbose_name='kind'),
        ),
        migrations.AlterField(
            model_name='productmedia',
            name='ordering',
            field=models.IntegerField(default=0, help_text='You enter the numerical order that your image will be displayed on your product page.', verbose_name='ordering'),
        ),
        migrations.AlterField(
            model_name='productmedia',
            name='public',
            field=models.BooleanField(default=True, help_text='Check this if you would like the image shown on your product page. Checked by default.', verbose_name='public (shown on product page)'),
        ),
        migrations.AlterField(
            model_name='productmedia',
            name='purchased',
            field=models.BooleanField(default=False, help_text='Select this if you would like the product media shown for completed purchases.', verbose_name='purchased (shown for finished purchases)'),
        ),
        migrations.AlterField(
            model_name='productmedia',
            name='shops',
            field=models.ManyToManyField(help_text='Select which shops you would like the product media to be visible in.', related_name='product_media', to='shuup.Shop', verbose_name='shops'),
        ),
        migrations.AlterField(
            model_name='productmediatranslation',
            name='description',
            field=models.TextField(blank=True, help_text='Write a description for your product media. This will help it be found in your store and on the web.', verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='productmediatranslation',
            name='title',
            field=models.CharField(blank=True, help_text='Choose a title for your product media. This will help it be found in your store and on the web.', max_length=128, verbose_name='title'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='description',
            field=models.TextField(blank=True, help_text='To make your product stand out, give it an awesome description. This is what will help your shoppers learn about your products. It will also help shoppers find them in the store and on the web.', verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='keywords',
            field=models.TextField(blank=True, help_text='You can enter keywords that describe your product. This will help your shoppers learn about your products. It will also help shoppers find them in the store and on the web.', verbose_name='keywords'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='name',
            field=models.CharField(help_text='Enter a descriptive name for your product. This will be its title in your store.', max_length=256, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='short_description',
            field=models.CharField(blank=True, help_text='Enter a short description for your product. The short description will be used to get the attention of your customer with a small but precise description of your product.', max_length=150, verbose_name='short description'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='slug',
            field=models.SlugField(blank=True, help_text='Enter a URL Slug for your product. This is what your product page URL will be. A default will be created using the product name.', max_length=255, null=True, verbose_name='slug'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='status_text',
            field=models.CharField(blank=True, help_text='This text will be shown alongside the product in the shop. It is useful for informing customers of special stock numbers or preorders. (Ex.: "Available in a month")', max_length=128, verbose_name='status text'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='variation_name',
            field=models.CharField(blank=True, help_text='You can enter a name for the variation of your product. This could be for example different colors or versions.', max_length=128, verbose_name='variation name'),
        ),
        migrations.AlterField(
            model_name='producttype',
            name='attributes',
            field=models.ManyToManyField(blank=True, help_text='Select attributes that go with your product type. These are defined in Products Settings – Attributes.', related_name='product_types', to='shuup.Attribute', verbose_name='attributes'),
        ),
        migrations.AlterField(
            model_name='producttypetranslation',
            name='name',
            field=models.CharField(help_text='Enter a descriptive name for your product type. Products and attributes for products of this type can be found under this name.', max_length=64, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='salesunit',
            name='decimals',
            field=models.PositiveSmallIntegerField(default=0, help_text='The number of decimal places allowed by this sales unit.Set this to a value greater than zero if products with this sales unit can be sold in fractional quantities', verbose_name='allowed decimal places'),
        ),
        migrations.AlterField(
            model_name='salesunittranslation',
            name='name',
            field=models.CharField(help_text="The sales unit name to use for products (For example, 'pieces' or 'units'). Sales units can be set for each product through the product editor view.", max_length=128, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='salesunittranslation',
            name='symbol',
            field=models.CharField(help_text='An abbreviated name for this sales unit that is shown throughout admin and order invoices.', max_length=128, verbose_name='symbol'),
        ),
        migrations.AlterField(
            model_name='serviceprovider',
            name='enabled',
            field=models.BooleanField(default=True, help_text='Check this if this service provider can be used when placing orders', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='serviceprovidertranslation',
            name='name',
            field=models.CharField(help_text='The service provider name.', max_length=100, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='shippingmethod',
            name='enabled',
            field=models.BooleanField(default=False, help_text='Check this if this service is selectable on checkout.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='shippingmethod',
            name='shop',
            field=models.ForeignKey(help_text='The shop for this service.', on_delete=django.db.models.deletion.CASCADE, to='shuup.Shop', verbose_name='shop'),
        ),
        migrations.AlterField(
            model_name='shippingmethod',
            name='tax_class',
            field=models.ForeignKey(help_text='The tax class to use for this service. Tax classes are defined in Settings - Tax Classes.', on_delete=django.db.models.deletion.PROTECT, to='shuup.TaxClass', verbose_name='tax class'),
        ),
        migrations.AlterField(
            model_name='shippingmethodtranslation',
            name='name',
            field=models.CharField(help_text='The shipping method name. This name is shown to customers on checkout.', max_length=100, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='created_on',
            field=models.DateTimeField(auto_now_add=True, verbose_name='created on'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='currency',
            field=shuup.core.fields.CurrencyField(default=shuup.core.models._shops._get_default_currency, help_text='The primary shop currency. This is the currency used when selling your products.', max_length=4, verbose_name='currency'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='domain',
            field=models.CharField(blank=True, help_text='Your shop domain name. Use this field to configure the URL that is used to visit your site. Note: this requires additional configuration through your internet domain registrar.', max_length=128, null=True, unique=True, verbose_name='domain'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='favicon',
            field=filer.fields.image.FilerImageField(blank=True, help_text='Shop favicon. Will be shown next to the address on browser.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='shop_favicons', to='filer.Image', verbose_name='favicon'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='logo',
            field=filer.fields.image.FilerImageField(blank=True, help_text='Shop logo. Will be shown at theme.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='shop_logos', to='filer.Image', verbose_name='logo'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='maintenance_mode',
            field=models.BooleanField(default=False, help_text='Check this if you would like to make your shop temporarily unavailable while you do some shop maintenance.', verbose_name='maintenance mode'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='prices_include_tax',
            field=models.BooleanField(default=True, help_text='This option defines whether product prices entered in admin include taxes. Note this behavior can be overridden with contact group pricing.', verbose_name='prices include tax'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='staff_members',
            field=models.ManyToManyField(blank=True, related_name='_shop_staff_members_+', to=settings.AUTH_USER_MODEL, verbose_name='staff members'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='status',
            field=enumfields.fields.EnumIntegerField(default=0, enum=shuup.core.models.ShopStatus, help_text='Your shop status. Disable your shop if it is no longer in use.', verbose_name='status'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='backorder_maximum',
            field=shuup.core.fields.QuantityField(blank=True, decimal_places=9, default=0, help_text='The number of units that can be purchased after the product is out of stock. Set to blank for product to be purchasable without limits.', max_digits=36, null=True, verbose_name='backorder maximum'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='categories',
            field=models.ManyToManyField(blank=True, help_text='Add secondary categories for your product. These are other categories that your product fits under and that it can be found by in your store.', related_name='shop_products', to='shuup.Category', verbose_name='categories'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='default_price_value',
            field=shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, help_text='This is the default individual base unit (or multi-pack) price of the product. All discounts or coupons will be based off of this price.', max_digits=36, null=True, verbose_name='default price'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='display_unit',
            field=models.ForeignKey(blank=True, help_text='Unit for displaying quantities of this product', null=True, on_delete=django.db.models.deletion.CASCADE, to='shuup.DisplayUnit', verbose_name='display unit'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='limit_payment_methods',
            field=models.BooleanField(default=False, help_text='Check this if you want to limit your product to use only select payment methods. You can select the payment method(s) in the field below.', verbose_name='limited for payment methods'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='limit_shipping_methods',
            field=models.BooleanField(default=False, help_text='Check this if you want to limit your product to use only select payment methods. You can select the payment method(s) in the field below.', verbose_name='limited for shipping methods'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='minimum_price_value',
            field=shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, help_text='This is the default price that the product cannot go under in your store, despite coupons or discounts being applied. This is useful to make sure your product price stays above cost.', max_digits=36, null=True, verbose_name='minimum price'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='minimum_purchase_quantity',
            field=shuup.core.fields.QuantityField(decimal_places=9, default=1, help_text='Set a minimum number of products needed to be ordered for the purchase. This is useful for setting bulk orders and B2B purchases.', max_digits=36, verbose_name='minimum purchase'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='payment_methods',
            field=models.ManyToManyField(blank=True, help_text='Select the payment methods you would like to limit the product to using. These are defined in Settings - Payment Methods.', related_name='payment_products', to='shuup.PaymentMethod', verbose_name='payment methods'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='primary_category',
            field=models.ForeignKey(blank=True, help_text='Choose the primary category for your product. This will be the main category for classification in the system. Your product can be found under this category in your store. Categories are defined in Products Settings - Categories.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='primary_shop_products', to='shuup.Category', verbose_name='primary category'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='purchase_multiple',
            field=shuup.core.fields.QuantityField(decimal_places=9, default=0, help_text='Set this if the product needs to be purchased in multiples. For example, if the purchase multiple is set to 2, then customers are required to order the product in multiples of 2.', max_digits=36, verbose_name='purchase multiple'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='shipping_methods',
            field=models.ManyToManyField(blank=True, help_text='Select the shipping methods you would like to limit the product to using. These are defined in Settings - Shipping Methods.', related_name='shipping_products', to='shuup.ShippingMethod', verbose_name='shipping methods'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='shop_primary_image',
            field=models.ForeignKey(blank=True, help_text='Click this to set this image as the primary display image for your product.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='primary_image_for_shop_products', to='shuup.ProductMedia', verbose_name='primary image'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='suppliers',
            field=models.ManyToManyField(blank=True, help_text='List your suppliers here. Suppliers can be found in Product Settings - Suppliers.', related_name='shop_products', to='shuup.Supplier', verbose_name='suppliers'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='visibility',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=3, enum=shuup.core.models.ShopProductVisibility, help_text='Select if you want your product to be seen and found by customers. <p>Not visible: Product will not be shown in your store front or found in search.</p><p>Searchable: Product will be shown in search but not listed on any category page.</p><p>Listed: Product will be shown on category pages but not shown in search results.</p><p>Always Visible: Product will be shown in your store front and found in search.</p>', verbose_name='visibility'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='visibility_groups',
            field=models.ManyToManyField(blank=True, help_text='Select the groups you would like to make your product visible for. These groups are defined in Contacts Settings - Contact Groups.', related_name='visible_products', to='shuup.ContactGroup', verbose_name='visible for groups'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='visibility_limit',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=1, enum=shuup.core.models.ProductVisibility, help_text='Select whether you want your product to have special limitations on its visibility in your store. You can make products visible to all, visible to only logged in users, or visible only to certain customer groups.', verbose_name='visibility limitations'),
        ),
        migrations.AlterField(
            model_name='shopproducttranslation',
            name='description',
            field=models.TextField(blank=True, help_text='To make your product stand out, give it an awesome description. This is what will help your shoppers learn about your products. It will also help shoppers find them in the store and on the web.', null=True, verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='shopproducttranslation',
            name='name',
            field=models.CharField(blank=True, help_text='Enter a descriptive name for your product. This will be its title in your store.', max_length=256, null=True, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='shopproducttranslation',
            name='short_description',
            field=models.CharField(blank=True, help_text='Enter a short description for your product. The short description will be used to get the attention of your customer with a small but precise description of your product.', max_length=150, null=True, verbose_name='short description'),
        ),
        migrations.AlterField(
            model_name='shoptranslation',
            name='maintenance_message',
            field=models.CharField(blank=True, help_text='The message to display to customers while your shop is in maintenance mode.', max_length=300, verbose_name='maintenance message'),
        ),
        migrations.AlterField(
            model_name='shoptranslation',
            name='name',
            field=models.CharField(help_text='The shop name. This name is displayed throughout admin.', max_length=64, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='shoptranslation',
            name='public_name',
            field=models.CharField(help_text='The public shop name. This name is displayed in the store front and in any customer email correspondence.', max_length=64, verbose_name='public name'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='module_identifier',
            field=models.CharField(blank=True, help_text='Select the supplier module to use for this supplier. Supplier modules define the rules by which inventory is managed.', max_length=64, verbose_name='module'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='name',
            field=models.CharField(help_text='The product suppliers name. Suppliers can be used manage the inventory of stocked products.', max_length=64, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='shops',
            field=models.ManyToManyField(blank=True, help_text='You can select which shops the supplier is available to.', related_name='suppliers', to='shuup.Shop', verbose_name='shops'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='stock_managed',
            field=models.BooleanField(default=False, help_text='Check this if this supplier will be used to manage the inventory of stocked products.', verbose_name='stock managed'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='type',
            field=enumfields.fields.EnumIntegerField(default=1, enum=shuup.core.models.SupplierType, help_text='The supplier type indicates whether the products are supplied through an internal supplier or an external supplier.', verbose_name='supplier type'),
        ),
        migrations.AlterField(
            model_name='tax',
            name='enabled',
            field=models.BooleanField(default=True, help_text='Check this if this tax is valid and active.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='taxclass',
            name='enabled',
            field=models.BooleanField(default=True, help_text='Check this if this tax class is active and valid.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='taxclasstranslation',
            name='name',
            field=models.CharField(help_text='The tax class name. Tax classes are used to control how taxes are applied to products.', max_length=100, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='taxtranslation',
            name='name',
            field=models.CharField(help_text='The tax name. This is shown in order lines in order invoices and confirmations.', max_length=124, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='waivingcostbehaviorcomponent',
            name='price_value',
            field=shuup.core.fields.MoneyValueField(decimal_places=9, help_text='The cost to apply to this service if the total price is below the waive limit.', max_digits=36),
        ),
        migrations.AlterField(
            model_name='waivingcostbehaviorcomponent',
            name='waive_limit_value',
            field=shuup.core.fields.MoneyValueField(decimal_places=9, help_text='The total price of products at which this service cost is waived.', max_digits=36),
        ),
        migrations.AlterField(
            model_name='waivingcostbehaviorcomponenttranslation',
            name='description',
            field=models.CharField(blank=True, help_text='The order line text to display when this behavior is applied.', max_length=100, verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='weightbasedpricerange',
            name='max_value',
            field=shuup.core.fields.MeasurementField(blank=True, decimal_places=9, default=0, help_text='The maximum weight, in grams, before this price no longer applies.', max_digits=36, null=True, unit='g', verbose_name='max weight (g)'),
        ),
        migrations.AlterField(
            model_name='weightbasedpricerange',
            name='min_value',
            field=shuup.core.fields.MeasurementField(blank=True, decimal_places=9, default=0, help_text='The minimum weight, in grams, for this price to apply.', max_digits=36, null=True, unit='g', verbose_name='min weight (g)'),
        ),
        migrations.AlterField(
            model_name='weightbasedpricerange',
            name='price_value',
            field=shuup.core.fields.MoneyValueField(decimal_places=9, help_text='The cost to apply to this service when the weight criteria is met.', max_digits=36),
        ),
        migrations.AlterField(
            model_name='weightbasedpricerangetranslation',
            name='description',
            field=models.CharField(blank=True, help_text='The order line text to display when this behavior is applied.', max_length=100, verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='weightlimitsbehaviorcomponent',
            name='max_weight',
            field=models.DecimalField(blank=True, decimal_places=6, help_text='The maximum weight allowed by this service.', max_digits=36, null=True, verbose_name='maximum weight'),
        ),
        migrations.AlterField(
            model_name='weightlimitsbehaviorcomponent',
            name='min_weight',
            field=models.DecimalField(blank=True, decimal_places=6, help_text='The minimum weight required for this service to be available.', max_digits=36, null=True, verbose_name='minimum weight'),
        ),
    ]
