# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2018-07-26 18:06
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion

def ensure_registration_shops(apps, schema_editor):
    Contact = apps.get_model("shuup", "Contact")
    Shop = apps.get_model("shuup", "Shop")
    for contact in Contact.objects.all():
        shop = contact.shops.first()
        if not shop:
            shop = Shop.objects.first()
        contact.registration_shop = shop
        contact.save()


class Migration(migrations.Migration):

    dependencies = [
        ('shuup', '0045_disable_default_marketing_permission'),
    ]

    operations = [
        migrations.AddField(
            model_name='contact',
            name='registration_shop',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='registrations', to='shuup.Shop', verbose_name='registration shop'),
        ),

        migrations.RunPython(ensure_registration_shops, migrations.RunPython.noop),
    ]
