# -*- coding: utf-8 -*-;
# Generated by Django 1.11.23 on 2020-01-29 09:38
from __future__ import unicode_literals

from decimal import Decimal
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields
import filer.fields.image
import shuup.core.fields
import shuup.core.models
import shuup.core.models._service_payment
import shuup.core.models._shops
import shuup.core.models._units


class Migration(migrations.Migration):

    dependencies = [
        ('shuup', '0067_supplier_name_max_length_to_128'),
    ]

    operations = [
        migrations.AlterField(
            model_name='attribute',
            name='searchable',
            field=models.BooleanField(default=True, help_text='Searchable attributes will be used for product lookup when customers search in your store.', verbose_name='searchable'),
        ),
        migrations.AlterField(
            model_name='category',
            name='image',
            field=filer.fields.image.FilerImageField(blank=True, help_text='Category image. Will be shown in places defined by the graphical theme in use.', null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.FILER_IMAGE_MODEL, verbose_name='image'),
        ),
        migrations.AlterField(
            model_name='category',
            name='ordering',
            field=models.IntegerField(default=0, help_text='You can assign numerical values to images to tell the order in which they shall be displayed on the vendor page. You can also use the `Organize` button in the list view to order them visually with a drag-and-drop.', verbose_name='ordering'),
        ),
        migrations.AlterField(
            model_name='category',
            name='status',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=1, enum=shuup.core.models.CategoryStatus, help_text='Choose if you want this category to be visible in your store.', verbose_name='status'),
        ),
        migrations.AlterField(
            model_name='category',
            name='visibility',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=1, enum=shuup.core.models.CategoryVisibility, help_text='You can choose to limit who sees your category based on whether they are logged in or if they are part of a certain customer group.', verbose_name='visibility limitations'),
        ),
        migrations.AlterField(
            model_name='category',
            name='visibility_groups',
            field=models.ManyToManyField(blank=True, help_text='Select the customer groups you want to see this category. There are three groups created by default: Company, Person, Anonymous. In addition you can also define custom groups by searching for `Contact Groups`.', related_name='visible_categories', to='shuup.ContactGroup', verbose_name='visible for groups'),
        ),
        migrations.AlterField(
            model_name='category',
            name='visible_in_menu',
            field=models.BooleanField(default=True, help_text="Enable if this category should be visible in the store front's menu.", verbose_name='visible in menu'),
        ),
        migrations.AlterField(
            model_name='categorytranslation',
            name='name',
            field=models.CharField(db_index=True, help_text='Enter a descriptive name for your product category. Products can be found in the store front under the defined product category either directly in menus or while searching.', max_length=128, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='categorytranslation',
            name='slug',
            field=models.SlugField(blank=True, help_text='Enter a URL slug for your category. Slug is user- and search engine-friendly short text used in a URL to identify and describe a resource. In this case it will determine what your product category page URL in the browser address bar will look like. A default will be created using the category name.', null=True, verbose_name='slug'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='is_active',
            field=models.BooleanField(db_index=True, default=True, help_text='Enable this if the contact is an active customer.', verbose_name='active'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='marketing_permission',
            field=models.BooleanField(default=False, help_text='Enable this if the contact can receive marketing and promotional materials.', verbose_name='marketing permission'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='tax_group',
            field=models.ForeignKey(blank=True, help_text="Select the contact tax group to use for this contact. Tax groups can be used to customize the tax rules the that apply to any of this contact's orders. Tax groups are defined in `Customer Tax Groups` and can be applied to tax rules in `Tax Rules`.", null=True, on_delete=django.db.models.deletion.PROTECT, to='shuup.CustomerTaxGroup', verbose_name='tax group'),
        ),
        migrations.AlterField(
            model_name='contactgrouptranslation',
            name='name',
            field=models.CharField(help_text='The contact group name. Contact groups can be used to target sales and campaigns to a specific set of users.', max_length=256, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='custompaymentprocessor',
            name='rounding_mode',
            field=enumfields.fields.EnumField(default='ROUND_HALF_UP', enum=shuup.core.models._service_payment.RoundingMode, help_text='Choose rounding mode for cash payment.', max_length=50, verbose_name='rounding mode'),
        ),
        migrations.AlterField(
            model_name='custompaymentprocessor',
            name='rounding_quantize',
            field=models.DecimalField(decimal_places=9, default=Decimal('0.05'), help_text='Choose rounding quantize (precision) for cash payment.', max_digits=36, verbose_name='rounding quantize'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='allow_bare_number',
            field=models.BooleanField(default=False, help_text="If true, values of this unit can occasionally be shown without the symbol attached to it. E.g. if the unit is a `piece`, then you might want for the product listings to only show '$5.95' rather than '$5.95 per pc.'.", verbose_name='allow bare number'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='comparison_value',
            field=shuup.core.fields.QuantityField(decimal_places=9, default=1, help_text='Value to use when displaying unit prices. E.g. if the display unit is a gram and the comparison value is 100, then unit prices are shown per 100g, like: $2.95 per 100g.', max_digits=36, validators=[shuup.core.models._units.validate_positive_not_zero], verbose_name='comparison value'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='decimals',
            field=models.PositiveSmallIntegerField(default=0, help_text='The number of decimal places to use for values in the display unit. The internal values are still rounded based on the settings of the internal unit.', verbose_name='decimal places'),
        ),
        migrations.AlterField(
            model_name='displayunit',
            name='ratio',
            field=shuup.core.fields.QuantityField(decimal_places=9, default=1, help_text='Size of the display unit in internal unit. E.g. if internal unit is kilogram and display unit is gram, ratio is 0.001.', max_digits=36, validators=[shuup.core.models._units.validate_positive_not_zero], verbose_name='ratio'),
        ),
        migrations.AlterField(
            model_name='displayunittranslation',
            name='name',
            field=models.CharField(help_text='Name of the display unit, e.g. grams.', max_length=150, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='immutableaddress',
            name='tax_number',
            field=models.CharField(blank=True, help_text='The business tax number. For example, EIN in the USA or VAT code in the EU.', max_length=64, verbose_name='tax number'),
        ),
        migrations.AlterField(
            model_name='manufacturer',
            name='name',
            field=models.CharField(help_text='Enter the manufacturer’s name. Products can be filtered by the manufacturer and this can be useful for inventory and stock management.', max_length=128, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='mutableaddress',
            name='tax_number',
            field=models.CharField(blank=True, help_text='The business tax number. For example, EIN in the USA or VAT code in the EU.', max_length=64, verbose_name='tax number'),
        ),
        migrations.AlterField(
            model_name='orderlinetax',
            name='base_amount_value',
            field=shuup.core.fields.MoneyValueField(decimal_places=9, help_text='Amount that this tax is calculated from.', max_digits=36, verbose_name='base amount'),
        ),
        migrations.AlterField(
            model_name='orderstatus',
            name='default',
            field=models.BooleanField(db_index=True, default=False, help_text='Defines if the status should be considered as default. Default is always processed first.', verbose_name='default'),
        ),
        migrations.AlterField(
            model_name='orderstatus',
            name='is_active',
            field=models.BooleanField(db_index=True, default=True, help_text='Defines if the status is usable.', verbose_name='is active'),
        ),
        migrations.AlterField(
            model_name='orderstatus',
            name='role',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=0, enum=shuup.core.models.OrderStatusRole, help_text='The role of this status. One role can have multiple order statuses.', verbose_name='role'),
        ),
        migrations.AlterField(
            model_name='orderstatustranslation',
            name='name',
            field=models.CharField(help_text='Name of the order status.', max_length=64, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='orderstatustranslation',
            name='public_name',
            field=models.CharField(help_text='The name shown to the customers in shop front.', max_length=64, verbose_name='public name'),
        ),
        migrations.AlterField(
            model_name='paymentmethod',
            name='enabled',
            field=models.BooleanField(default=False, help_text='Enable this if this service should be selectable on checkout.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='paymentmethod',
            name='tax_class',
            field=models.ForeignKey(help_text='The tax class to use for this service. Define by searching for `Tax Classes`.', on_delete=django.db.models.deletion.PROTECT, to='shuup.TaxClass', verbose_name='tax class'),
        ),
        migrations.AlterField(
            model_name='paymentmethodtranslation',
            name='description',
            field=models.CharField(blank=True, help_text='The description of the payment method. This description is shown to the customers on checkout.', max_length=500, verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='paymentmethodtranslation',
            name='name',
            field=models.CharField(help_text='The payment method name. This name is shown to the customers on checkout.', max_length=100, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='product',
            name='depth',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text='Set the measured depth or length (in millimeters) of your product or product packaging. This will provide customers with the product size and help with calculating shipping costs.', max_digits=36, unit='mm', verbose_name='depth (mm)'),
        ),
        migrations.AlterField(
            model_name='product',
            name='gross_weight',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text='Set the measured gross weight (in grams) of your product WITH its packaging. This will help with calculating shipping costs.', max_digits=36, unit='g', verbose_name='gross weight (g)'),
        ),
        migrations.AlterField(
            model_name='product',
            name='height',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text='Set the measured height (in millimeters) of your product or product packaging. This will provide customers with the product size and help with calculating shipping costs.', max_digits=36, unit='mm', verbose_name='height (mm)'),
        ),
        migrations.AlterField(
            model_name='product',
            name='manufacturer',
            field=models.ForeignKey(blank=True, help_text='Select a manufacturer for your product. To define these, search for `Manufacturers`.', null=True, on_delete=django.db.models.deletion.PROTECT, to='shuup.Manufacturer', verbose_name='manufacturer'),
        ),
        migrations.AlterField(
            model_name='product',
            name='net_weight',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text="Set the measured weight (in grams) of your product WITHOUT its packaging. This will provide customers with the actual product's weight.", max_digits=36, unit='g', verbose_name='net weight (g)'),
        ),
        migrations.AlterField(
            model_name='product',
            name='sales_unit',
            field=models.ForeignKey(blank=True, help_text='Select a sales unit for your product. This is shown in your store front and is used to determine whether the product can be purchased using fractional amounts. To change settings search for `Sales Units`.', null=True, on_delete=django.db.models.deletion.PROTECT, to='shuup.SalesUnit', verbose_name='sales unit'),
        ),
        migrations.AlterField(
            model_name='product',
            name='shipping_mode',
            field=enumfields.fields.EnumIntegerField(default=1, enum=shuup.core.models.ShippingMode, help_text='Set to `shipped` if the product requires shipment.', verbose_name='shipping mode'),
        ),
        migrations.AlterField(
            model_name='product',
            name='sku',
            field=models.CharField(db_index=True, help_text="Enter a SKU (Stock Keeping Unit) number for your product. This is a product identification code that helps you track products through your inventory and analyze their movement. People often use the product's barcode number, but you can set up any numerical system you want to keep track of products.", max_length=128, unique=True, verbose_name='SKU'),
        ),
        migrations.AlterField(
            model_name='product',
            name='tax_class',
            field=models.ForeignKey(help_text='Select a tax class for your product. The tax class is used to determine which taxes to apply to your product. Define tax classes by searching for `Tax Classes`. To define the rules by which taxes are applied search for `Tax Rules`.', on_delete=django.db.models.deletion.PROTECT, to='shuup.TaxClass', verbose_name='tax class'),
        ),
        migrations.AlterField(
            model_name='product',
            name='width',
            field=shuup.core.fields.MeasurementField(decimal_places=9, default=0, help_text='Set the measured width (in millimeters) of your product or product packaging. This will provide customers with the product size and help with calculating shipping costs.', max_digits=36, unit='mm', verbose_name='width (mm)'),
        ),
        migrations.AlterField(
            model_name='productmedia',
            name='ordering',
            field=models.IntegerField(default=0, help_text='You can assign numerical values to images to tell the order in which they shall be displayed on the product page.', verbose_name='ordering'),
        ),
        migrations.AlterField(
            model_name='productmedia',
            name='public',
            field=models.BooleanField(default=True, help_text='Enable this if you want this image be shown on the product page. Enabled by default.', verbose_name='public (shown on product page)'),
        ),
        migrations.AlterField(
            model_name='productmedia',
            name='purchased',
            field=models.BooleanField(default=False, help_text='Enable this if you want the product media to be shown for completed purchases.', verbose_name='purchased (shown for finished purchases)'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='name',
            field=models.CharField(db_index=True, help_text='Enter a descriptive name for your product. This will be its title in your store front.', max_length=256, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='short_description',
            field=models.CharField(blank=True, help_text='Enter a short description for your product. The short description will be used to get the attention of your customer with a small, but precise description of your product. It also helps with getting more traffic via search engines.', max_length=150, verbose_name='short description'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='slug',
            field=models.SlugField(blank=True, help_text='Enter a URL slug for your product. Slug is user- and search engine-friendly short text used in a URL to identify and describe a resource. In this case it will determine what your product page URL in the browser address bar will look like. A default will be created using the product name.', max_length=255, null=True, verbose_name='slug'),
        ),
        migrations.AlterField(
            model_name='producttranslation',
            name='variation_name',
            field=models.CharField(blank=True, help_text='You can enter a name for the variation of your product. This could be for example different colors, sizes or versions. To manage variations, at the top of the the individual product page, click `Actions` -> `Manage Variations`.', max_length=128, verbose_name='variation name'),
        ),
        migrations.AlterField(
            model_name='producttype',
            name='attributes',
            field=models.ManyToManyField(blank=True, help_text='Select attributes that go with your product type. To change available attributes search for `Attributes`.', related_name='product_types', to='shuup.Attribute', verbose_name='attributes'),
        ),
        migrations.AlterField(
            model_name='salesunit',
            name='decimals',
            field=models.PositiveSmallIntegerField(default=0, help_text='The number of decimal places allowed by this sales unit.Set this to a value greater than zero if products with this sales unit can be sold in fractional quantities.', verbose_name='allowed decimal places'),
        ),
        migrations.AlterField(
            model_name='salesunittranslation',
            name='name',
            field=models.CharField(help_text="The sales unit name to use for products (e.g. 'pieces' or 'units'). Sales units can be set individually for each product through the product editor view.", max_length=128, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='salesunittranslation',
            name='symbol',
            field=models.CharField(help_text='An abbreviated name for this sales unit that is shown throughout admin and order invoices.', max_length=128, verbose_name='unit symbol'),
        ),
        migrations.AlterField(
            model_name='serviceprovider',
            name='enabled',
            field=models.BooleanField(default=True, help_text='Enable this if this service provider can be used when placing orders.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='shippingmethod',
            name='enabled',
            field=models.BooleanField(default=False, help_text='Enable this if this service should be selectable on checkout.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='shippingmethod',
            name='tax_class',
            field=models.ForeignKey(help_text='The tax class to use for this service. Define by searching for `Tax Classes`.', on_delete=django.db.models.deletion.PROTECT, to='shuup.TaxClass', verbose_name='tax class'),
        ),
        migrations.AlterField(
            model_name='shippingmethodtranslation',
            name='name',
            field=models.CharField(help_text='The shipping method name. This name is shown to the customers on checkout.', max_length=100, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='currency',
            field=shuup.core.fields.CurrencyField(default=shuup.core.models._shops._get_default_currency, help_text='The primary shop currency. This is the currency used when selling the products.', max_length=4, verbose_name='currency'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='domain',
            field=models.CharField(blank=True, help_text='Your shop domain name. Use this field to configure the URL that is used to visit your store front. Note: this requires additional configuration through your internet domain registrar.', max_length=128, null=True, unique=True, verbose_name='domain'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='favicon',
            field=filer.fields.image.FilerImageField(blank=True, help_text="Shop's favicon - a mini-image graphically representing your shop. Depending on the browser, it will be shown next to the address bar and/or on the website title tab.", null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='shop_favicons', to=settings.FILER_IMAGE_MODEL, verbose_name='favicon'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='logo',
            field=filer.fields.image.FilerImageField(blank=True, help_text="Shop's logo. Will be shown at theme.", null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='shop_logos', to=settings.FILER_IMAGE_MODEL, verbose_name='logo'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='maintenance_mode',
            field=models.BooleanField(default=False, help_text="Enable if you want to make your shop temporarily unavailable to visitors while you do shop maintenance or for some other reason. If you don't plan to have this shop open again, change the `Status` on the main `General Information` tab to `Disabled`.", verbose_name='maintenance mode'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='prices_include_tax',
            field=models.BooleanField(default=True, help_text='This option defines whether product prices entered in admin include taxes. Note: this behavior can be overridden with contact group pricing.', verbose_name='prices include tax'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='status',
            field=enumfields.fields.EnumIntegerField(default=0, enum=shuup.core.models.ShopStatus, help_text="Your shop's status. Disable your shop if it's no longer in use. For temporary closing enable the maintenance mode, available in the `Maintenance Mode` tab on the left.", verbose_name='status'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='available_until',
            field=models.DateTimeField(blank=True, help_text='After this date this product will be invisible in store front.', null=True, verbose_name='available until'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='backorder_maximum',
            field=shuup.core.fields.QuantityField(blank=True, decimal_places=9, default=0, help_text='The number of units that can be purchased after the product is already sold out (out of stock). Set to blank for product to be purchasable without limits.', max_digits=36, null=True, verbose_name='backorder maximum'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='default_price_value',
            field=shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, help_text='This is the default individual base unit (or multi-pack) price of the product. All discounts or coupons will be calculated based off of this price.', max_digits=36, null=True, verbose_name='default price'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='display_unit',
            field=models.ForeignKey(blank=True, help_text='Unit for displaying quantities of this product.', null=True, on_delete=django.db.models.deletion.CASCADE, to='shuup.DisplayUnit', verbose_name='display unit'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='limit_payment_methods',
            field=models.BooleanField(default=False, help_text='Enable this if you want to limit your product to use only the select payment methods. You can select the allowed payment method(s) in the field below - all the rest are disallowed.', verbose_name='limit the payment methods'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='limit_shipping_methods',
            field=models.BooleanField(default=False, help_text='Enable this if you want to limit your product to use only the select payment methods. You can select the allowed payment method(s) in the field below - all the rest are disallowed.', verbose_name='limit the shipping methods'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='minimum_price_value',
            field=shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, help_text='This is the default price that the product cannot go under in your store, despite coupons or discounts being applied. This is useful to make sure your product price stays above the cost.', max_digits=36, null=True, verbose_name='minimum price'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='minimum_purchase_quantity',
            field=shuup.core.fields.QuantityField(decimal_places=9, default=1, help_text='Set a minimum number of products needed to be ordered for the purchase. This is useful for setting bulk orders and B2B purchases.', max_digits=36, verbose_name='minimum purchase quantity'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='payment_methods',
            field=models.ManyToManyField(blank=True, help_text='If you enabled the `Limit the payment methods` choice above, then here you can select the individuals payment methods you want to ALLOW for this product. The ones not mentioned are disabled. To change this, search for `Payment Methods`.', related_name='payment_products', to='shuup.PaymentMethod', verbose_name='payment methods'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='primary_category',
            field=models.ForeignKey(blank=True, help_text='Choose the primary category for the product. This will be the main category for classification in the system. The product will be found under this category in your store. To change this, search for `Categories`.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='primary_shop_products', to='shuup.Category', verbose_name='primary category'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='purchase_multiple',
            field=shuup.core.fields.QuantityField(decimal_places=9, default=0, help_text='Set this to other than 0 if the product needs to be purchased in multiples. For example, if the purchase multiple is set to 2, then customers are required to order the product in multiples of 2. Not to be confused with the Minimum Purchase Quantity.', max_digits=36, verbose_name='purchase multiple'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='shipping_methods',
            field=models.ManyToManyField(blank=True, help_text='If you enabled the `Limit the payment methods` choice above, then here you can select the individual shipping methods you want to ALLOW for this product. The ones not mentioned are disabled. To change this, search for `Shipping Methods`.', related_name='shipping_products', to='shuup.ShippingMethod', verbose_name='shipping methods'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='shop_primary_image',
            field=models.ForeignKey(blank=True, help_text='Click this to set this image as the primary display image for the product.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='primary_image_for_shop_products', to='shuup.ProductMedia', verbose_name='primary image'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='suppliers',
            field=models.ManyToManyField(blank=True, help_text='List your suppliers here. Suppliers can be found by searching for `Suppliers`.', related_name='shop_products', to='shuup.Supplier', verbose_name='suppliers'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='visibility',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=3, enum=shuup.core.models.ShopProductVisibility, help_text='Choose how you want your product to be seen and found by the customers. <p>Not visible: Product will not be shown in your store front nor found in search.</p><p>Searchable: Product will be shown in search, but not listed on any category page.</p><p>Listed: Product will be shown on category pages, but not shown in search results.</p><p>Always Visible: Product will be shown in your store front and found in search.</p>', verbose_name='visibility'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='visibility_groups',
            field=models.ManyToManyField(blank=True, help_text='Select the groups you want to make your product visible for. These groups are defined in Contacts Settings - Contact Groups.', related_name='visible_products', to='shuup.ContactGroup', verbose_name='visible for groups'),
        ),
        migrations.AlterField(
            model_name='shopproduct',
            name='visibility_limit',
            field=enumfields.fields.EnumIntegerField(db_index=True, default=1, enum=shuup.core.models.ProductVisibility, help_text='Select whether you want your product to have special limitations on its visibility in your store. You can make products visible to all, visible to only logged-in users, or visible only to certain customer groups.', verbose_name='visibility limitations'),
        ),
        migrations.AlterField(
            model_name='shopproducttranslation',
            name='description',
            field=models.TextField(blank=True, help_text='To make your product stands out, give it an awesome description. This is what will help your shoppers learn about your products. It will also help shoppers find them in the store and on the web.', null=True, verbose_name='description'),
        ),
        migrations.AlterField(
            model_name='shopproducttranslation',
            name='name',
            field=models.CharField(blank=True, help_text='Enter a descriptive name for your product. This will be its title in your store front.', max_length=256, null=True, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='shopproducttranslation',
            name='short_description',
            field=models.CharField(blank=True, help_text='Enter a short description for your product. The short description will be used to get the attention of your customer with a small, but precise description of your product. It also helps with getting more traffic via search engines.', max_length=150, null=True, verbose_name='short description'),
        ),
        migrations.AlterField(
            model_name='shoptranslation',
            name='maintenance_message',
            field=models.CharField(blank=True, help_text='The message to display to customers while your shop is in a maintenance mode.', max_length=300, verbose_name='maintenance message'),
        ),
        migrations.AlterField(
            model_name='shoptranslation',
            name='name',
            field=models.CharField(help_text='The shop name. This name is displayed throughout Admin Panel.', max_length=64, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='shoptranslation',
            name='short_description',
            field=models.CharField(blank=True, help_text='Enter a short description for your shop. The short description will be used to get the attention of your customer with a small, but precise description of your shop. It also helps with getting more traffic via search engines.', max_length=150, verbose_name='short description'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='enabled',
            field=models.BooleanField(default=True, help_text='Indicates whether this supplier is currently enabled. In order to participate fully, the supplier also needs to be `Approved`.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='is_approved',
            field=models.BooleanField(default=True, help_text='Indicates whether this supplier is currently approved for work. In order to participate fully, the supplier also needs to be `Enabled`.', verbose_name='approved'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='name',
            field=models.CharField(db_index=True, help_text="The product supplier's name. You can enable suppliers to manage the inventory of stocked products.", max_length=128, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='shops',
            field=models.ManyToManyField(blank=True, help_text='You can select which particular shops fronts the supplier should be available in.', related_name='suppliers', to='shuup.Shop', verbose_name='shops'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='slug',
            field=models.SlugField(blank=True, help_text='Enter a URL slug for your supplier. Slug is user- and search engine-friendly short text used in a URL to identify and describe a resource. In this case it will determine what your supplier page URL in the browser address bar will look like. A default will be created using the supplier name.', max_length=255, null=True, verbose_name='slug'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='stock_managed',
            field=models.BooleanField(default=False, help_text='Enable this if this supplier will manage the inventory of the stocked products. Having a managed stock enabled is unnecessary if e.g. selling digital products that will never run out no matter how many are being sold. There are some other cases when it could be an unnecessary complication. This settingmerely assigns a sensible default behavior, which can be overwritten on a product-by-product basis.', verbose_name='stock managed'),
        ),
        migrations.AlterField(
            model_name='supplier',
            name='type',
            field=enumfields.fields.EnumIntegerField(default=1, enum=shuup.core.models.SupplierType, help_text='The supplier type indicates whether the products are supplied through an internal supplier or an external supplier, and which group this supplier belongs to.', verbose_name='supplier type'),
        ),
        migrations.AlterField(
            model_name='tax',
            name='amount_value',
            field=shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, default=None, help_text='The flat amount of the tax. Mutually exclusive with percentage rates tax.', max_digits=36, null=True, verbose_name='tax amount value'),
        ),
        migrations.AlterField(
            model_name='tax',
            name='currency',
            field=shuup.core.fields.CurrencyField(blank=True, default=None, max_length=4, null=True, verbose_name='currency of the amount tax'),
        ),
        migrations.AlterField(
            model_name='tax',
            name='enabled',
            field=models.BooleanField(default=True, help_text='Enable if this tax is valid and should be active.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='tax',
            name='rate',
            field=models.DecimalField(blank=True, decimal_places=5, help_text='The percentage rate of the tax. Mutually exclusive with the flat amount tax (flat tax is rarely used and the option is therefore hidden by default; contact Shuup to enable).', max_digits=6, null=True, verbose_name='tax rate'),
        ),
        migrations.AlterField(
            model_name='taxclass',
            name='enabled',
            field=models.BooleanField(default=True, help_text='Enable if this tax class is valid and should be active.', verbose_name='enabled'),
        ),
        migrations.AlterField(
            model_name='taxclasstranslation',
            name='name',
            field=models.CharField(help_text='The tax class name. Tax classes are used to control how taxes are applied to the products.', max_length=100, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='taxtranslation',
            name='name',
            field=models.CharField(help_text='The name of the tax. It is shown in order lines, in order invoices and confirmations.', max_length=124, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='waivingcostbehaviorcomponent',
            name='waive_limit_value',
            field=shuup.core.fields.MoneyValueField(decimal_places=9, help_text='The total price of products limit, at which this service cost is waived.', max_digits=36),
        ),
        migrations.AlterField(
            model_name='weightbasedpricerange',
            name='max_value',
            field=shuup.core.fields.MeasurementField(blank=True, decimal_places=9, default=0, help_text='The maximum weight (grams) before this price no longer applies.', max_digits=36, null=True, unit='g', verbose_name='max weight (g)'),
        ),
        migrations.AlterField(
            model_name='weightbasedpricerange',
            name='min_value',
            field=shuup.core.fields.MeasurementField(blank=True, decimal_places=9, default=0, help_text='The minimum weight (grams) for this price to apply.', max_digits=36, null=True, unit='g', verbose_name='min weight (g)'),
        ),
        migrations.AlterField(
            model_name='shop',
            name='maintenance_mode',
            field=models.BooleanField(default=False, help_text="Enable if you want to make your shop temporarily unavailable to visitors while you do regular shop maintenance, fight the security breach or for some other reason. If you don't plan to have this shop open again, change the `Status` on the main `General Information` tab to `Disabled`.", verbose_name='maintenance mode'),
        ),
    ]
