# -*- coding: utf-8 -*-
# Generated by Django 1.11.14 on 2018-08-14 19:48
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import shuup.core.fields
import shuup.utils.properties


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('shuup', '0048_contactgroup_pricedisplay'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AvailabilityException',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name for this exception. Used internally with exception lists for filtering.', max_length=120, verbose_name='name')),
                ('start_datetime', models.DateTimeField(verbose_name='start')),
                ('end_datetime', models.DateTimeField(verbose_name='end')),
                ('shops', models.ManyToManyField(blank=True, to='shuup.Shop', verbose_name='shops')),
            ],
            options={
                'verbose_name': 'availability exception',
                'verbose_name_plural': 'availability exceptions',
                'ordering': ['start_datetime'],
            },
        ),
        migrations.CreateModel(
            name='CouponCode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=12)),
                ('usage_limit_customer', models.PositiveIntegerField(blank=True, help_text='Limit the amount of usages per a single customer.', null=True, verbose_name='usage limit per customer')),
                ('usage_limit', models.PositiveIntegerField(blank=True, help_text='Set the absolute limit of usages for this coupon. If the limit is zero (0) coupon cannot be used.', null=True, verbose_name='usage limit')),
                ('active', models.BooleanField(default=True, verbose_name='active')),
                ('created_on', models.DateTimeField(auto_now_add=True, verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, verbose_name='modified on')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='created by')),
                ('modified_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
                ('shops', models.ManyToManyField(blank=True, to='shuup.Shop', verbose_name='shops')),
            ],
        ),
        migrations.CreateModel(
            name='CouponUsage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, verbose_name='created on')),
                ('coupon', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='usages', to='discounts.CouponCode')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='discounts_coupon_usages', to='shuup.Order')),
            ],
        ),
        migrations.CreateModel(
            name='Discount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, help_text='The name for this discount. Used internally with discount lists for filtering.', max_length=120, null=True, verbose_name='name')),
                ('identifier', shuup.core.fields.InternalIdentifierField(blank=True, editable=False, max_length=64, null=True, unique=True)),
                ('created_on', models.DateTimeField(auto_now_add=True, verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, verbose_name='modified on')),
                ('active', models.BooleanField(default=True, help_text='Check this if the discount is currently active. Please also set a start and end date.', verbose_name='active')),
                ('start_datetime', models.DateTimeField(blank=True, help_text='The date and time the discount starts. This is only applicable if the discount is marked as active.', null=True, verbose_name='start date and time')),
                ('end_datetime', models.DateTimeField(blank=True, help_text='The date and time the discount ends. This is only applicable if the discount is marked as active.', null=True, verbose_name='end date and time')),
                ('exclude_selected_category', models.BooleanField(default=False, help_text='Exclude products in selected category from this discount.', verbose_name='exclude selected category')),
                ('exclude_selected_contact_group', models.BooleanField(default=False, help_text='Exclude contacts in selected contact group from this discount.', verbose_name='exclude selected contact group')),
                ('discounted_price_value', shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, help_text='Discounted product price for this discount.', max_digits=36, null=True, verbose_name='discounted price')),
                ('discount_amount_value', shuup.core.fields.MoneyValueField(blank=True, decimal_places=9, help_text='Discount amount value for this discount.', max_digits=36, null=True, verbose_name='discount amount')),
                ('discount_percentage', models.DecimalField(blank=True, decimal_places=5, help_text='Discount percentage for this discount.', max_digits=6, null=True, verbose_name='discount percentage')),
                ('availability_exceptions', models.ManyToManyField(blank=True, help_text='Select availability for this discount.', related_name='discounts', to='discounts.AvailabilityException', verbose_name='availability exceptions')),
                ('category', models.ForeignKey(blank=True, help_text='Select category for this discount.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='category_discounts', to='shuup.Category', verbose_name='category')),
                ('contact', models.ForeignKey(blank=True, help_text='Select contact for this discount.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contact_discounts', to='shuup.Contact', verbose_name='contact')),
                ('contact_group', models.ForeignKey(blank=True, help_text='Select contact group for this discount.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contact_group_discounts', to='shuup.ContactGroup', verbose_name='contact group')),
                ('coupon_code', models.ForeignKey(blank=True, help_text='Select coupon code for this discount.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coupon_code_discounts', to='discounts.CouponCode', verbose_name='coupon code')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='created by')),
            ],
            options={
                'verbose_name': 'product discount',
                'verbose_name_plural': 'product discounts',
            },
            bases=(models.Model, shuup.utils.properties.MoneyPropped),
        ),
        migrations.CreateModel(
            name='HappyHour',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name for this . Used internally with exception lists for filtering.', max_length=120, verbose_name='name')),
                ('shops', models.ManyToManyField(blank=True, db_index=True, to='shuup.Shop', verbose_name='shops')),
            ],
            options={
                'verbose_name': 'happy hour',
                'verbose_name_plural': 'happy hours',
            },
        ),
        migrations.CreateModel(
            name='TimeRange',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_hour', models.TimeField(db_index=True, verbose_name='from hour')),
                ('to_hour', models.TimeField(db_index=True, verbose_name='to hour')),
                ('weekday', models.IntegerField(db_index=True, verbose_name='weekday')),
                ('happy_hour', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='time_ranges', to='discounts.HappyHour', verbose_name='happy hour')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='discounts.TimeRange', verbose_name='parent')),
            ],
            options={
                'verbose_name': 'time range',
                'verbose_name_plural': 'time ranges',
                'ordering': ['weekday', 'from_hour'],
            },
        ),
        migrations.AddField(
            model_name='discount',
            name='happy_hours',
            field=models.ManyToManyField(blank=True, help_text='Select happy hours for this discount.', related_name='discounts', to='discounts.HappyHour', verbose_name='happy hours'),
        ),
        migrations.AddField(
            model_name='discount',
            name='modified_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='modified by'),
        ),
        migrations.AddField(
            model_name='discount',
            name='product',
            field=models.ForeignKey(blank=True, help_text='Select product for this discount.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='product_discounts', to='shuup.Product', verbose_name='product'),
        ),
        migrations.AddField(
            model_name='discount',
            name='shops',
            field=models.ManyToManyField(blank=True, to='shuup.Shop', verbose_name='shops'),
        ),
    ]
