# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2018-05-09 01:13
from __future__ import unicode_literals

from django.db import migrations, models


def add_shop_for_carousels(apps, schema_editor):
    Shop = apps.get_model("shuup", "Shop")
    Carousel = apps.get_model("carousel", "Carousel")
    shop = Shop.objects.first()
    for carousel in Carousel.objects.all():
        carousel.shops.set([shop])


class Migration(migrations.Migration):

    dependencies = [
        ('carousel', '0002_alter_names'),
    ]

    operations = [
        migrations.AddField(
            model_name='carousel',
            name='shops',
            field=models.ManyToManyField(help_text='Select which shops you would like the carousel to be visible in.', related_name='carousels', to='shuup.Shop', verbose_name='shops'),
        ),
        migrations.RunPython(add_shop_for_carousels, migrations.RunPython.noop)
    ]
