# -*- coding: utf-8 -*-
# Generated by Django 1.9.11 on 2016-12-07 21:33
from __future__ import unicode_literals

from django.db import migrations
from markdown import Markdown


def update_field(model, field):
    md = Markdown(extensions=[
        'markdown.extensions.extra',
        'markdown.extensions.nl2br',
    ], output_format="html5")

    for f in model.objects.all():
        val = getattr(f, field)
        if val:
            try:
                setattr(f, field, md.convert(val))
                f.save()
            except:
                # not valid markdown - leave it as-is
                pass


def md_to_html(apps, schema_editor):
    PageTranslation = apps.get_model("shuup_simple_cms", "PageTranslation")
    update_field(PageTranslation, "content")


class Migration(migrations.Migration):

    dependencies = [
        ('shuup_simple_cms', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(md_to_html, migrations.RunPython.noop)
    ]
