# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2018-11-22 17:57
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields
import filer.fields.image
import parler.models
import shuup.simple_cms.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
        ('shuup_simple_cms', '0010_add_render_title_and_template_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='PageOpenGraph',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('og_type', enumfields.fields.EnumField(default='website', enum=shuup.simple_cms.models.PageOpenGraphType, max_length=10, verbose_name='type')),
                ('image', filer.fields.image.FilerImageField(blank=True, help_text='The image of your object.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='blog_meta_image', to=settings.FILER_IMAGE_MODEL, verbose_name='Image')),
            ],
            options={
                'abstract': False,
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PageOpenGraphTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('title', models.CharField(blank=True, help_text='The title of your object as it should appear within the graph, e.g. The Rock.', max_length=100, verbose_name='Title')),
                ('description', models.TextField(blank=True, help_text='A one to two sentence description of your object.', max_length=160, verbose_name='Description')),
                ('section', models.CharField(blank=True, help_text='A high-level section name, e.g. Technology. Only applicable when type is Article.', max_length=256, verbose_name='Section')),
                ('tags', models.CharField(blank=True, help_text='Tag words associated with this article. Only applicable when type is Article.', max_length=256, verbose_name='Tags')),
                ('article_author', models.CharField(blank=True, help_text='The name of the author for the article. Only applicable when type is Article.', max_length=100, verbose_name='Article author')),
                ('master', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='shuup_simple_cms.PageOpenGraph')),
            ],
            options={
                'verbose_name': 'page open graph Translation',
                'db_table': 'shuup_simple_cms_pageopengraph_translation',
                'db_tablespace': '',
                'managed': True,
                'default_permissions': (),
            },
        ),
        migrations.AlterField(
            model_name='page',
            name='available_from',
            field=models.DateTimeField(blank=True, db_index=True, help_text='Set an available from date to restrict the page to be available only after a certain date and time. This is useful for pages describing sales campaigns or other time-sensitive pages.', null=True, verbose_name='available from'),
        ),
        migrations.AlterField(
            model_name='page',
            name='available_to',
            field=models.DateTimeField(blank=True, db_index=True, help_text='Set an available to date to restrict the page to be available only after a certain date and time. This is useful for pages describing sales campaigns or other time-sensitive pages.', null=True, verbose_name='available to'),
        ),
        migrations.AddField(
            model_name='pageopengraph',
            name='page',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='open_graph', to='shuup_simple_cms.Page', verbose_name='page'),
        ),
        migrations.AlterUniqueTogether(
            name='pageopengraphtranslation',
            unique_together=set([('language_code', 'master')]),
        ),
    ]
