# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2018-05-30 20:13
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields
import jsonfield.fields
import parler.models
import shuup.core.fields
import shuup.tasks.models
import shuup.utils.analog


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('shuup', '0045_disable_default_marketing_permission'),
    ]

    operations = [
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, verbose_name='name')),
                ('status', enumfields.fields.EnumIntegerField(default=1, enum=shuup.tasks.models.TaskStatus, verbose_name='status')),
                ('priority', models.PositiveIntegerField(db_index=True, default=0, verbose_name='priority')),
                ('completed_on', models.DateTimeField(blank=True, null=True, verbose_name='completed on')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_index=True, verbose_name='modified on')),
                ('assigned_to', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='assigned_tasks', to='shuup.Contact', verbose_name='assigned to')),
                ('completed_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='completed_tasks', to='shuup.Contact', verbose_name='completed by')),
                ('creator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='creted_tasks', to='shuup.Contact', verbose_name='creator')),
                ('shop', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tasks', to='shuup.Shop', verbose_name='shop')),
            ],
        ),
        migrations.CreateModel(
            name='TaskComment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('visibility', enumfields.fields.EnumIntegerField(db_index=True, default=1, enum=shuup.tasks.models.TaskCommentVisibility, verbose_name='visibility')),
                ('body', models.TextField(verbose_name='body')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_index=True, verbose_name='modified on')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='task_comments', to='shuup.Contact', verbose_name='author')),
                ('task', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='shuup_tasks.Task', verbose_name='task')),
            ],
        ),
        migrations.CreateModel(
            name='TaskLogEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, verbose_name='created on')),
                ('message', models.CharField(max_length=256, verbose_name='message')),
                ('identifier', models.CharField(blank=True, max_length=64, verbose_name='identifier')),
                ('kind', enumfields.fields.EnumIntegerField(default=0, enum=shuup.utils.analog.LogEntryKind, verbose_name='log entry kind')),
                ('extra', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='extra data')),
                ('target', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='log_entries', to='shuup_tasks.Task', verbose_name='target')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TaskType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', shuup.core.fields.InternalIdentifierField(blank=True, editable=False, max_length=64, null=True, unique=False)),
                ('shop', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='task_types', to='shuup.Shop', verbose_name='shop')),
            ],
            options={
                'verbose_name': 'task type',
                'verbose_name_plural': 'task types',
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='TaskTypeTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('name', models.TextField(verbose_name='name')),
                ('master', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='shuup_tasks.TaskType')),
            ],
            options={
                'db_tablespace': '',
                'managed': True,
                'default_permissions': (),
                'verbose_name': 'task type Translation',
                'db_table': 'shuup_tasks_tasktype_translation',
            },
        ),
        migrations.AddField(
            model_name='task',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tasks', to='shuup_tasks.TaskType', verbose_name='task type'),
        ),
        migrations.AlterUniqueTogether(
            name='tasktypetranslation',
            unique_together=set([('language_code', 'master')]),
        ),
        migrations.AlterUniqueTogether(
            name='tasktype',
            unique_together=set([('shop', 'identifier')]),
        ),
    ]
