# -*- coding: utf-8 -*-
# Generated by Django 1.9.11 on 2016-12-07 23:22
from __future__ import unicode_literals

from django.db import migrations

from markdown import Markdown
import six


def safe_convert(str):
    md = Markdown(extensions=[
        'markdown.extensions.extra',
        'markdown.extensions.nl2br',
    ], output_format="html5")
    try:
        return md.convert(str)
    except:
        return str


def md_to_html(apps, schema_editor):
    SavedViewConfig = apps.get_model("shuup_xtheme", "SavedViewConfig")
    for config in SavedViewConfig.objects.all():
        record_changed = False
        layouts = config._data.get("layouts", {})
        for placeholder_name in six.iterkeys(layouts):
            rows = layouts[placeholder_name].get("rows", [])
            for row in rows:
                plugins = row.get("cells", [])
                for plugin in plugins:
                    if plugin.get("plugin") != "text":
                        continue
                    text_config = plugin.get("config", {})
                    texts = text_config.get("text", {})
                    if isinstance(texts, six.string_types):
                        text_config["text"] = safe_convert(texts)
                        record_changed = True
                    else:
                        for lang in six.iterkeys(texts):
                            # phew! finally
                            texts[lang] = safe_convert(texts[lang])
                            record_changed = True
        if record_changed:
            config.save()


class Migration(migrations.Migration):

    dependencies = [
        ('shuup_xtheme', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(md_to_html, migrations.RunPython.noop)
    ]
