# This file is part of Shuup.
#
# Copyright (c) 2012-2021, Shoop Commerce Ltd. All rights reserved.
#
# This source code is licensed under the OSL-3.0 license found in the
# LICENSE file in the root directory of this source tree.
from .commands import COMMANDS
from .excludes import (
    add_exclude_patters, get_exclude_patterns, set_exclude_patters
)
from .finding import find_packages
from .parsing import get_long_description, get_test_requirements_from_tox_ini
from .resource_building import build_resources
from .versions import get_version, write_version_to_file

__all__ = [
    'COMMANDS',
    'build_resources',
    'find_packages',
    'add_exclude_patters',
    'get_exclude_patterns',
    'get_long_description',
    'get_test_requirements_from_tox_ini',
    'get_version',
    'set_exclude_patters',
    'write_version_to_file',
]
