// Dialog2.cpp : ʵļ
//

#include "stdafx.h"
#include "TestSkin.h"
#include "Dialog2.h"


// CDialog2 Ի

IMPLEMENT_DYNAMIC(CDialog2, CDialog)

CDialog2::CDialog2(CWnd* pParent /*=NULL*/)
	: CDialog(CDialog2::IDD, pParent)
{
	AfxInitRichEdit();
}

CDialog2::~CDialog2()
{
}

void CDialog2::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SCROLLBAR2, m_ctrScrollBar2);
	DDX_Control(pDX, IDC_SCROLLBAR5, m_ctrScrollBar5);
	DDX_Control(pDX, IDC_COMBO1, m_ctrCombo1);
}


BEGIN_MESSAGE_MAP(CDialog2, CDialog)
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
END_MESSAGE_MAP()


// CDialog2 Ϣ

BOOL CDialog2::OnInitDialog()
{
	CDialog::OnInitDialog();

	CString strInfo;
	m_ImageList.Create(16,16,ILC_COLOR32|ILC_MASK,0, 0);
	m_ImageList.Add(AfxGetApp()->LoadIcon(IDI_ICON1));

	////////////////////////////////////////////////
	
	CListBox *pList=(CListBox*)GetDlgItem(IDC_LIST1);
	for(int i=0;i<20;i++)
	{
		strInfo.Format("List Box - %d",i+1);
		pList->AddString(strInfo);
	}

	////////////////////////////////////////////////

	CListCtrl *pListCtrl=(CListCtrl*)GetDlgItem(IDC_LIST2);
	pListCtrl->SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_CHECKBOXES);

	pListCtrl->InsertColumn(0,"Item-01",LVCFMT_LEFT,250,-1);
	pListCtrl->InsertColumn(1,"Item-02",LVCFMT_LEFT,150,-1);
	pListCtrl->InsertColumn(2,"Item-03",LVCFMT_LEFT,60,-1);
	pListCtrl->InsertColumn(3,"Item-04",LVCFMT_LEFT,65,-1);
	pListCtrl->InsertColumn(4,"Item-05",LVCFMT_LEFT,120,-1);
	
	CString strItem;
	for(int i=0; i<40; i++)
	{
		strInfo.Format("ListCtrl - %d",i);
		pListCtrl->InsertItem(1, strInfo, 0);
		m_ctrCombo1.AddString(strInfo);
	}
	m_ctrCombo1.SetCurSel(0);

	/////////////////////////////////////////////

	CTreeCtrl* pTreeCtrl = (CTreeCtrl*)GetDlgItem(IDC_TREE1);
	pTreeCtrl->SetImageList(&m_ImageList,TVSIL_NORMAL);

	HTREEITEM hItem1=0,hItem2=0,hItem3=0;
	for(int i=1; i<=10; i++)
	{
		strInfo.Format("Tree item - %d",i);
		hItem1=pTreeCtrl->InsertItem(strInfo,0);
		for(int n=1; n<=3; n++)
		{
			strInfo.Format("Tree item - %d.%d",i,n);
			hItem2=pTreeCtrl->InsertItem(strInfo,0,0,hItem1);
			for(int c=1; c<=3; c++)
			{
				strInfo.Format("Tree item - %d.%d.%d",i,n,c);
				hItem3=pTreeCtrl->InsertItem(strInfo,0,0,hItem2);
				for(int s=1; s<=3; s++)
				{
					strInfo.Format("Tree item - %d.%d.%d.%d",i,n,c,s);
					pTreeCtrl->InsertItem(strInfo,0,0,hItem3);
				}
			}
		}
	}
	
	m_ctrScrollBar2.SetScrollRange(0,50);
	m_ctrScrollBar5.SetScrollRange(0,50);

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}

void CDialog2::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	if(pScrollBar)
	{
		SCROLLINFO si;
		pScrollBar->GetScrollInfo(&si);

		switch(nSBCode)
		{
		case SB_LINEUP:
			{
				nPos=(si.nPos<=si.nMin)?si.nMin:si.nPos-1;
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_LINEDOWN:
			{
				nPos=(si.nPos>=si.nMax)?si.nMax:si.nPos+1;
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_ENDSCROLL:
			{
				pScrollBar->SetScrollPos(si.nPos);
				break;
			}
		case SB_THUMBTRACK:
			{
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_THUMBPOSITION:
			{
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_PAGEUP:
			{
				nPos=(si.nPos<=si.nMin)?si.nMin:si.nPos-5;
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_PAGEDOWN:
			{
				nPos=(si.nPos>=si.nMax)?si.nMax:si.nPos+5;
				pScrollBar->SetScrollPos(nPos);
			}
		}	
	}

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CDialog2::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	if(pScrollBar)
	{
		SCROLLINFO si;
		pScrollBar->GetScrollInfo(&si);

		switch(nSBCode)
		{
		case SB_LINEUP:
			{
				nPos=(si.nPos<=si.nMin)?si.nMin:si.nPos-1;
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_LINEDOWN:
			{
				nPos=(si.nPos>=si.nMax)?si.nMax:si.nPos+1;
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_ENDSCROLL:
			{
				pScrollBar->SetScrollPos(si.nPos);
				break;
			}
		case SB_THUMBTRACK:
			{
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_THUMBPOSITION:
			{
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_PAGEUP:
			{
				nPos=(si.nPos<=si.nMin)?si.nMin:si.nPos-5;
				pScrollBar->SetScrollPos(nPos);
				break;
			}
		case SB_PAGEDOWN:
			{
				nPos=(si.nPos>=si.nMax)?si.nMax:si.nPos+5;
				pScrollBar->SetScrollPos(nPos);
			}
		}	
	}

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
