/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile14
extends JarFile
implements ResourceObject {
    private Reference manifestRef = null;
    private Reference signingDataRef = null;
    private URL resourceURL;
    private String resourceVersion;
    private File indexFile;
    private int[] emptySignerIndices = new int[0];
    private static Enumeration emptyEnumeration = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    private static Iterator emptyIterator = Collections.EMPTY_MAP.keySet().iterator();

    public String getName() {
        String string = super.getName();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return string;
        }
        try {
            securityManager.checkPermission(new RuntimePermission("accessDeploymentCache"));
            return string;
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new CachedJarFile14(new File(super.getName()), this.manifestRef, this.signingDataRef, this.resourceURL, this.resourceVersion, this.indexFile);
        }
        catch (IOException iOException) {
            throw new CloneNotSupportedException();
        }
    }

    public URL getResourceURL() {
        return this.resourceURL;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    private CachedJarFile14(File file, Reference reference, Reference reference2, URL uRL, String string, File file2) throws IOException {
        super(file, false);
        this.manifestRef = reference;
        this.signingDataRef = reference2;
        this.resourceURL = uRL;
        this.resourceVersion = string;
        this.indexFile = file2;
        MemoryCache.addResourceReference(this, uRL.toString());
    }

    protected CachedJarFile14(CacheEntry cacheEntry) throws IOException {
        this(new File(cacheEntry.getResourceFilename()), new SoftReference<Object>(null), new SoftReference<Object>(null), new URL(cacheEntry.getURL()), cacheEntry.getVersion(), cacheEntry.getIndexFile());
    }

    public void doClose() throws IOException {
        super.close();
    }

    public void close() throws IOException {
        if (!MemoryCache.hasReferencesTo(this)) {
            Trace.println("Closing CachedJarFile " + this.getName(), TraceLevel.CACHE);
            super.close();
        }
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                try {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    return new JarFileEntry(zipEntry);
                }
                catch (InternalError internalError) {
                    throw new InternalError("Error in CachedJarFile entries");
                }
            }
        };
    }

    private synchronized CacheEntry getCacheEntry() {
        if (this.resourceURL == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL.toString());
        if (cacheEntry == null || !this.indexFile.equals(cacheEntry.getIndexFile())) {
            String string = cacheEntry == null ? "No memory CacheEntry: " + this.resourceURL : "CachedJarFile.getCacheEntry: " + this.indexFile + " != " + cacheEntry.getIndexFile() + " for " + this.resourceURL;
            Trace.println(string, TraceLevel.CACHE);
            cacheEntry = CachedJarFile.recoverCacheEntry(this.indexFile, this.resourceURL, this.resourceVersion);
            if (cacheEntry != null) {
                this.clearReferences();
            }
        }
        return cacheEntry;
    }

    public synchronized Manifest getManifest() throws IOException {
        if (this.manifestRef == null) {
            return null;
        }
        Manifest manifest = (Manifest)this.manifestRef.get();
        if (manifest == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                manifest = cacheEntry.getManifest();
            } else {
                Trace.println("Warning: NULL cache entry for loaded resource!", TraceLevel.CACHE);
            }
            this.manifestRef = manifest != null ? new SoftReference<Manifest>(manifest) : null;
        }
        return manifest;
    }

    private synchronized JarSigningData getSigningData() {
        if (this.signingDataRef == null) {
            return null;
        }
        JarSigningData jarSigningData = (JarSigningData)this.signingDataRef.get();
        if (jarSigningData == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                jarSigningData = cacheEntry.getJarSigningData();
                this.signingDataRef = jarSigningData != null ? new SoftReference<JarSigningData>(jarSigningData) : null;
            } else {
                Trace.println("getSignerMap failed to get CacheEntry for " + this.resourceURL, TraceLevel.CACHE);
            }
        }
        return jarSigningData;
    }

    private synchronized Map getCertificateMap() {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.getCertificateMap() : null;
    }

    private synchronized Certificate[] getCertificates() {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.getCertificates() : null;
    }

    private boolean hasStrictSingleSigning() {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.hasStrictSingleSigning() : false;
    }

    private synchronized void clearReferences() {
        CachedJarFile.clear(new Reference[]{this.manifestRef, this.signingDataRef});
    }

    private int[] findMatchingSignerIndices(CodeSource codeSource) {
        Map map = this.getCodeSourceCertCache();
        if (map == null) {
            return this.emptySignerIndices;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(codeSource)) continue;
            return (int[])entry.getKey();
        }
        if (codeSource.getCertificates() == null) {
            return this.emptySignerIndices;
        }
        return null;
    }

    Enumeration entryNames(CodeSource[] codeSourceArray) {
        Object object;
        boolean bl = false;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(codeSourceArray.length);
        for (int i = 0; i < codeSourceArray.length; ++i) {
            object = this.findMatchingSignerIndices(codeSourceArray[i]);
            if (object == null) continue;
            if (((int[])object).length > 0) {
                arrayList.add((int[])object);
                continue;
            }
            bl = true;
        }
        Map map = this.getCertificateMap();
        if (map != null && !map.isEmpty() && this.hasStrictSingleSigning() && !arrayList.isEmpty()) {
            map = null;
            bl = true;
            arrayList.clear();
        }
        object = arrayList;
        Map map2 = map;
        final Iterator iterator = map2 != null ? map2.keySet().iterator() : emptyIterator;
        Enumeration enumeration = bl ? this.unsignedEntryNames(map2) : emptyEnumeration;
        return new Enumeration((List)object, map2, enumeration){
            String name;
            private final /* synthetic */ List val$signersReq;
            private final /* synthetic */ Map val$signerMap;
            private final /* synthetic */ Enumeration val$enum2;
            {
                this.val$signersReq = list;
                this.val$signerMap = map;
                this.val$enum2 = enumeration;
            }

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (this.val$signersReq.contains((int[])this.val$signerMap.get(string))) {
                        this.name = string;
                        return true;
                    }
                    Trace.println("entryNames checking signer failed for " + string, TraceLevel.CACHE);
                }
                if (this.val$enum2.hasMoreElements()) {
                    this.name = (String)this.val$enum2.nextElement();
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private Enumeration unsignedEntryNames(final Map map) {
        final Enumeration enumeration = this.entries();
        return new Enumeration(){
            String name;

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    String string = zipEntry.getName();
                    if (zipEntry.isDirectory() || JarUtil.isSigningRelated(string) || map != null && map.get(string) != null) continue;
                    this.name = string;
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    synchronized CodeSource[] getCodeSources(URL uRL) {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSources(uRL) : null;
    }

    synchronized Map getCodeSourceCertCache() {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSourceCertCache() : null;
    }

    synchronized CodeSource getCodeSource(URL uRL, String string) {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSource(uRL, string) : null;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = CachedJarFile14.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray = null;
            int[] nArray = this.getCertIndices();
            Certificate[] certificateArray2 = CachedJarFile14.this.getCertificates();
            if (certificateArray2 != null && nArray != null) {
                certificateArray = new Certificate[certificateArray2.length];
                for (int i = 0; i < certificateArray2.length; ++i) {
                    certificateArray[i] = certificateArray2[nArray[i]];
                }
            }
            return certificateArray;
        }

        private int[] getCertIndices() {
            Map map = CachedJarFile14.this.getCertificateMap();
            String string = this.getName();
            if (map == null || map.isEmpty()) {
                return null;
            }
            if (CachedJarFile14.this.hasStrictSingleSigning()) {
                if (!JarUtil.isSigningRelated(string) && !string.endsWith("/")) {
                    return (int[])map.get(null);
                }
                return null;
            }
            return (int[])map.get(string);
        }
    }
}

